/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageFactory;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import java.nio.ByteBuffer;

public class MessageSerializer {
    public static final int MSG_DATA_OFFSET = 12;
    public static final int MSG_TYPE_OFFSET = 0;
    public static final int MSG_UID_OFFSET = 4;
    public static final int MSG_DATA_SIZE_OFFSET = 8;

    public int getMessageSize(byte[] byArray) {
        if (byArray.length < 12) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = byteBuffer.getInt(8);
        if (byArray.length < (n2 += 12)) {
            return -1;
        }
        return n2;
    }

    public Message deserialize(byte[] byArray, int n2) {
        if (byArray.length < n2) {
            throw new IllegalStateException("Bytes length must be > messageSize.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n2);
        int n3 = byteBuffer.getInt(0);
        n2 = byteBuffer.getInt(4);
        Object object = MessageType.from(n3);
        object = MessageFactory.create(object, n2);
        object.deserialize(byteBuffer.array());
        return object;
    }

    public byte[] serialize(Message message) {
        Object object = new byte[message.getSize()];
        message.serialize((byte[])object);
        return object;
    }
}

