/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class ShapeFactory {
    private static final double a = Math.sqrt(2.0);
    private static final double b = Math.sqrt(3.0);

    private ShapeFactory() {
    }

    public static Polygon createDownTriangle(double d2, double d3, double d4) {
        Polygon polygon = new Polygon();
        polygon.addPoint((int)(d2 - 0.5 * d4), (int)(d3 - 0.5 * d4));
        polygon.addPoint((int)Math.round(d2 + 0.5 * d4), (int)(d3 - 0.5 * d4));
        polygon.addPoint((int)d2, (int)Math.round(d3 + 0.5 * d4));
        return polygon;
    }

    public static Shape createDownTriangle2D(double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d2 - 0.5 * d4), (float)(d3 - 0.5 * d4 / b));
        generalPath.lineTo((float)(d2 + 0.5 * d4), (float)(d3 - 0.5 * d4 / b));
        generalPath.lineTo((float)d2, (float)(d3 + d4 / b));
        generalPath.closePath();
        return generalPath;
    }

    public static Polygon createUpTriangle(double d2, double d3, double d4) {
        Polygon polygon = new Polygon();
        polygon.addPoint((int)(d2 - 0.5 * (d4 + 1.0)), (int)(d3 + 0.5 * d4));
        polygon.addPoint((int)Math.round(d2 + 0.5 * (d4 + 1.0)), (int)(d3 + 0.5 * d4));
        polygon.addPoint((int)d2, (int)(d3 - 0.5 * (d4 + 1.0)));
        return polygon;
    }

    public static Shape createUpTriangle2D(double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d2 - 0.5 * d4), (float)(d3 + 0.5 * d4 / b));
        generalPath.lineTo((float)(d2 + 0.5 * d4), (float)(d3 + 0.5 * d4 / b));
        generalPath.lineTo((float)d2, (float)(d3 - d4 / b));
        generalPath.closePath();
        return generalPath;
    }

    public static Polygon createDiamond(double d2, double d3, double d4) {
        Polygon polygon = new Polygon();
        polygon.addPoint((int)d2, (int)(d3 - d4 / a));
        polygon.addPoint((int)Math.ceil(d2 + d4 / a), (int)d3);
        polygon.addPoint((int)d2, (int)Math.ceil(d3 + d4 / a));
        polygon.addPoint((int)(d2 - d4 / a), (int)d3);
        return polygon;
    }

    public static Shape createDiamond2D(double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2, d3 - d4 / a);
        generalPath.lineTo(d2 + d4 / a, d3);
        generalPath.lineTo(d2, d3 + d4 / a);
        generalPath.lineTo(d2 - d4 / a, d3);
        generalPath.closePath();
        return generalPath;
    }
}

