/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.RawPort;
import gnu.io.RawPortEvent;
import gnu.io.RawPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class Raw
extends RawPort {
    private int ciAddress;
    static boolean dsrFlag;
    private final RawOutputStream out = new RawOutputStream();
    private final RawInputStream in = new RawInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout = 0;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private RawPortEventListener SPEventListener;
    private MonitorThread monThread;
    private int dataAvailable = 0;

    private static native void Initialize();

    public Raw(String name) throws PortInUseException {
        this.ciAddress = Integer.parseInt(name);
        this.open(this.ciAddress);
    }

    private native int open(int var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setRawPortParams(int b, int d, int s, int p) throws UnsupportedCommOperationException {
        this.nativeSetRawPortParams(b, d, s, p);
        this.speed = b;
        this.dataBits = d;
        this.stopBits = s;
        this.parity = p;
    }

    private native void nativeSetRawPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int flowcontrol) {
        try {
            this.setflowcontrol(flowcontrol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flowmode = flowcontrol;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        this.enableReceiveTimeout(0);
    }

    public void enableReceiveTimeout(int time) {
        if (time >= 0) {
            this.timeout = time;
            this.NativeEnableReceiveTimeoutThreshold(time, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid timeout");
        }
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int thresh) {
        if (thresh >= 0) {
            this.threshold = thresh;
            this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid Threshold");
        }
    }

    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    public void setInputBufferSize(int size) {
        this.InputBuffer = size;
    }

    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int size) {
        this.OutputBuffer = size;
    }

    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    private native void writeByte(int var1) throws IOException;

    private native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    private native void drain() throws IOException;

    private native int nativeavailable() throws IOException;

    private native int readByte() throws IOException;

    private native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public void sendEvent(int event, boolean state) {
        switch (event) {
            case 1: {
                this.dataAvailable = 1;
                if (this.monThread.Data) break;
                return;
            }
            case 2: {
                if (this.monThread.Output) break;
                return;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return;
            }
            case 5: {
                if (this.monThread.RI) break;
                return;
            }
            case 6: {
                if (this.monThread.CD) break;
                return;
            }
            case 7: {
                if (this.monThread.OE) break;
                return;
            }
            case 8: {
                if (this.monThread.PE) break;
                return;
            }
            case 9: {
                if (this.monThread.FE) break;
                return;
            }
            case 10: {
                if (this.monThread.BI) break;
                return;
            }
            default: {
                System.err.println("unknown event:" + event);
                return;
            }
        }
        RawPortEvent e = new RawPortEvent(this, event, !state, state);
        if (this.SPEventListener != null) {
            this.SPEventListener.RawEvent(e);
        }
    }

    public void addEventListener(RawPortEventListener lsnr) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = lsnr;
        this.monThread = new MonitorThread();
        this.monThread.setDaemon(true);
        this.monThread.start();
    }

    public void removeEventListener() {
        this.SPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    public void notifyOnDataAvailable(boolean enable) {
        this.monThread.Data = enable;
    }

    public void notifyOnOutputEmpty(boolean enable) {
        this.monThread.Output = enable;
    }

    public void notifyOnCTS(boolean enable) {
        this.monThread.CTS = enable;
    }

    public void notifyOnDSR(boolean enable) {
        this.monThread.DSR = enable;
    }

    public void notifyOnRingIndicator(boolean enable) {
        this.monThread.RI = enable;
    }

    public void notifyOnCarrierDetect(boolean enable) {
        this.monThread.CD = enable;
    }

    public void notifyOnOverrunError(boolean enable) {
        this.monThread.OE = enable;
    }

    public void notifyOnParityError(boolean enable) {
        this.monThread.PE = enable;
    }

    public void notifyOnFramingError(boolean enable) {
        this.monThread.FE = enable;
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.monThread.BI = enable;
    }

    private native int nativeClose();

    public void close() {
        this.setDTR(false);
        this.setDSR(false);
        this.nativeClose();
        super.close();
        this.ciAddress = 0;
    }

    protected void finalize() {
        this.close();
    }

    public String getVersion() {
        String Version2 = "$Id: Raw.java,v 1.1.2.19 2012/06/04 21:39:05 jarvi Exp $";
        return Version2;
    }

    static {
        System.loadLibrary("rxtxRaw");
        Raw.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private boolean CTS = false;
        private boolean DSR = false;
        private boolean RI = false;
        private boolean CD = false;
        private boolean OE = false;
        private boolean PE = false;
        private boolean FE = false;
        private boolean BI = false;
        private boolean Data = false;
        private boolean Output = false;

        MonitorThread() {
            this.setDaemon(true);
        }

        public void run() {
            Raw.this.eventLoop();
        }
    }

    class RawInputStream
    extends InputStream {
        RawInputStream() {
        }

        public int read() throws IOException {
            Raw.this.dataAvailable = 0;
            return Raw.this.readByte();
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            Raw.this.dataAvailable = 0;
            int Minimum = 0;
            int[] intArray = new int[]{b.length, Raw.this.InputBuffer, len};
            for (i = 0; intArray[i] == 0 && i < intArray.length; ++i) {
            }
            Minimum = intArray[i];
            while (i < intArray.length) {
                if (intArray[i] > 0) {
                    Minimum = Math.min(Minimum, intArray[i]);
                }
                ++i;
            }
            if ((Minimum = Math.min(Minimum, Raw.this.threshold)) == 0) {
                Minimum = 1;
            }
            int Available = this.available();
            int Ret = Raw.this.readArray(b, off, Minimum);
            return Ret;
        }

        public int available() throws IOException {
            return Raw.this.nativeavailable();
        }
    }

    class RawOutputStream
    extends OutputStream {
        RawOutputStream() {
        }

        public void write(int b) throws IOException {
            Raw.this.writeByte(b);
        }

        public void write(byte[] b) throws IOException {
            Raw.this.writeArray(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            Raw.this.writeArray(b, off, len);
        }

        public void flush() throws IOException {
            Raw.this.drain();
        }
    }
}

