/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.tokenmatch;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.text.TextUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.tokenmatch.TokenMatchSyntaxLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class TokenMatchPopup {
    private static TokenMatchPopup sTokenMatchViewer = new TokenMatchPopup();
    private Timer fMatchTimer;
    private TimerAndMouseListener fForwardingListener = new TimerAndMouseListener();
    public static final int MATCH_DELAY = 1000;
    private MPopup fPopup;
    private TokenMatchSyntaxLabel fDisplayLabel = new TokenMatchSyntaxLabel();
    private Tokenizer fTokenizer;
    private JTextComponent fParent;
    private int fCaretPos = -1;
    private final DismissListener fListener;
    private final AppearanceFocusDispatcher fAppearanceFocusDispatcher;
    public static final int NO_LINE_NUMBER = -1;

    private TokenMatchPopup() {
        this.fDisplayLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.fDisplayLabel.addMouseListener(this.fForwardingListener);
        this.fMatchTimer = new Timer(1000, this.fForwardingListener);
        this.fMatchTimer.setRepeats(false);
        this.fListener = new DismissListener();
        this.fAppearanceFocusDispatcher = new AppearanceFocusDispatcher();
    }

    public static TokenMatchPopup getInstance() {
        return sTokenMatchViewer;
    }

    public static Color getHighlightBackgroundColor() {
        return ColorUtils.getSelectionBackgroundColor();
    }

    public static Color getHighlightForegroundColor() {
        return ColorUtils.getSelectionForegroundColor();
    }

    public void startTimer(JTextComponent jTextComponent, TokenMatchListener tokenMatchListener) {
        this.stopTimerAndNotify();
        this.setupComponentListeners(jTextComponent, tokenMatchListener);
        this.fMatchTimer.start();
    }

    public void startTimerAndShowPopupIfNecessary(JTextComponent jTextComponent, int[] nArray, boolean bl, int n, TokenMatchListener tokenMatchListener, Tokenizer tokenizer) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call from event dispatch thread";
        assert (nArray.length == 2 && nArray[0] < nArray[1]) : "Positions must be of length 2 and increasing";
        this.fTokenizer = tokenizer;
        try {
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTextComponent);
            Rectangle rectangle = jTextComponent.modelToView(nArray[0]);
            Rectangle rectangle2 = jTextComponent.modelToView(nArray[1] - 1);
            if (jScrollPane == null || rectangle == null || rectangle2 == null) {
                return;
            }
            Rectangle rectangle3 = new Rectangle();
            Rectangle.union(rectangle, rectangle2, rectangle3);
            Point point = rectangle3.getLocation();
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            rectangle3.setLocation(point);
            Rectangle rectangle4 = jScrollPane.getViewport().getVisibleRect();
            if (!jScrollPane.getViewport().isShowing()) {
                return;
            }
            rectangle4.setLocation(jScrollPane.getViewport().getLocationOnScreen());
            this.startTimer(jTextComponent, tokenMatchListener);
            if (!rectangle4.contains(rectangle3)) {
                boolean bl2;
                this.fDisplayLabel.setBackground(jTextComponent.getBackground());
                this.fDisplayLabel.setForeground(jTextComponent.getForeground());
                this.fDisplayLabel.setFont(jTextComponent.getFont());
                boolean bl3 = point.x < rectangle4.x;
                boolean bl4 = point.x + rectangle3.width > rectangle4.x + rectangle4.width;
                boolean bl5 = point.y < rectangle4.y;
                boolean bl6 = bl2 = point.y + rectangle3.height > rectangle4.y + rectangle4.height;
                assert (bl3 || bl4 || bl5 || bl2) : "none of top, left, bottom, or right is true";
                boolean bl7 = false;
                if (TokenMatchPopup.outOfScreenBounds(rectangle4, bl3, bl4)) {
                    bl7 = true;
                    bl2 = true;
                }
                TokenMatchSyntaxLabel.ShowLocation showLocation = bl2 || bl5 ? (bl3 ? TokenMatchSyntaxLabel.ShowLocation.SHOW_COMPLETE_LINE_LEFT : TokenMatchSyntaxLabel.ShowLocation.SHOW_COMPLETE_LINE_RIGHT) : (bl3 ? TokenMatchSyntaxLabel.ShowLocation.SHOW_LEFT : TokenMatchSyntaxLabel.ShowLocation.SHOW_RIGHT);
                Point point2 = bl5 || bl2 ? TokenMatchPopup.getShowPointTopBottom(bl5, bl7, rectangle4, rectangle3) : TokenMatchPopup.getShowPointLeftRight(bl3, rectangle4, rectangle3);
                TokenMatchSyntaxLabel.SetTextResult setTextResult = this.setTextInLabel(jTextComponent, rectangle4, nArray, point2, showLocation, n);
                if ((showLocation == TokenMatchSyntaxLabel.ShowLocation.SHOW_LEFT || showLocation == TokenMatchSyntaxLabel.ShowLocation.SHOW_RIGHT) && setTextResult == TokenMatchSyntaxLabel.SetTextResult.SUCCESS_COMPLETE_LINE) {
                    bl2 = true;
                    bl7 = true;
                    point2 = TokenMatchPopup.getShowPointTopBottom(bl5, bl7, rectangle4, rectangle3);
                }
                if (setTextResult != TokenMatchSyntaxLabel.SetTextResult.NOT_ENOUGH_ROOM) {
                    this.fDisplayLabel.adjustShowLocationForLabelSize(bl3, bl5, bl2, point2);
                    if (bl) {
                        this.fDisplayLabel.setStyleUnderline();
                    } else {
                        this.fDisplayLabel.setStyleHighlighted(TokenMatchPopup.getHighlightBackgroundColor(), TokenMatchPopup.getHighlightForegroundColor());
                    }
                    this.fPopup = MPopup.getPopup((Component)jTextComponent, (Component)((Object)this.fDisplayLabel), (int)point2.x, (int)point2.y);
                    assert (this.fDisplayLabel.getText() != null && this.fDisplayLabel.getText().length() > 0) : "popup is empty";
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (TokenMatchPopup.this.fPopup != null && TokenMatchPopup.this.fParent != null) {
                                TokenMatchPopup.this.fPopup.show();
                                if (TokenMatchPopup.this.fParent.getParent() instanceof JViewport) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (TokenMatchPopup.this.fParent != null && TokenMatchPopup.this.fParent.getParent() != null) {
                                                JViewport jViewport = (JViewport)TokenMatchPopup.this.fParent.getParent();
                                                jViewport.addChangeListener(TokenMatchPopup.this.fListener);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static Point getShowPointLeftRight(boolean bl, Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point();
        point.x = bl ? Math.max(rectangle2.x + rectangle2.width, rectangle.x) : Math.min(rectangle.x + rectangle.width, rectangle2.x);
        point.y = rectangle2.y;
        return point;
    }

    private static Point getShowPointTopBottom(boolean bl, boolean bl2, Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point();
        point.x = rectangle.x;
        point.y = bl2 ? rectangle.y + rectangle.height : (bl ? Math.max(rectangle.y, rectangle2.y + rectangle2.height) : Math.min(rectangle.y + rectangle.height, rectangle2.y));
        return point;
    }

    private static boolean outOfScreenBounds(Rectangle rectangle, boolean bl, boolean bl2) {
        Rectangle rectangle2 = WindowUtils.getVirtualScreenBounds();
        return bl && rectangle.x <= rectangle2.x || bl2 && rectangle.x + rectangle.width >= rectangle2.x + rectangle2.width;
    }

    private TokenMatchSyntaxLabel.SetTextResult setTextInLabel(JTextComponent jTextComponent, Rectangle rectangle, int[] nArray, Point point, TokenMatchSyntaxLabel.ShowLocation showLocation, int n) throws BadLocationException {
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, jTextComponent);
        int n2 = jTextComponent.viewToModel(point2);
        int[] nArray2 = TextUtils.getLineStartAndEnd((JTextComponent)jTextComponent, (int)nArray[0]);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        assert (n3 == TextUtils.getLineStart((JTextComponent)jTextComponent, (int)(nArray[1] - 1))) : "matePosInView start and end must be on the same row";
        String string = jTextComponent.getText(n3, n4 - n3);
        int n5 = n4 - n3;
        int[] nArray3 = new int[]{nArray[0] - n3, nArray[1] - n3};
        int n6 = 0;
        if (showLocation == TokenMatchSyntaxLabel.ShowLocation.SHOW_COMPLETE_LINE_LEFT || showLocation == TokenMatchSyntaxLabel.ShowLocation.SHOW_COMPLETE_LINE_RIGHT) {
            assert (nArray[0] - n3 >= 0) : "matePosInView - rowStart not >= 0: " + Arrays.toString(nArray) + " - " + n3;
        } else if (showLocation == TokenMatchSyntaxLabel.ShowLocation.SHOW_LEFT) {
            n2 = Math.max(n2, nArray[1]);
            assert (nArray[0] - n3 >= 0) : "matePosInView - rowStart not >= 0: " + Arrays.toString(nArray) + " - " + n3;
            n5 = n2 - n3;
        } else {
            n2 = Math.min(n2, nArray[0]);
            assert (nArray[0] - n2 >= 0) : "matePosInView - showPos not >= 0: " + Arrays.toString(nArray) + " - " + n2;
            n6 = n2 - n3;
        }
        return this.fDisplayLabel.setTextProperties(nArray3, string, n6, n5, n, this.fTokenizer, rectangle, showLocation);
    }

    private void hide() {
        if (this.fParent != null) {
            JComponent jComponent;
            Rectangle rectangle = null;
            if (this.isPopupShowing()) {
                rectangle = this.fPopup.getBounds();
                if (this.fParent.getParent() instanceof JViewport) {
                    jComponent = (JViewport)this.fParent.getParent();
                    ((JViewport)jComponent).removeChangeListener(this.fListener);
                }
                this.fPopup.hide();
                this.fPopup = null;
            }
            if ((jComponent = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.fParent)) != null && jComponent.isShowing() && rectangle != null) {
                jComponent.repaint(rectangle.x - jComponent.getLocationOnScreen().x, rectangle.y - jComponent.getLocationOnScreen().y, rectangle.width, rectangle.height);
            }
        }
    }

    private void cleanupComponentListeners() {
        this.fForwardingListener.setTokenMatchListener(null);
        if (this.fParent != null) {
            this.fParent.removeKeyListener(this.fListener);
            this.fParent.removeCaretListener(this.fListener);
            this.fParent.removeFocusListener((FocusListener)this.fAppearanceFocusDispatcher);
            this.fAppearanceFocusDispatcher.removeAppearanceFocusListener((AppearanceFocusListener)this.fListener);
            Window window = SwingUtilities.getWindowAncestor(this.fParent);
            if (window != null) {
                window.removeComponentListener(this.fListener);
            }
            this.fParent = null;
            this.fCaretPos = -1;
        }
    }

    private void setupComponentListeners(JTextComponent jTextComponent, TokenMatchListener tokenMatchListener) {
        this.fParent = jTextComponent;
        this.fCaretPos = this.fParent.getCaret().getDot();
        this.fForwardingListener.setTokenMatchListener(tokenMatchListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TokenMatchPopup.this.fParent != null) {
                    TokenMatchPopup.this.fParent.addKeyListener(TokenMatchPopup.this.fListener);
                    TokenMatchPopup.this.fParent.addCaretListener(TokenMatchPopup.this.fListener);
                    TokenMatchPopup.this.fAppearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)TokenMatchPopup.this.fListener);
                    TokenMatchPopup.this.fParent.addFocusListener((FocusListener)TokenMatchPopup.this.fAppearanceFocusDispatcher);
                    Window window = SwingUtilities.getWindowAncestor(TokenMatchPopup.this.fParent);
                    if (window != null) {
                        window.addComponentListener(TokenMatchPopup.this.fListener);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimerAndNotify() {
        try {
            if (this.fMatchTimer.isRunning()) {
                this.fMatchTimer.stop();
                this.fForwardingListener.actionPerformed(new ActionEvent(this, -1, ""));
            }
            if (this.isPopupShowing()) {
                this.hide();
            }
        }
        finally {
            this.cleanupComponentListeners();
        }
    }

    private boolean isPopupShowing() {
        return this.fPopup != null;
    }

    private class TimerAndMouseListener
    extends MouseAdapter
    implements ActionListener {
        private TokenMatchListener iParentListener;
        private boolean iHaveNotified;

        private TimerAndMouseListener() {
        }

        private void setTokenMatchListener(TokenMatchListener tokenMatchListener) {
            this.iParentListener = tokenMatchListener;
            this.iHaveNotified = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.iHaveNotified && this.iParentListener != null) {
                this.iParentListener.clearMatchIndications(TokenMatchPopup.this.isPopupShowing() ? TokenMatchPopup.this.fPopup.getBounds() : null);
                this.iHaveNotified = true;
            }
            if (TokenMatchPopup.this.isPopupShowing()) {
                TokenMatchPopup.this.fDisplayLabel.clearMarks();
            } else {
                TokenMatchPopup.this.cleanupComponentListeners();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.iParentListener != null) {
                this.iParentListener.userClickedOnPopup();
            }
        }
    }

    public static interface TokenMatchListener {
        public void clearMatchIndications(Rectangle var1);

        public void userClickedOnPopup();
    }

    private class DismissListener
    extends ComponentAdapter
    implements AppearanceFocusListener,
    ChangeListener,
    CaretListener,
    KeyListener {
        private DismissListener() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            TokenMatchPopup.this.stopTimerAndNotify();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            TokenMatchPopup.this.stopTimerAndNotify();
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            TokenMatchPopup.this.stopTimerAndNotify();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TokenMatchPopup.this.stopTimerAndNotify();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (TokenMatchPopup.this.fParent != null && TokenMatchPopup.this.fCaretPos != TokenMatchPopup.this.fParent.getCaret().getDot()) {
                TokenMatchPopup.this.stopTimerAndNotify();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            TokenMatchPopup.this.stopTimerAndNotify();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

