/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeBaseDocumentCache;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;

public class MTreeUpdater {
    private static final Map<STPBaseInterface, Map<UpdateInterval, NeedToUpdateListener>> REGISTERED_DOCS = new HashMap<STPBaseInterface, Map<UpdateInterval, NeedToUpdateListener>>();

    private MTreeUpdater() {
    }

    public static void startUpdates(STPBaseInterface sTPBaseInterface, UpdateInterval updateInterval, MTreeListener mTreeListener) {
        Map<UpdateInterval, NeedToUpdateListener> map;
        Object object;
        Validate.notNull((Object)sTPBaseInterface);
        Validate.notNull((Object)((Object)updateInterval));
        Validate.notNull((Object)mTreeListener);
        if (!REGISTERED_DOCS.containsKey(sTPBaseInterface)) {
            object = new EnumMap(UpdateInterval.class);
            REGISTERED_DOCS.put(sTPBaseInterface, (Map<UpdateInterval, NeedToUpdateListener>)object);
        }
        if ((map = REGISTERED_DOCS.get(sTPBaseInterface)).containsKey((Object)updateInterval)) {
            object = map.get((Object)updateInterval);
        } else {
            object = new NeedToUpdateListener(updateInterval, sTPBaseInterface);
            map.put(updateInterval, (NeedToUpdateListener)object);
        }
        ((NeedToUpdateListener)object).add(mTreeListener);
    }

    public static void stopUpdates(STPBaseInterface sTPBaseInterface, UpdateInterval updateInterval, MTreeListener mTreeListener) {
        Map<UpdateInterval, NeedToUpdateListener> map;
        Validate.notNull((Object)sTPBaseInterface);
        Validate.notNull((Object)((Object)updateInterval));
        if (REGISTERED_DOCS.containsKey(sTPBaseInterface) && (map = REGISTERED_DOCS.get(sTPBaseInterface)).containsKey((Object)updateInterval)) {
            NeedToUpdateListener needToUpdateListener = map.get((Object)updateInterval);
            needToUpdateListener.remove(mTreeListener);
            if (needToUpdateListener.isEmpty()) {
                map.remove((Object)updateInterval);
            }
            if (map.isEmpty()) {
                REGISTERED_DOCS.remove(sTPBaseInterface);
            }
        }
    }

    public static interface MTreeListener {
        public void treeUpdated(MTree var1);
    }

    private static class NeedToUpdateListener
    implements DocumentListener,
    CaretListener {
        private final Timer fTimer;
        private final Collection<MTreeListener> fListeners = new ArrayList<MTreeListener>();
        private final UpdateInterval fInterval;
        private final STPBaseInterface fTextPane;

        private NeedToUpdateListener(UpdateInterval updateInterval, final STPBaseInterface sTPBaseInterface) {
            this.fTimer = new Timer(updateInterval.getInterval(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (MTreeListener mTreeListener : NeedToUpdateListener.this.fListeners) {
                        mTreeListener.treeUpdated(MTreeBaseDocumentCache.getMTree((BaseDocument)sTPBaseInterface.getDocument()));
                    }
                }
            });
            this.fTimer.setRepeats(false);
            this.fInterval = updateInterval;
            this.fTextPane = sTPBaseInterface;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.fTimer.restart();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.fTimer.restart();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.fTimer.restart();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.fTimer.restart();
        }

        public void add(MTreeListener mTreeListener) {
            if (this.fListeners.isEmpty()) {
                this.fInterval.add(this, this.fTextPane);
            }
            this.fListeners.add(mTreeListener);
        }

        public void remove(MTreeListener mTreeListener) {
            this.fListeners.remove(mTreeListener);
            if (this.fListeners.isEmpty()) {
                this.fTimer.stop();
                this.fInterval.remove(this, this.fTextPane);
            }
        }

        public boolean isEmpty() {
            return this.fListeners.isEmpty();
        }
    }

    public static enum UpdateInterval {
        IMMEDIATE(0),
        SYNTAX(200),
        CARET(250){

            @Override
            protected void remove(NeedToUpdateListener needToUpdateListener, STPBaseInterface sTPBaseInterface) {
                sTPBaseInterface.removeCaretListener(needToUpdateListener);
            }

            @Override
            protected void add(NeedToUpdateListener needToUpdateListener, STPBaseInterface sTPBaseInterface) {
                sTPBaseInterface.addCaretListener(needToUpdateListener);
            }
        }
        ,
        TYPING(750);

        private final int fInterval;

        private UpdateInterval(int n2) {
            this.fInterval = n2;
        }

        private int getInterval() {
            return this.fInterval;
        }

        protected void add(NeedToUpdateListener needToUpdateListener, STPBaseInterface sTPBaseInterface) {
            sTPBaseInterface.getDocument().addDocumentListener(needToUpdateListener);
        }

        protected void remove(NeedToUpdateListener needToUpdateListener, STPBaseInterface sTPBaseInterface) {
            sTPBaseInterface.getDocument().removeDocumentListener(needToUpdateListener);
        }
    }
}

