/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.menus.DefaultMenuBuilder;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.messagepanel.MessageModelListener;
import com.mathworks.widgets.messagepanel.MessagePanel;
import com.mathworks.widgets.messagepanel.MessagePanelListener;
import com.mathworks.widgets.messagepanel.MessagePanelPainter;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPBaseModelInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.layer.EditorTip;
import com.mathworks.widgets.text.layer.LayerActions;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.ToolTipAndComponentAWTListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;

public final class STPMessagePanel
implements ComponentBuilder {
    public static final String MESSAGE_PANEL_NAME = "EditorMessagePanel";
    private final MessagePanel fPanel;
    private final LayerMessageModel fModel;
    private final LayerMessagePainter fPainter;
    private final STPBaseInterface fSyntaxPane;
    private final boolean fShowTooltips;
    private final MessagePanelToolTipListener fAWTListener;
    private final ViewHierarchyChangeListener fHierarchyListener;
    private Set<EditorMessageBarContributor> fContributors = new HashSet<EditorMessageBarContributor>();
    private final Map<EditorMessageBarContributor, MessageModelListener> fTransientListenerMap = new HashMap<EditorMessageBarContributor, MessageModelListener>();
    private boolean fShowingTransientLayer;
    private boolean fPaintingSummary = false;
    private MouseEvent fLastEvent;
    private MessagePanel.TextAlignmentProvider fAlignmentProvider;
    private MessageModel<EditorMessage> fLastTransientModel;

    public STPMessagePanel(STPBaseInterface sTPBaseInterface) {
        this(sTPBaseInterface, true);
    }

    public STPMessagePanel(STPBaseInterface sTPBaseInterface, boolean bl) {
        Validate.notNull((Object)sTPBaseInterface);
        this.fShowTooltips = bl;
        this.fSyntaxPane = sTPBaseInterface;
        this.fModel = new LayerMessageModel();
        this.fPainter = new LayerMessagePainter();
        this.fAlignmentProvider = this.createTextAlignmentProvider();
        this.fPanel = this.createPanel();
        this.fAWTListener = bl ? new MessagePanelToolTipListener() : null;
        this.fHierarchyListener = new ViewHierarchyChangeListener(){

            @Override
            public void viewHierarchyChanged(ViewHierarchyChangeEvent viewHierarchyChangeEvent) {
                STPMessagePanel.this.fPanel.repaint();
            }
        };
        this.fSyntaxPane.addViewHierarchyChangeListener(this.fHierarchyListener);
        this.fModel.addListener(new MessageModelListener(){

            @Override
            public void messagesUpdated() {
                boolean bl = true;
                for (EditorMessageBarContributor editorMessageBarContributor : STPMessagePanel.this.fContributors) {
                    bl &= editorMessageBarContributor.isValid();
                }
                if (STPMessagePanel.this.fAWTListener != null) {
                    STPMessagePanel.this.fAWTListener.cleanupTip();
                }
                STPMessagePanel.this.fPanel.setPanelValid(bl);
            }
        });
    }

    private MessagePanel createPanel() {
        MessagePanel messagePanel = new MessagePanel(this.fModel, this.fPainter, false){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                if (this.isOverSummary(mouseEvent) && STPMessagePanel.this.fShowTooltips) {
                    EditorMessageBarContributor editorMessageBarContributor = STPMessagePanel.this.getSummaryContributor();
                    string = editorMessageBarContributor != null ? editorMessageBarContributor.getSummaryText() : null;
                } else if (STPMessagePanel.this.fShowTooltips) {
                    string = super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
        messagePanel.setName(MESSAGE_PANEL_NAME);
        messagePanel.putClientProperty("mwjavaguitest.instance", this);
        messagePanel.setTextAlignmentProvider(this.fAlignmentProvider);
        messagePanel.addListener(this.createPanelListener());
        messagePanel.addMouseListener((MouseListener)new PopupListener(){

            protected void showPopup(MouseEvent mouseEvent) {
                STPMessagePanel.this.showPopupMenu(mouseEvent);
            }
        });
        messagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                STPMessagePanel.this.setEventAndRepaint(mouseEvent);
            }
        });
        messagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                STPMessagePanel.this.setEventAndRepaint(null);
            }
        });
        return messagePanel;
    }

    private void setEventAndRepaint(MouseEvent mouseEvent) {
        this.fLastEvent = mouseEvent;
        this.fPanel.repaint();
    }

    private MessagePanel.TextAlignmentProvider createTextAlignmentProvider() {
        return new MessagePanel.TextAlignmentProvider(){

            @Override
            public Rectangle getRectangleAtLine(int n) throws BadLocationException {
                return n >= STPMessagePanel.this.fSyntaxPane.getNumLines() ? null : STPMessagePanel.this.fSyntaxPane.modelToView(STPMessagePanel.this.fSyntaxPane.getLineStart(n));
            }

            @Override
            public boolean isFullTextShowing() {
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, STPMessagePanel.this.fSyntaxPane.getActiveTextComponent());
                return jScrollPane != null && jScrollPane.getVerticalScrollBar() != null && jScrollPane.getVerticalScrollBar().getVisibleAmount() == jScrollPane.getVerticalScrollBar().getMaximum();
            }
        };
    }

    private MessagePanelListener<EditorMessage> createPanelListener() {
        return new MessagePanelListener<EditorMessage>(){

            @Override
            public void messageClicked(EditorMessage editorMessage) {
                STPMessagePanel.this.goToMessage(editorMessage);
            }

            @Override
            public void summarySquareClicked(boolean bl) {
                if (STPMessagePanel.this.fModel.getMessageCount() > 0) {
                    MessageModel messageModel = (MessageModel)STPMessagePanel.this.getSummaryContributor().getModel();
                    if (bl) {
                        LayerActions.createGoToNextAction(messageModel).actionPerformed(null, STPMessagePanel.this.fSyntaxPane.getActiveTextComponent());
                    } else {
                        LayerActions.createGoToPreviousAction(messageModel).actionPerformed(null, STPMessagePanel.this.fSyntaxPane.getActiveTextComponent());
                    }
                }
            }
        };
    }

    private void goToMessage(EditorMessage editorMessage) {
        this.fSyntaxPane.requestFocus();
        int n = editorMessage.getStartPosition();
        this.fSyntaxPane.selectAndCenterIfNotVisible(n, n);
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.buildContextMenu();
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(this.fPanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public JPopupMenu buildContextMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(new MJPopupMenu(), new MenuGroupID[0]);
        for (EditorMessageBarContributor editorMessageBarContributor : this.fContributors) {
            editorMessageBarContributor.contributeToContextMenu((MenuBuilder)defaultMenuBuilder);
        }
        return defaultMenuBuilder.getPopupMenu();
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    public void uninstall() {
        if (this.fAWTListener != null) {
            this.fAWTListener.uninstall();
        }
        this.fSyntaxPane.removeViewHierarchyChangeListener(this.fHierarchyListener);
        HashSet<EditorMessageBarContributor> hashSet = new HashSet<EditorMessageBarContributor>(this.fContributors);
        for (EditorMessageBarContributor editorMessageBarContributor : hashSet) {
            this.removeContributor(editorMessageBarContributor);
        }
    }

    public void addContributor(EditorMessageBarContributor editorMessageBarContributor) {
        Validate.notNull((Object)editorMessageBarContributor);
        if (this.fContributors.contains(editorMessageBarContributor)) {
            return;
        }
        this.fContributors.add(editorMessageBarContributor);
        final MessageModel messageModel = (MessageModel)editorMessageBarContributor.getModel();
        this.fModel.addModel(messageModel);
        if (editorMessageBarContributor.getPriority().equals((Object)EditorMessageBarContributor.Priority.TRANSIENT)) {
            MessageModelListener messageModelListener = new MessageModelListener(){

                @Override
                public void messagesUpdated() {
                    STPMessagePanel.this.fShowingTransientLayer = messageModel.getMessageCount() > 0;
                    if (STPMessagePanel.this.fShowingTransientLayer) {
                        STPMessagePanel.this.fLastTransientModel = messageModel;
                    }
                    STPMessagePanel.this.fLastEvent = null;
                }
            };
            messageModel.addListener(messageModelListener);
            this.fTransientListenerMap.put(editorMessageBarContributor, messageModelListener);
        }
        if (editorMessageBarContributor.isPaintingSummary()) {
            this.fPaintingSummary = true;
        }
    }

    public void removeContributor(EditorMessageBarContributor editorMessageBarContributor) {
        Validate.notNull((Object)editorMessageBarContributor);
        this.fContributors.remove(editorMessageBarContributor);
        if (editorMessageBarContributor.getPriority().equals((Object)EditorMessageBarContributor.Priority.TRANSIENT)) {
            ((MessageModel)editorMessageBarContributor.getModel()).removeListener(this.fTransientListenerMap.get(editorMessageBarContributor));
            this.fTransientListenerMap.remove(editorMessageBarContributor);
        }
        this.fModel.removeModel((MessageModel)editorMessageBarContributor.getModel());
        if (this.fPaintingSummary) {
            this.fPaintingSummary = false;
            for (EditorMessageBarContributor editorMessageBarContributor2 : this.fContributors) {
                if (!editorMessageBarContributor2.isPaintingSummary()) continue;
                this.fPaintingSummary = true;
                break;
            }
        }
    }

    public int numberOfContributors() {
        return this.fContributors.size();
    }

    public List<EditorMessage> getTooltipMessagesUnder(MouseEvent mouseEvent) {
        return this.fShowTooltips ? this.fPanel.getMessagesUnder(mouseEvent) : Collections.emptyList();
    }

    public void clickMessage(int n) {
        this.goToMessage(this.fModel.getMessageAt(n));
    }

    public STPBaseModelInterface getSyntaxPane() {
        return this.fSyntaxPane;
    }

    public LayerMessageModel getModel() {
        return this.fModel;
    }

    public MessageModel<EditorMessage> getActiveModel() {
        if (this.fShowingTransientLayer) {
            return this.fLastTransientModel;
        }
        if (this.getSummaryContributor() != null) {
            return (MessageModel)this.getSummaryContributor().getModel();
        }
        return this.fContributors.isEmpty() ? null : (MessageModel)((EditorMessageBarContributor)this.fContributors.toArray()[0]).getModel();
    }

    private boolean isTransient(MessageModel<EditorMessage> messageModel) {
        boolean bl = false;
        for (EditorMessageBarContributor editorMessageBarContributor : this.fTransientListenerMap.keySet()) {
            if (editorMessageBarContributor.getModel() != messageModel) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private EditorMessageBarContributor getSummaryContributor() {
        EditorMessageBarContributor editorMessageBarContributor = null;
        for (EditorMessageBarContributor editorMessageBarContributor2 : this.fContributors) {
            if (!editorMessageBarContributor2.isPaintingSummary() || !editorMessageBarContributor2.getPriority().equals((Object)EditorMessageBarContributor.Priority.ALWAYS_ON_PROVIDING_SUMMARY)) continue;
            if (editorMessageBarContributor == null) {
                editorMessageBarContributor = editorMessageBarContributor2;
                continue;
            }
            throw new IllegalStateException("Should only have one contributor providing a summary");
        }
        return editorMessageBarContributor;
    }

    public class LayerMessageModel
    implements MessageModel<EditorMessage> {
        private static final int TRANSIENT_PRIORITY_BASE = 500000;
        private final List<MessageModel<EditorMessage>> fModels = new ArrayList<MessageModel<EditorMessage>>();
        private final Set<MessageModelListener> fLayerModelListeners = new HashSet<MessageModelListener>();
        private final MessageModelListener fIndividualModelListener = this.createForwardingListener();
        private int fIndexIntoModel;

        private MessageModelListener createForwardingListener() {
            return new MessageModelListener(){

                @Override
                public void messagesUpdated() {
                    for (MessageModelListener messageModelListener : LayerMessageModel.this.fLayerModelListeners) {
                        messageModelListener.messagesUpdated();
                    }
                }
            };
        }

        @Override
        public int getMessageCount() {
            int n = 0;
            for (MessageModel<EditorMessage> messageModel : this.fModels) {
                n += messageModel.getMessageCount();
            }
            return n;
        }

        private MessageModel<EditorMessage> getModel(int n) {
            this.fIndexIntoModel = n;
            for (MessageModel<EditorMessage> messageModel : this.fModels) {
                if (this.fIndexIntoModel > messageModel.getMessageCount() - 1) {
                    this.fIndexIntoModel -= messageModel.getMessageCount();
                    continue;
                }
                return messageModel;
            }
            throw new IllegalStateException("Requested an out of bounds message");
        }

        @Override
        public EditorMessage getMessageAt(int n) {
            return this.getModel(n).getMessageAt(this.fIndexIntoModel);
        }

        @Override
        public String getTextAt(int n) {
            return this.getModel(n).getTextAt(this.fIndexIntoModel);
        }

        @Override
        public int getLineNumberAt(int n) {
            return this.getModel(n).getLineNumberAt(this.fIndexIntoModel);
        }

        @Override
        public int getPriorityAt(int n) {
            MessageModel<EditorMessage> messageModel = this.getModel(n);
            int n2 = STPMessagePanel.this.isTransient(messageModel) ? 500000 : 0;
            return n2 + messageModel.getPriorityAt(this.fIndexIntoModel);
        }

        @Override
        public MessageModel.Priority getModelPriority(int n) {
            return this.getModel(n).getModelPriority(this.fIndexIntoModel);
        }

        @Override
        public int getLineCount() {
            return STPMessagePanel.this.getSyntaxPane().getNumLines();
        }

        @Override
        public void addListener(MessageModelListener messageModelListener) {
            this.fLayerModelListeners.add(messageModelListener);
        }

        @Override
        public void removeListener(MessageModelListener messageModelListener) {
            this.fLayerModelListeners.remove(messageModelListener);
        }

        public void addModel(MessageModel<EditorMessage> messageModel) {
            Validate.notNull(messageModel, (String)"cannot add a null model");
            this.fModels.add(messageModel);
            messageModel.addListener(this.fIndividualModelListener);
        }

        public void removeModel(MessageModel<EditorMessage> messageModel) {
            Validate.notNull(messageModel, (String)"cannot remove a null model");
            messageModel.removeListener(this.fIndividualModelListener);
            this.fModels.remove(messageModel);
        }
    }

    private static class LayerTipStrategy
    implements EditorTip.MEditorTipStrategy {
        private LayerTipStrategy() {
        }

        @Override
        public String formatMessage(EditorMessage editorMessage) {
            return MessageFormat.format(LayerUtils.getBundle().getString("tooltip.barMessage"), String.valueOf(editorMessage.getLineNumber() + 1), editorMessage.getMessage());
        }

        @Override
        public List<BalloonToolTip.ArrowDirection> getPossiblePositions() {
            return BalloonToolTip.WEST_EAST;
        }
    }

    public class MessagePanelToolTipListener
    extends ToolTipAndComponentAWTListener {
        private EditorTip fTip;
        private List<EditorMessage> fMessageList;

        public MessagePanelToolTipListener() {
            super(STPMessagePanel.this.getComponent(), 0);
            this.fMessageList = Collections.emptyList();
        }

        @Override
        protected boolean shouldStartHideTimer() {
            return this.fTip != null && !this.fTip.isScrolling();
        }

        @Override
        protected void hideTip() {
            this.cleanupTip();
        }

        @Override
        public void uninstall() {
            this.fMessageList.clear();
            super.uninstall();
        }

        @Override
        protected void movedInsideSource(MouseEvent mouseEvent) {
            List<EditorMessage> list = STPMessagePanel.this.getTooltipMessagesUnder(mouseEvent);
            Window window = WindowUtils.getTopmostWindow((Component)STPMessagePanel.this.fPanel);
            if (!list.isEmpty() && window != null && window.isActive()) {
                if (!this.isSameList(list) || !this.isTipShowing()) {
                    if (this.isTipShowing()) {
                        this.cleanupTip();
                    }
                    assert (this.fTip == null) : "We should only have one tip at a time";
                    this.fTip = new EditorTip(STPMessagePanel.this.fPanel, new LayerTipStrategy(), list, this.getStripe(mouseEvent));
                    this.fTip.show();
                } else {
                    this.stopHideTimer();
                }
            }
            this.fMessageList = list;
        }

        @Override
        protected boolean isTipShowing() {
            return this.fTip != null;
        }

        private boolean isSameList(List<EditorMessage> list) {
            return list.equals(this.fMessageList);
        }

        @Override
        public boolean doesTipContainScreenCoordinates(Point point) {
            return this.fTip != null && this.fTip.containsScreenPoint(point);
        }

        @Override
        protected void mouseWheeledInsideTip(MouseWheelEvent mouseWheelEvent) {
            this.fTip.notifyMouseWheelListeners(mouseWheelEvent);
        }

        @Override
        protected void mouseClickedInsideTip(MouseEvent mouseEvent) {
            this.fTip.clickedInside(mouseEvent);
        }

        private void cleanupTip() {
            if (this.fTip != null) {
                this.stopHideTimer();
                this.fTip.cleanup();
                this.fTip = null;
            }
        }

        private Rectangle getStripe(MouseEvent mouseEvent) {
            Rectangle rectangle = new Rectangle(STPMessagePanel.this.getComponent().getX(), mouseEvent.getY(), 15, 2);
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, STPMessagePanel.this.getComponent());
            rectangle.x = point.x;
            rectangle.y = point.y;
            return rectangle;
        }
    }

    private class LayerMessagePainter
    implements MessagePanelPainter<EditorMessage> {
        private LayerMessagePainter() {
        }

        @Override
        public Paint getPaintForMessage(EditorMessage editorMessage) {
            Color color = editorMessage.getColor();
            if (STPMessagePanel.this.fShowingTransientLayer && editorMessage.isStatic() && (STPMessagePanel.this.fLastEvent == null || !STPMessagePanel.this.fPanel.getMessagesUnder(STPMessagePanel.this.fLastEvent).contains(editorMessage))) {
                color = this.fadeColor(color);
            }
            return color;
        }

        private Color fadeColor(Color color) {
            Color color2 = STPMessagePanel.this.fPanel.getBackground();
            int n = (int)(0.25 * (double)color.getRed() + 0.75 * (double)color2.getRed());
            int n2 = (int)(0.25 * (double)color.getGreen() + 0.75 * (double)color2.getGreen());
            int n3 = (int)(0.25 * (double)color.getBlue() + 0.75 * (double)color2.getBlue());
            return new Color(n, n2, n3);
        }

        @Override
        public Paint getPaintForSummary(MessageModel<?> messageModel) {
            EditorMessageBarContributor editorMessageBarContributor = STPMessagePanel.this.getSummaryContributor();
            return editorMessageBarContributor != null ? editorMessageBarContributor.getSummaryPaint() : null;
        }
    }
}

