/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.BooleanFormatter;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.Formattable;
import com.mathworks.widgets.spreadsheet.format.Formatter;

final class CompositeFormatter
implements Formatter {
    private final ComplexScalarFormatter fComplexFormatter;
    private final BooleanFormatter fBooleanFormatter;

    CompositeFormatter(ComplexScalarFormatter complexScalarFormatter, BooleanFormatter booleanFormatter) {
        this.fComplexFormatter = complexScalarFormatter;
        this.fBooleanFormatter = booleanFormatter;
    }

    @Override
    public String format(ComplexScalar complexScalar) {
        return this.fComplexFormatter.format(complexScalar);
    }

    @Override
    public String format(Number number) {
        return this.fComplexFormatter.format(number);
    }

    @Override
    public String format(Boolean bl) {
        return this.fBooleanFormatter.format(bl);
    }

    @Override
    public String format(ComplexArray complexArray) {
        return complexArray.format(this.fComplexFormatter);
    }

    public String format(Formattable formattable) {
        return formattable.format(this);
    }

    private String format(boolean[][] blArray) {
        int[] nArray = ArrayUtils.getLengths((boolean[][])blArray);
        int n = nArray[0];
        int n2 = nArray[1];
        StringBuilder stringBuilder = new StringBuilder(n > 1 || n2 > 1 ? "[" : "");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(this.format(blArray[i][j]));
                if (j >= n2 - 1) continue;
                stringBuilder.append(", ");
            }
            if (i >= n - 1) continue;
            stringBuilder.append("; ");
        }
        stringBuilder.append(n > 1 || n2 > 1 ? "]" : "");
        return stringBuilder.toString();
    }

    @Override
    public Formatter getEditingFormatter() {
        return new CompositeFormatter(this.fComplexFormatter.getEditingComplexScalarFormatter(), this.fBooleanFormatter.getEditingBooleanFormatter());
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof ComplexScalar) {
            return this.format((ComplexScalar)object);
        }
        if (object instanceof Number) {
            return this.format((Number)object);
        }
        if (object instanceof Boolean) {
            return this.format((Boolean)object);
        }
        if (object instanceof ComplexArray) {
            return this.format((ComplexArray)object);
        }
        if (object instanceof Formattable) {
            return this.format((Formattable)object);
        }
        if (object instanceof boolean[][]) {
            return this.format((boolean[][])object);
        }
        return object.toString();
    }

    @Override
    public String getName() {
        return this.fComplexFormatter.getName();
    }
}

