/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.AsyncReceiver;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

final class FlatExpansionContext<T>
implements ExpansionContext<T> {
    private final List<T> fData = new ArrayList<T>();
    private final List<ExpansionChangeListener<T>> fListeners = new ArrayList<ExpansionChangeListener<T>>();

    FlatExpansionContext() {
    }

    void change(GroupingTableTransaction<T> groupingTableTransaction) {
        for (GroupingTableTransaction.Element<T> object : groupingTableTransaction) {
            switch (object.getType()) {
                case ADD: {
                    if (this.fData.contains(object.getData())) break;
                    this.fData.add(object.getData());
                    break;
                }
                case CHANGE: {
                    int n = this.fData.indexOf(object.getData());
                    if (n < 0 || n >= this.fData.size()) break;
                    this.fData.set(n, object.getData());
                    break;
                }
                case CLEAR: {
                    this.fData.clear();
                    break;
                }
                case REMOVE: {
                    this.fData.remove(object.getData());
                }
            }
        }
        for (ExpansionChangeListener expansionChangeListener : this.fListeners) {
            expansionChangeListener.childrenChanged(groupingTableTransaction);
        }
    }

    @Override
    public T getItem() {
        return null;
    }

    @Override
    public T createChildPlaceholder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Icon getOpenIcon(T t) {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.fData.isEmpty();
    }

    @Override
    public void getChildrenAsynchronously(AsyncReceiver<T> asyncReceiver) {
        for (T t : this.fData) {
            if (!asyncReceiver.receive(t)) break;
        }
        asyncReceiver.finished();
    }

    @Override
    public void addListener(ExpansionChangeListener<T> expansionChangeListener) {
        this.fListeners.add(expansionChangeListener);
    }

    @Override
    public void removeListener(ExpansionChangeListener<T> expansionChangeListener) {
        this.fListeners.remove(expansionChangeListener);
    }

    @Override
    public void close() {
        this.fData.clear();
    }

    @Override
    public void refresh() {
    }
}

