/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.ComponentIcon;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class DTToolSet {
    private boolean fIsImmutable;
    protected List<String> fKeyList = new ArrayList<String>();
    protected Map<String, ItemInfo> fItemMap = new HashMap<String, ItemInfo>();
    protected Map<KeyOwnerCombo, Component> fComponentCache = new HashMap<KeyOwnerCombo, Component>();
    protected static final EnumSet<ItemType> sIncludeLabelSet = EnumSet.complementOf(EnumSet.of(ItemType.CHECK_BOX, new ItemType[]{ItemType.PICKER_BUTTON, ItemType.RADIO_BUTTON, ItemType.PUSH_BUTTON, ItemType.TOGGLE_BUTTON, ItemType.CUSTOM}));

    public void add(String string, Action action) {
        this.checkMutability();
        this.validateNewKey(string);
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.iAction = action;
        itemInfo.iType = ItemType.PUSH_BUTTON;
        this.fKeyList.add(string);
        this.fItemMap.put(string, itemInfo);
    }

    public void add(String string, Action action, ItemType itemType) {
        this.checkMutability();
        this.validateNewKey(string);
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.iAction = action;
        itemInfo.iType = itemType;
        this.fKeyList.add(string);
        this.fItemMap.put(string, itemInfo);
    }

    public void add(String string, String string2, Component component, Icon icon) {
        this.checkMutability();
        this.validateNewKey(string);
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.iLabel = string2;
        itemInfo.iComponent = component;
        itemInfo.iType = DTToolSet.getComponentType(component);
        itemInfo.iIcon = icon = this.decorateIcon(component, itemInfo.iType, icon);
        this.fKeyList.add(string);
        this.fItemMap.put(string, itemInfo);
    }

    public void add(String string, String string2, ItemType itemType) {
        this.checkMutability();
        this.validateNewKey(string);
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.iLabel = string2;
        itemInfo.iType = itemType;
        this.fKeyList.add(string);
        this.fItemMap.put(string, itemInfo);
    }

    public void add(String string, String string2, Icon icon) {
        this.checkMutability();
        this.validateNewKey(string);
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.iLabel = string2;
        itemInfo.iIcon = icon;
        itemInfo.iType = ItemType.CUSTOM;
        this.fKeyList.add(string);
        this.fItemMap.put(string, itemInfo);
    }

    public void setImmutable() {
        if (!this.fIsImmutable) {
            this.fKeyList = Collections.unmodifiableList(this.fKeyList);
            this.fItemMap = Collections.unmodifiableMap(this.fItemMap);
            this.fIsImmutable = true;
        }
    }

    private void checkMutability() {
        if (this.fIsImmutable) {
            throw new IllegalStateException("Attempting to change immutable DTToolSet");
        }
    }

    public List<String> getKeys() {
        return Collections.unmodifiableList(this.fKeyList);
    }

    public String getLabel(String string) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        if (itemInfo == null) {
            return null;
        }
        if (itemInfo.iLabel != null) {
            return itemInfo.iLabel;
        }
        if (itemInfo.iAction != null) {
            String string2 = (String)itemInfo.iAction.getValue("ShortDescription");
            if (string2 != null) {
                return string2;
            }
            return (String)itemInfo.iAction.getValue("Name");
        }
        if (itemInfo.iComponent != null) {
            return itemInfo.iComponent.getName();
        }
        return null;
    }

    public ItemType getType(String string) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        if (itemInfo == null) {
            return ItemType.UNSPECIFIED;
        }
        return itemInfo.iType;
    }

    public Icon getIcon(String string) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        if (itemInfo == null) {
            return null;
        }
        if (itemInfo.iIcon != null) {
            return itemInfo.iIcon;
        }
        if (itemInfo.iAction != null) {
            Icon icon = (Icon)itemInfo.iAction.getValue("SmallIcon");
            if (icon == null && itemInfo.iAction instanceof MJAbstractAction) {
                icon = ((MJAbstractAction)itemInfo.iAction).getButtonOnlyIcon();
            }
            if (icon != null) {
                return icon;
            }
        }
        switch (itemInfo.iType) {
            case CHECK_BOX: {
                return ComponentIcon.CHECK_BOX.getIcon();
            }
            case COMBO_BOX: {
                return ComponentIcon.COMBO_BOX.getIcon();
            }
            case EDITABLE_COMBO_BOX: {
                return ComponentIcon.EDITABLE_COMBO_BOX.getIcon();
            }
            case EDITABLE_SPINNER: {
                return ComponentIcon.EDITABLE_SPINNER.getIcon();
            }
            case RADIO_BUTTON: {
                return ComponentIcon.RADIO_BUTTON.getIcon();
            }
            case SLIDER: {
                return ComponentIcon.SLIDER.getIcon();
            }
            case SPINNER: {
                return ComponentIcon.SPINNER.getIcon();
            }
            case TEXT_FIELD: {
                return ComponentIcon.TEXT_FIELD.getIcon();
            }
        }
        return null;
    }

    public boolean includeLabelOnBar(String string) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        return itemInfo != null && itemInfo.iLabel != null && sIncludeLabelSet.contains((Object)itemInfo.iType);
    }

    protected Component createComponent(String string, Object object) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        if (itemInfo == null || itemInfo.iAction == null) {
            return null;
        }
        switch (itemInfo.iType) {
            case CHECK_BOX: {
                return new MJCheckBox(itemInfo.iAction);
            }
            case PUSH_BUTTON: {
                MJButton mJButton = new MJButton(itemInfo.iAction);
                MJToolBar.configureButton((MJButton)mJButton);
                return mJButton;
            }
            case RADIO_BUTTON: {
                return new MJRadioButton(itemInfo.iAction);
            }
            case TOGGLE_BUTTON: {
                MJToggleButton mJToggleButton = new MJToggleButton(itemInfo.iAction);
                MJToolBar.configureButton((MJToggleButton)mJToggleButton);
                return mJToggleButton;
            }
        }
        return null;
    }

    public Component getComponent(String string, Object object) {
        ItemInfo itemInfo = this.fItemMap.get(string);
        if (itemInfo == null) {
            return null;
        }
        if (itemInfo.iComponent != null) {
            return itemInfo.iComponent;
        }
        KeyOwnerCombo keyOwnerCombo = new KeyOwnerCombo(string, object);
        Component component = this.fComponentCache.get(keyOwnerCombo);
        if (component == null) {
            component = this.createComponent(string, object);
            this.fComponentCache.put(keyOwnerCombo, component);
        }
        return component;
    }

    private void validateNewKey(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (this.fKeyList.contains(string)) {
            throw new IllegalArgumentException("Duplicate key: " + string);
        }
    }

    private Icon decorateIcon(Component component, ItemType itemType, Icon icon) {
        if (icon != null && itemType == ItemType.PICKER_BUTTON) {
            ImageIcon imageIcon = MiscellaneousIcon.DROP_DOWN_ARROW_5x3.getIcon();
            int n = icon.getIconWidth() + imageIcon.getIconWidth() + 5;
            int n2 = icon.getIconHeight();
            int n3 = (n2 - imageIcon.getIconHeight()) / 2;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(component, graphics2D, 0, 0);
            graphics2D.drawImage(imageIcon.getImage(), icon.getIconWidth() + 5, n3, null);
            graphics2D.dispose();
            icon = new ImageIcon(bufferedImage);
        }
        return icon;
    }

    private static ItemType getComponentType(Component component) {
        if (component == null) {
            return ItemType.UNSPECIFIED;
        }
        if (component instanceof AbstractButton) {
            if (component instanceof JButton) {
                return ItemType.PUSH_BUTTON;
            }
            if (component instanceof JCheckBox) {
                return ItemType.CHECK_BOX;
            }
            if (component instanceof JRadioButton) {
                return ItemType.RADIO_BUTTON;
            }
            if (component instanceof JToggleButton) {
                return ItemType.TOGGLE_BUTTON;
            }
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).isEditable() ? ItemType.EDITABLE_COMBO_BOX : ItemType.COMBO_BOX;
        }
        if (component instanceof JSlider) {
            return ItemType.SLIDER;
        }
        if (component instanceof JSpinner) {
            JComponent jComponent = ((JSpinner)component).getEditor();
            return jComponent instanceof JSpinner.DefaultEditor && ((JSpinner.DefaultEditor)jComponent).getTextField().isEditable() ? ItemType.EDITABLE_SPINNER : ItemType.SPINNER;
        }
        if (component instanceof JTextField) {
            return ItemType.TEXT_FIELD;
        }
        try {
            Class<?> clazz = Class.forName("com.mathworks.widgets.PickerButton");
            if (clazz.isInstance(component)) {
                return ItemType.PICKER_BUTTON;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ItemType.CUSTOM;
    }

    protected static class KeyOwnerCombo {
        private final String iKey;
        private final Object iOwner;

        KeyOwnerCombo(String string, Object object) {
            this.iKey = string;
            this.iOwner = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyOwnerCombo)) {
                return false;
            }
            KeyOwnerCombo keyOwnerCombo = (KeyOwnerCombo)object;
            return this.iKey.equals(keyOwnerCombo.iKey) && this.iOwner == keyOwnerCombo.iOwner;
        }

        public int hashCode() {
            int n = this.iKey.hashCode();
            if (this.iOwner != null) {
                n = n * 37 + this.iOwner.hashCode();
            }
            return n;
        }
    }

    protected static class ItemInfo {
        Action iAction;
        String iLabel;
        ItemType iType = ItemType.UNSPECIFIED;
        Icon iIcon;
        Component iComponent;

        protected ItemInfo() {
        }
    }

    public static enum ItemType {
        CHECK_BOX,
        COMBO_BOX,
        EDITABLE_COMBO_BOX,
        EDITABLE_SPINNER,
        PUSH_BUTTON,
        PICKER_BUTTON,
        RADIO_BUTTON,
        TOGGLE_BUTTON,
        SLIDER,
        SPINNER,
        TEXT_FIELD,
        CUSTOM,
        UNSPECIFIED;

    }
}

