/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollStrip;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentsFrame;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupFrame;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuContributor;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTNestingContainer;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSplitPane;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

class DTTabbedPane
extends MJTabbedPane
implements DTContainer,
ChangeListener,
PropertyChangeListener,
ItemListener,
ControlKeyOverride,
DTMenuContributor {
    private boolean fIgnoreSelection;
    private boolean fHandlingPopupTrigger;
    private boolean fMouseDownOnTab;
    private DTOccupant fOccupantAwaitingFocus;
    private int fCursorType = 0;
    private static MouseListener sLocalMouseListener = new LocalMouseListener();
    private static TabDragDetector sTabDragDetector = new TabDragDetector();
    private static MouseInputListener sDividerListener = new DividerListener();
    static final boolean USE_TITLE_TABS = true;

    DTTabbedPane() {
        this(3);
    }

    DTTabbedPane(int n) {
        super(n);
        this.setName("DesktopTabbedPane");
        this.setUI(new TitleTabUI());
        if (PlatformInfo.isWindowsClassicAppearance()) {
            this.setBorder(DTBorderFactory.DockedFrameBorder.createOuterBorder());
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.addChangeListener(this);
        this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("select-next-tab", new SelectNextAction());
        actionMap.put("select-previous-tab", new SelectPreviousAction());
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(9, 2), KeyStroke.getKeyStroke(9, 3), KeyStroke.getKeyStroke(38, 2), KeyStroke.getKeyStroke(224, 2)};
        DTUtilities.blockKeyboardInputs((JComponent)((Object)this), keyStrokeArray);
    }

    Action getNextTabAction() {
        return this.getActionMap().get("select-next-tab");
    }

    Action getPrevTabAction() {
        return this.getActionMap().get("select-previous-tab");
    }

    public void updateUI() {
    }

    public boolean wantKey(KeyStroke keyStroke, Component component) {
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
        return dTClientFrame == null || !dTClientFrame.getClient().wantsControlKeys();
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        int n;
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        String string = dTInternalFrame.getTitleBar().getShortTitle();
        dTInternalFrame.setTitleBarVisible(true);
        int n2 = this.getTabCount();
        if (dTOccupant.getLastLocation() instanceof DTBorderLocation && dTOccupant.getLastLocation().isMaximized() && dTLocation instanceof DTNestedLocation && (n = ((DTNestedLocation)dTLocation).getTabIndex()) >= 0 && n <= this.getTabCount()) {
            n2 = n;
        }
        this.fIgnoreSelection = true;
        this.insertTab(string, null, (Component)((Object)dTInternalFrame), null, n2);
        this.fIgnoreSelection = false;
        DTTitleBar dTTitleBar = dTInternalFrame.borrowTitleBar();
        dTTitleBar.setActAsTab(true);
        ((TitleTabUI)this.getUI()).addTitleTab(dTTitleBar, n2);
        dTInternalFrame.addItemListener(this);
        if (dTOccupant.isSelected()) {
            this.setSelectedIndex(n2);
        }
        dTOccupant.addPropertyListener(this);
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        dTOccupant.removePropertyListener(this);
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        dTInternalFrame.removeItemListener(this);
        int n = this.indexOfComponent((Component)((Object)dTInternalFrame));
        if (n != -1) {
            this.fIgnoreSelection = true;
            this.removeTabAt(n);
            int n2 = this.getMostRecentIndex();
            if (n2 != -1 && n2 < this.getTabCount()) {
                this.setSelectedIndex(n2);
            }
            this.fIgnoreSelection = false;
        }
        DTTitleBar dTTitleBar = dTInternalFrame.getTitleBar();
        ((TitleTabUI)this.getUI()).removeTitleTab(dTTitleBar);
        dTTitleBar.setActAsTab(false);
        dTInternalFrame.returnTitleBar(dTTitleBar);
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        if (bl) {
            Component component = this.getSelectedComponent();
            if (component instanceof DTClientFrame) {
                DTClient dTClient = ((DTClientFrame)((Object)component)).getClient();
                return dTSelectable == dTClient ? null : dTClient;
            }
            if (component instanceof DTGroupFrame) {
                DTGroup dTGroup = ((DTGroupFrame)((Object)component)).getGroup();
                if (dTSelectable instanceof DTClient) {
                    DTLocation dTLocation = ((DTClient)dTSelectable).getLocation();
                    return dTLocation != null && dTLocation.isIn(dTGroup.getDocumentContainer()) ? null : (DTSelectable)((Object)component);
                }
                if (dTSelectable == component) {
                    return null;
                }
                if (dTSelectable == dTGroup) {
                    return null;
                }
                if (dTGroup != null) {
                    return dTGroup;
                }
                return (DTSelectable)((Object)component);
            }
        } else {
            Object object;
            int n = -1;
            if (dTSelectable instanceof DTClient) {
                object = (DTClient)dTSelectable;
                n = ((DTClient)object).isSingleton() ? this.indexOfComponent((Component)((Object)((DTClient)dTSelectable).getInternalFrame())) : this.indexOfComponent((Component)((Object)((DTClient)object).getGroup().getInternalFrame()));
            } else if (dTSelectable instanceof DTGroup) {
                n = this.indexOfComponent((Component)((Object)((DTGroup)dTSelectable).getInternalFrame()));
            } else if (dTSelectable instanceof Component) {
                n = this.indexOfComponent((Component)((Object)dTSelectable));
            }
            if (n < this.getTabCount() - 1) {
                object = this.getComponentAt(n + 1);
                if (object instanceof DTClientFrame) {
                    return ((DTClientFrame)object).getClient();
                }
                if (object instanceof DTGroupFrame) {
                    return ((DTGroupFrame)object).getNext(null, bl);
                }
            }
        }
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        if (bl) {
            Component component = this.getSelectedComponent();
            if (component instanceof DTClientFrame) {
                DTClient dTClient = ((DTClientFrame)((Object)component)).getClient();
                return dTSelectable == dTClient ? null : dTClient;
            }
            if (component instanceof DTGroupFrame) {
                DTGroup dTGroup = ((DTGroupFrame)((Object)component)).getGroup();
                if (dTSelectable instanceof DTClient) {
                    DTLocation dTLocation = ((DTClient)dTSelectable).getLocation();
                    return dTLocation != null && dTLocation.isIn(dTGroup.getDocumentContainer()) ? null : (DTSelectable)((Object)component);
                }
                if (dTSelectable == component) {
                    return null;
                }
                if (dTSelectable == dTGroup) {
                    return null;
                }
                if (dTGroup != null) {
                    return dTGroup;
                }
                return (DTSelectable)((Object)component);
            }
        } else {
            Object object;
            int n = -1;
            if (dTSelectable instanceof DTClient) {
                object = (DTClient)dTSelectable;
                n = ((DTClient)object).isSingleton() ? this.indexOfComponent((Component)((Object)((DTClient)dTSelectable).getInternalFrame())) : this.indexOfComponent((Component)((Object)((DTClient)object).getGroup().getInternalFrame()));
            } else if (dTSelectable instanceof DTGroup) {
                n = this.indexOfComponent((Component)((Object)((DTGroup)dTSelectable).getInternalFrame()));
            } else if (dTSelectable instanceof Component) {
                n = this.indexOfComponent((Component)((Object)dTSelectable));
            }
            if (n == 0) {
                return null;
            }
            if (n == -1) {
                n = this.getTabCount() - 1;
            } else if (n > 0) {
                --n;
            }
            object = this.getComponentAt(n);
            if (object instanceof DTClientFrame) {
                return ((DTClientFrame)object).getClient();
            }
            if (object instanceof DTGroupFrame) {
                return ((DTGroupFrame)object).getPrevious(null, bl);
            }
        }
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        int n = this.indexOfComponent((Component)((Object)dTInternalFrame));
        int n2 = this.getSelectedIndex();
        if (n != -1 && n != n2) {
            dTOccupant.setSelectionOrder(dTOccupant.getDesktop().getSelectionManager().getNextSelectionOrder());
            ((DTInternalFrame)((Object)this.getSelectedComponent())).getOccupant().setSelected(false);
            this.fIgnoreSelection = true;
            this.setSelectedIndex(n);
            this.fIgnoreSelection = false;
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    void setBordersVisible(boolean bl) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((DTInternalFrame)((Object)this.getComponentAt(i))).setBorderVisible(bl);
        }
    }

    int getMostRecentIndex() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getTabCount(); ++i) {
            int n3 = 0;
            DTOccupant dTOccupant = ((DTInternalFrame)((Object)this.getComponentAt(i))).getOccupant();
            if (dTOccupant != null) {
                n3 = dTOccupant.getSelectionOrder();
            }
            if (n3 <= n2) continue;
            n = i;
            n2 = n3;
        }
        return n;
    }

    public void setSelectedIndex(int n) {
        if (!this.fHandlingPopupTrigger) {
            super.setSelectedIndex(n);
        }
    }

    void selectNextTab() {
        int n = this.getSelectedIndex() + 1;
        if (n >= this.getTabCount()) {
            n = 0;
        }
        this.setSelectedIndex(n);
    }

    void selectPreviousTab() {
        int n = this.getSelectedIndex() - 1;
        if (n < 0) {
            n = this.getTabCount() - 1;
        }
        this.setSelectedIndex(n);
    }

    void allRestored() {
        Component component = this.getSelectedComponent();
        if (component instanceof DTClientFrame) {
            ((DTClientFrame)((Object)component)).getClient().prepareToShow();
        }
    }

    void refresh() {
        int n = this.getSelectedIndex();
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getComponentAt(i);
            if ((!(component instanceof DTGroupFrame) || !((DTGroupFrame)((Object)component)).getDocumentContainer().isHeavy()) && (!(component instanceof DTClientFrame) || !((DTClientFrame)((Object)component)).getClient().mayHaveHeavyContent())) continue;
            this.setSelectedIndex(i);
        }
        if (this.getSelectedIndex() != n) {
            this.setSelectedIndex(n);
        }
    }

    final void ignoreSelection(boolean bl) {
        this.fIgnoreSelection = bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)this.getSelectedComponent());
        if (this.fIgnoreSelection) {
            DTClient dTClient;
            Desktop desktop;
            if (dTInternalFrame instanceof DTClientFrame && !(desktop = (dTClient = ((DTClientFrame)dTInternalFrame).getClient()).getDesktop()).isRestoringLayout() && !desktop.isClosing() && !desktop.isClearingLayout()) {
                dTClient.prepareToShow();
            }
            return;
        }
        int n = this.getSelectedIndex();
        for (int i = 0; i < this.getTabCount(); ++i) {
            DTOccupant dTOccupant;
            if (i == n || !((dTOccupant = ((DTInternalFrame)((Object)this.getComponentAt(i))).getOccupant()) instanceof DTGroup)) continue;
            ((DTGroup)dTOccupant).setOnTopSingletonsVisible(false);
        }
        DTOccupant dTOccupant = dTInternalFrame.getOccupant();
        if (this.fMouseDownOnTab) {
            this.fOccupantAwaitingFocus = dTOccupant;
        }
        dTOccupant.setSelected(true, !this.fMouseDownOnTab);
        if (dTOccupant instanceof DTGroup) {
            ((DTGroup)dTOccupant).setOnTopSingletonsVisible(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof DTClient) {
            DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
            int n = this.indexOfComponent((Component)((Object)dTClient.getInternalFrame()));
            assert (n != -1);
            if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.getSelectedIndex() != n) {
                this.setSelectedIndex(n);
            }
        } else if (propertyChangeEvent.getSource() instanceof DTGroup) {
            DTGroup dTGroup = (DTGroup)propertyChangeEvent.getSource();
            int n = this.indexOfComponent((Component)((Object)dTGroup.getInternalFrame()));
            assert (n != -1);
            if (DTGroupProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.setTitleAt(n, (String)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void updateTabTip(DTClient dTClient, int n) {
        String string = dTClient.getTitle();
        String string2 = dTClient.getShortTitle();
        this.setToolTipTextAt(n, string == null || string.equals(string2) ? null : string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DTInternalFrame dTInternalFrame;
        if (itemEvent.getStateChange() == 1 && (dTInternalFrame = (DTInternalFrame)itemEvent.getItem()) != null) {
            this.toFront(dTInternalFrame.getOccupant(), DTContainer.Scope.FRAME);
        }
    }

    @Override
    public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)this.getSelectedComponent());
        if (dTInternalFrame != null) {
            dTInternalFrame.contributeToMenu(jPopupMenu, mouseEvent);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = DTTitleBar.SIZING_MINIMUM.width;
        dimension.height += 4;
        return dimension;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
    }

    static DTTabbedPane getTabbedPane(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        return (DTTabbedPane)((Object)(component instanceof DTTabbedPane ? component : SwingUtilities.getAncestorOfClass(DTTabbedPane.class, component)));
    }

    private void updateCursor(boolean bl) {
        int n;
        int n2 = n = bl ? 8 : 0;
        if (n != this.fCursorType) {
            this.setCursor(Cursor.getPredefinedCursor(n));
            this.fCursorType = n;
        }
    }

    private class TitlePanel
    extends MJComponent {
        TitlePanel() {
            this.setLayout(null);
        }

        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                Dimension dimension2 = component.getMinimumSize();
                dimension.width += dimension2.width;
                if (dimension2.height <= dimension.height) continue;
                dimension.height = dimension2.height;
            }
            return dimension;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void doLayout() {
            int n;
            int n2 = this.getComponentCount();
            if (n2 == 0) {
                return;
            }
            int n3 = this.getWidth();
            int n4 = n3 / n2;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                Component component = this.getComponent(n);
                nArray[n] = component.getMinimumSize().width;
                nArray2[n] = component.getPreferredSize().width;
                n6 += nArray[n];
                n7 += nArray2[n];
                if (nArray2[n] <= n4) continue;
                ++n5;
            }
            n = n3 - n6;
            int n8 = n5 > 0 && n5 < n2 ? (n3 - n7) / (n2 - n5) : 0;
            int n9 = this.getHeight();
            int n10 = 0;
            for (int i = 0; i < n2; ++i) {
                int n11;
                Component component = this.getComponent(i);
                if (n6 >= n3) {
                    n11 = nArray[i];
                } else if (i == n2 - 1) {
                    n11 = n3 - n10;
                } else if (n7 >= n3) {
                    n11 = nArray[i];
                    int n12 = nArray2[i] - n11;
                    if (n12 > 0 && n > 0) {
                        if (n12 > n) {
                            n12 = n;
                        }
                        n11 += n12;
                        n -= n12;
                    }
                } else if (n5 > 0) {
                    n11 = component.getPreferredSize().width;
                    if (n11 < n4) {
                        n11 += n8;
                    }
                } else {
                    n11 = n4;
                }
                component.setBounds(n10, 0, n11, n9);
                n10 += n11;
            }
        }
    }

    private class TitleTabUI
    extends TabbedPaneUI
    implements LayoutManager,
    ChangeListener {
        private MJScrollStrip fScrollStrip;
        private TitlePanel fTitlePanel;
        private DTTitleBar fBackgroundTitleBar;

        TitleTabUI() {
            this.fTitlePanel = new TitlePanel();
            this.fScrollStrip = new TitleScrollStrip((Component)((Object)this.fTitlePanel));
            this.fTitlePanel.setName("TitlePanel");
            this.fScrollStrip.setName("TitleScrollStrip");
            if (PlatformInfo.isWindowsClassicAppearance()) {
                this.fScrollStrip.setBorder((Border)new DTBorderFactory.BackgroundBorder(1, 2, 0, 2));
            }
        }

        @Override
        public void installUI(JComponent jComponent) {
            jComponent.setLayout(this);
            jComponent.add((Component)this.fScrollStrip);
            ((JTabbedPane)jComponent).addChangeListener(this);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            jComponent.setLayout(null);
            jComponent.remove((Component)this.fScrollStrip);
            ((JTabbedPane)jComponent).removeChangeListener(this);
        }

        void addTitleTab(DTTitleBar dTTitleBar, int n) {
            if (this.fBackgroundTitleBar == null) {
                this.fBackgroundTitleBar = DTTitleBar.createSimilar(dTTitleBar);
                this.fBackgroundTitleBar.setActAsTab(true);
                this.fScrollStrip.getParent().add(this.fBackgroundTitleBar);
            }
            if (this.fTitlePanel.getComponentCount() == 0) {
                dTTitleBar.setIsSelectedTab(true);
            }
            this.fTitlePanel.add(dTTitleBar, n);
            this.fTitlePanel.doLayout();
        }

        void removeTitleTab(DTTitleBar dTTitleBar) {
            this.fTitlePanel.remove(dTTitleBar);
            this.fTitlePanel.doLayout();
            dTTitleBar.setIsSelectedTab(false);
            this.fScrollStrip.refreshView();
            this.stateChanged(new ChangeEvent(DTTabbedPane.this));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                Component component = DTTabbedPane.this.getComponentAt(i);
                boolean bl = i == jTabbedPane.getSelectedIndex();
                component.setVisible(bl);
                DTOccupant dTOccupant = ((DTInternalFrame)((Object)component)).getOccupant();
                if (!(dTOccupant instanceof DTGroup)) continue;
                ((DTGroup)dTOccupant).setOnTopSingletonsVisible(bl);
            }
            DTTitleBar dTTitleBar = null;
            for (int i = 0; i < this.fTitlePanel.getComponentCount(); ++i) {
                DTTitleBar dTTitleBar2 = (DTTitleBar)this.fTitlePanel.getComponent(i);
                boolean bl = i == jTabbedPane.getSelectedIndex();
                dTTitleBar2.setIsSelectedTab(bl);
                if (!bl) continue;
                dTTitleBar = dTTitleBar2;
            }
            if (dTTitleBar != null) {
                SwingUtilities.invokeLater(new ScrollAdjuster(dTTitleBar));
            }
        }

        @Override
        public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
            return 0;
        }

        @Override
        public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
            return new Rectangle();
        }

        @Override
        public int getTabRunCount(JTabbedPane jTabbedPane) {
            return 1;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = this.fScrollStrip.getPreferredSize();
            Component component = ((JTabbedPane)container).getSelectedComponent();
            Dimension dimension2 = component == null ? new Dimension() : component.getPreferredSize();
            return new Dimension(insets.left + insets.right + Math.max(dimension.width, dimension2.width), insets.top + insets.bottom + dimension.height + dimension2.height);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = this.fScrollStrip.getMinimumSize();
            Component component = ((JTabbedPane)container).getSelectedComponent();
            Dimension dimension2 = component == null ? new Dimension() : component.getMinimumSize();
            return new Dimension(insets.left + insets.right + Math.max(dimension.width, dimension2.width), insets.top + insets.bottom + dimension.height + dimension2.height);
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = this.fScrollStrip.getPreferredSize().height;
            if (this.fBackgroundTitleBar != null) {
                this.fBackgroundTitleBar.setBounds(insets.left, insets.top, DTTabbedPane.this.getWidth() - insets.left - insets.right, n);
            }
            this.fScrollStrip.setBounds(insets.left, insets.top, DTTabbedPane.this.getWidth() - insets.left - insets.right, n);
            JTabbedPane jTabbedPane = (JTabbedPane)container;
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                Component component = DTTabbedPane.this.getComponentAt(i);
                component.setBounds(insets.left, insets.top + n, DTTabbedPane.this.getWidth() - insets.left - insets.right, DTTabbedPane.this.getHeight() - insets.top - insets.bottom - n);
            }
        }

        private class ScrollAdjuster
        implements Runnable {
            Component fComponent;

            ScrollAdjuster(Component component) {
                this.fComponent = component;
            }

            @Override
            public void run() {
                if (this.fComponent.getParent() != null) {
                    TitleTabUI.this.fScrollStrip.ensureVisible(this.fComponent);
                }
            }
        }
    }

    private class TitleScrollStrip
    extends MJScrollStrip
    implements UIResource {
        TitleScrollStrip(Component component) {
            super(0, component, true);
        }
    }

    private static class DividerListener
    extends MouseInputAdapter {
        DTSplitPane iSplitPaneBelow;
        int iInitialDividerLoc;
        int iInitialY;

        private DividerListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)mouseEvent.getComponent());
            if (this.isOverDivider(dTTabbedPane, mouseEvent.getX(), mouseEvent.getY())) {
                this.iSplitPaneBelow = this.findDividerBelowTabs(dTTabbedPane);
                if (this.iSplitPaneBelow != null) {
                    this.iInitialDividerLoc = this.iSplitPaneBelow.getDividerLocation();
                    this.iInitialY = mouseEvent.getY();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.iSplitPaneBelow = null;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.iSplitPaneBelow == null) {
                DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)mouseEvent.getComponent());
                dTTabbedPane.updateCursor(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)mouseEvent.getComponent());
            if (this.findDividerBelowTabs(dTTabbedPane) != null) {
                dTTabbedPane.updateCursor(this.isOverDivider(dTTabbedPane, mouseEvent.getX(), mouseEvent.getY()));
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iSplitPaneBelow != null) {
                int n = mouseEvent.getY() - this.iInitialY;
                int n2 = this.iInitialDividerLoc + n;
                if (n2 < this.iSplitPaneBelow.getMinimumDividerLocation()) {
                    n2 = this.iSplitPaneBelow.getMinimumDividerLocation();
                } else if (n2 > this.iSplitPaneBelow.getMaximumDividerLocation()) {
                    n2 = this.iSplitPaneBelow.getMaximumDividerLocation();
                }
                this.iSplitPaneBelow.setDividerLocation(n2);
            }
        }

        private boolean isOverDivider(DTTabbedPane dTTabbedPane, int n, int n2) {
            Rectangle rectangle = dTTabbedPane.getBoundsAt(dTTabbedPane.getTabCount() - 1);
            return rectangle != null && n > rectangle.x + rectangle.width && n2 < rectangle.y && n2 > rectangle.y - 10;
        }

        private DTSplitPane findDividerBelowTabs(DTTabbedPane dTTabbedPane) {
            DTSplitPane dTSplitPane = null;
            Object object = dTTabbedPane;
            Container container = dTTabbedPane.getParent();
            while (dTSplitPane == null && container instanceof DTSplitPane) {
                DTSplitPane dTSplitPane2 = (DTSplitPane)((Object)container);
                if (dTSplitPane2.getOrientation() == 0 && dTSplitPane2.getTopComponent() == object) {
                    dTSplitPane = dTSplitPane2;
                    continue;
                }
                object = container;
                container = ((Component)object).getParent();
            }
            return dTSplitPane;
        }
    }

    private static class TabDragDetector
    extends DTDragDetector {
        private TabDragDetector() {
        }

        @Override
        protected Object getLoad(MouseEvent mouseEvent) {
            DTTabbedPane dTTabbedPane = DTTabbedPane.getTabbedPane(mouseEvent);
            int n = dTTabbedPane.indexFromMouse(mouseEvent);
            if (n == -1) {
                return null;
            }
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)dTTabbedPane.getComponentAt(n));
            DTOccupant dTOccupant = dTInternalFrame.getOccupant();
            if (dTOccupant != null) {
                return dTOccupant;
            }
            return null;
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            if (this.fLoad == null) {
                return;
            }
            super.startDrag(mouseEvent);
            Component component = (Component)mouseEvent.getSource();
            DTNestingContainer dTNestingContainer = (DTNestingContainer)((Object)SwingUtilities.getAncestorOfClass(DTNestingContainer.class, component));
            if (dTNestingContainer != null) {
                dTNestingContainer.startDrag(this.fLoad, component);
            }
        }
    }

    private static class LocalMouseListener
    extends MouseInputAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTTabbedPane dTTabbedPane = DTTabbedPane.getTabbedPane(mouseEvent);
            dTTabbedPane.fMouseDownOnTab = true;
            if (mouseEvent.isPopupTrigger()) {
                dTTabbedPane.fHandlingPopupTrigger = true;
                this.showMenu(dTTabbedPane, mouseEvent);
                mouseEvent.consume();
            } else if (MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent)) {
                dTTabbedPane.fHandlingPopupTrigger = true;
            } else {
                DTInternalFrame dTInternalFrame;
                DTOccupant dTOccupant;
                int n = dTTabbedPane.indexFromMouse(mouseEvent);
                int n2 = dTTabbedPane.getSelectedIndex();
                if (n != -1 && n == n2 && (dTOccupant = (dTInternalFrame = (DTInternalFrame)((Object)dTTabbedPane.getComponentAt(n))).getOccupant()) != null && !dTOccupant.isSelected()) {
                    dTOccupant.setSelected(true, false);
                    dTInternalFrame.requestFocusInWindow();
                    dTTabbedPane.fOccupantAwaitingFocus = dTOccupant;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DTTabbedPane dTTabbedPane = DTTabbedPane.getTabbedPane(mouseEvent);
            if (mouseEvent.isPopupTrigger()) {
                this.showMenu(dTTabbedPane, mouseEvent);
                mouseEvent.consume();
            }
            if (dTTabbedPane.fOccupantAwaitingFocus != null) {
                dTTabbedPane.fOccupantAwaitingFocus.requestFocusLater();
                dTTabbedPane.fOccupantAwaitingFocus = null;
            }
            dTTabbedPane.fHandlingPopupTrigger = false;
            dTTabbedPane.fMouseDownOnTab = false;
        }

        void showMenu(DTTabbedPane dTTabbedPane, MouseEvent mouseEvent) {
            int n = dTTabbedPane.indexFromMouse(mouseEvent);
            if (n == -1) {
                return;
            }
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)dTTabbedPane.getComponentAt(n));
            DTOccupant dTOccupant = dTInternalFrame.getOccupant();
            mJPopupMenu.setCleanupUponClose(true);
            if (dTOccupant != null) {
                mJPopupMenu.add((Action)dTOccupant.getCloseAction());
                mJPopupMenu.add((Action)dTOccupant.getUndockAction());
                mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class SelectPreviousAction
    extends ConditionalAction {
        SelectPreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DTTabbedPane.this.selectPreviousTab();
        }
    }

    class SelectNextAction
    extends ConditionalAction {
        SelectNextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DTTabbedPane.this.selectNextTab();
        }
    }

    abstract class ConditionalAction
    extends AbstractAction {
        ConditionalAction() {
        }

        @Override
        public boolean isEnabled() {
            Component component = DTTabbedPane.this.getSelectedComponent();
            DTDocumentContainer dTDocumentContainer = null;
            if (component instanceof DTGroupFrame) {
                dTDocumentContainer = ((DTGroupFrame)((Object)component)).getDocumentContainer();
            } else if (component instanceof DTDocumentsFrame) {
                dTDocumentContainer = ((DTDocumentsFrame)((Object)component)).getDocumentContainer();
            }
            return dTDocumentContainer == null || dTDocumentContainer.getDocumentCount() < 2;
        }
    }

    class DeferredSelection
    implements Runnable {
        DTOccupant fOccupant;

        DeferredSelection(DTOccupant dTOccupant) {
            this.fOccupant = dTOccupant;
        }

        @Override
        public void run() {
            if (!this.fOccupant.isSelected()) {
                return;
            }
            int n = DTTabbedPane.this.indexOfComponent((Component)((Object)this.fOccupant.getInternalFrame()));
            if (n != -1) {
                DTTabbedPane.this.setSelectedIndex(n);
            }
        }
    }
}

