/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderContainer;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMaximizedButtonPanel;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTNestingContainer;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTToolBarContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class DTGroupFrame
extends DTInternalFrame
implements ItemListener,
DTDocumentContainer.ArrangementListener,
DTToolBarContainer.Listener {
    private DTGroup fGroup;
    private DTFrame fFrame;
    private DTClient fMergedDocument;
    private ArrangementControls fArrangementControls;
    private DTMaximizedButtonPanel fMaximizedButtons;
    private JComponent fUpperRightPanel;
    private DTBorderContainer fBorderContainer;
    private DTNestingContainer fNestingContainer;
    private DTGroupListener fDockListener;

    public DTGroupFrame(DTGroup dTGroup) {
        this.fGroup = dTGroup;
        this.setName(dTGroup.getTitle() + "GroupFrame");
        this.setBorderType(false);
        this.setBorderVisible(true);
        DTDocumentContainer dTDocumentContainer = dTGroup.getDocumentContainer();
        dTDocumentContainer.addItemListener(this);
        dTDocumentContainer.addArrangementListener(this);
        this.fContentPane.add((Component)((Object)dTDocumentContainer), "Center");
        this.fArrangementControls = new ArrangementControls();
        this.fMaximizedButtons = new DTMaximizedButtonPanel();
        this.fMaximizedButtons.setVisible(false);
        this.fUpperRightPanel = Box.createHorizontalBox();
        this.fUpperRightPanel.add((Component)((Object)this.fArrangementControls));
        if (PlatformInfo.isMacintosh()) {
            this.fToolBarContainer.addLeftCorner((JComponent)((Object)this.fMaximizedButtons));
        } else {
            this.fUpperRightPanel.add((Component)((Object)this.fMaximizedButtons));
        }
        this.fToolBarContainer.addRightCorner(this.fUpperRightPanel);
        this.fToolBarContainer.addListener(this);
        this.fToolBarContainer.setAllowRearrangement(this.fGroup.allowToolBarRearrangement());
        if (this.fGroup.getDesktop().useToolstrip() && !this.fGroup.supportsToolstrip() && this.fGroup.placeToolBarsWithDocumentBar()) {
            MJToolBar mJToolBar = this.fArrangementControls.fArrangementToolBar;
            mJToolBar.setMorePopupEnabled(false);
            mJToolBar.addSeparator();
            final Component component = mJToolBar.getComponent(mJToolBar.getComponentCount() - 1);
            final JButton jButton = mJToolBar.add((Action)this.fGroup.getDockAction());
            if (this.fGroup.getLastLocation() != null && this.fGroup.getLastLocation().isDocked()) {
                component.setVisible(false);
                jButton.setVisible(false);
            }
            this.fDockListener = new DTGroupAdapter(){

                @Override
                public void groupDocked(DTGroupEvent dTGroupEvent) {
                    this.updateDockButtonVisibility();
                }

                @Override
                public void groupUndocked(DTGroupEvent dTGroupEvent) {
                    this.updateDockButtonVisibility();
                }

                private void updateDockButtonVisibility() {
                    boolean bl = DTGroupFrame.this.fGroup.getLocation() == null || !DTGroupFrame.this.fGroup.getLocation().isDocked();
                    component.setVisible(bl);
                    jButton.setVisible(bl);
                }
            };
            this.fGroup.addListener(this.fDockListener);
            this.getDocumentContainer().setTopRightToolBar((JToolBar)mJToolBar);
        }
        this.mergeToolBars(null);
        dTGroup.addPropertyListener(this);
        this.setKeyBindings();
    }

    private void setKeyBindings() {
        if (this.fGroup.getDesktop().useToolstrip()) {
            this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
            ActionMap actionMap = this.getActionMap();
            actionMap.put("dock", (Action)this.fGroup.getDockAction());
            actionMap.put("undock", (Action)this.fGroup.getUndockAction());
            actionMap.put("maximize", (Action)this.fGroup.getMaximizeAction());
            actionMap.put("minimize", (Action)this.fGroup.getMinimizeAction());
        }
    }

    void cleanup() {
        this.fGroup.removePropertyListener(this);
        if (this.fGroup.hasDocumentContainer()) {
            this.getDocumentContainer().removeItemListener(this);
            this.getDocumentContainer().removeArrangementListener(this);
        }
        this.fArrangementControls.cleanup();
        this.fToolBarContainer.removeAllToolBars();
        if (this.fDockListener != null) {
            this.fGroup.removeListener(this.fDockListener);
            this.fDockListener = null;
        }
    }

    void restoreState(Object object, Object object2) {
        if (!(this.fBorderContainer == null && this.fNestingContainer == null || object != null && object2 != null)) {
            if (this.fBorderContainer != null) {
                this.fContentPane.remove((Component)((Object)this.fBorderContainer));
                this.fBorderContainer = null;
            } else {
                this.fContentPane.remove((Component)((Object)this.fNestingContainer));
                this.fNestingContainer = null;
            }
        }
        this.addSingletonContainers();
        if (this.fBorderContainer != null && object != null) {
            this.fBorderContainer.restoreState(object);
        }
        if (this.fNestingContainer != null && object2 != null) {
            this.fNestingContainer.restoreState(object2);
        }
    }

    @Override
    public DTOccupant getOccupant() {
        return this.fGroup;
    }

    @Override
    DTClient getTopClient() {
        return this.getDocumentContainer().getTopDocument();
    }

    DTGroup getGroup() {
        return this.fGroup;
    }

    DTDocumentContainer getDocumentContainer() {
        return this.fGroup.getDocumentContainer();
    }

    DTBorderContainer getBorderContainer() {
        return this.fBorderContainer;
    }

    DTNestingContainer getNestingContainer() {
        return this.fNestingContainer;
    }

    void setFrame(DTFrame dTFrame) {
        if (this.fBorderContainer != null) {
            this.fBorderContainer.setFrame(dTFrame);
        }
        if (this.fNestingContainer != null) {
            this.fNestingContainer.setFrame(dTFrame);
        }
        if (this.fGroup.getDesktop().useToolstrip() && this.fMergedDocument != null) {
            DTClient dTClient = this.fMergedDocument;
            this.mergeToolBars(null);
            this.fFrame = dTFrame;
            this.mergeToolBars(dTClient);
        }
        this.fFrame = dTFrame;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        if (dTClient.isSingleton()) {
            if (this.fBorderContainer == null && this.fNestingContainer == null) {
                this.addSingletonContainers();
            } else if (this.fBorderContainer != null) {
                this.fBorderContainer.revealCenterComponent();
            }
            if (this.fBorderContainer != null && dTLocation instanceof DTBorderLocation) {
                if (dTLocation.getEdge() == 0) {
                    this.fBorderContainer.revealCenterComponent();
                } else {
                    dTClient.setSelected(false);
                }
                this.fBorderContainer.add(dTClient, dTLocation);
            } else {
                this.fNestingContainer.add(dTOccupant, dTLocation);
            }
        } else {
            this.getDocumentContainer().add(dTOccupant, dTLocation);
            if (this.getDocumentContainer().getArrangement() == 1 && !this.getDocumentContainer().isRestoringDocuments()) {
                this.updateTitle();
            }
            if (this.fTitleBar != null) {
                this.fTitleBar.setIcon(this.fGroup.getSmallIcon());
            }
            dTClient.getClientFrame().borrowToolBars();
            if (!this.getDocumentContainer().isRestoringDocuments() && this.getDocumentContainer().getTopDocument() == dTClient) {
                if (this.fGroup.isSelected() && !dTClient.isSelected()) {
                    dTClient.setSelected(true);
                }
                this.mergeToolBars(dTClient);
            }
        }
        dTClient.addPropertyListener(this);
    }

    private boolean usingToolstrip() {
        return this.fFrame != null ? this.fFrame.usingToolstrip() : this.fGroup.getDesktop().useToolstrip() && this.fGroup.supportsToolstrip();
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        if (dTOccupant instanceof DTGroup) {
            this.fGroup = null;
            return;
        }
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTLocation dTLocation = dTClient.getLocation();
        if (dTClient.isSingleton()) {
            if (this.fBorderContainer != null && dTLocation.isIn(this.fBorderContainer)) {
                this.fBorderContainer.remove(dTClient);
            } else if (this.fNestingContainer != null && dTLocation.isIn(this.fNestingContainer)) {
                this.fNestingContainer.remove(dTOccupant);
            }
        } else {
            this.getDocumentContainer().remove(dTOccupant);
            if (this.getDocumentContainer().getArrangement() == 1) {
                this.updateTitle();
            }
            if (dTClient == this.fMergedDocument) {
                this.mergeToolBars(this.getDocumentContainer().getTopDocument());
            }
            dTClient.getClientFrame().returnToolBars();
        }
        dTClient.removePropertyListener(this);
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return this.fGroup.isEnabled() ? this.getDocumentContainer().getNext(dTSelectable, bl) : null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return this.fGroup.isEnabled() ? this.getDocumentContainer().getPrevious(dTSelectable, bl) : null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
        this.getDocumentContainer().replaceChild(component, component2);
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        if (dTClient.isSingleton()) {
            if (this.fNestingContainer != null) {
                this.fNestingContainer.toFront(dTOccupant, scope);
            }
        } else {
            this.getDocumentContainer().toFront(dTOccupant, scope);
            this.mergeToolBars(dTClient);
            if (this.getDocumentContainer().getArrangement() == 1) {
                this.updateTitle();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this.setSelected(bl);
        if (bl && this.fBorderContainer != null && this.fBorderContainer.getUnfurledOccupant() != null && !this.fBorderContainer.getUnfurledOccupant().isSelected()) {
            this.fBorderContainer.revealCenterComponent();
        }
    }

    @Override
    public void arrangementChanged(DTDocumentContainer dTDocumentContainer, int n, int n2) {
        this.mergeToolBars(this.getDocumentContainer().getMostRecentlySelected());
        this.updateTitle();
        this.updateMaximizedVisibility();
    }

    void beginRestore() {
        this.getDocumentContainer().beginRestore();
    }

    void endRestore() {
        this.getDocumentContainer().endRestore();
        this.mergeToolBars(this.getDocumentContainer().getMostRecentlySelected());
        if (this.getDocumentContainer().getArrangement() == 1) {
            this.updateTitle();
        }
    }

    private void addSingletonContainers() {
        if (this.fGroup.getDesktop().isDockedMinMaxSupportedAndEnabled()) {
            if (this.fBorderContainer == null) {
                this.fContentPane.remove((Component)((Object)this.getDocumentContainer()));
                this.fBorderContainer = new DTBorderContainer(this.fGroup.getDesktop(), null, this.fGroup);
                this.fNestingContainer = new DTNestingContainer(this.fGroup.getDesktop(), this);
                this.fBorderContainer.setFrame(this.fGroup.getContainingFrame());
                this.fNestingContainer.setFrame(this.fGroup.getContainingFrame());
                this.fBorderContainer.setCenterComponent((Component)((Object)this.fNestingContainer));
                this.fContentPane.add((Component)((Object)this.fBorderContainer), "Center");
            }
        } else if (this.fNestingContainer == null) {
            this.fContentPane.remove((Component)((Object)this.getDocumentContainer()));
            this.fNestingContainer = new DTNestingContainer(this.fGroup.getDesktop(), this);
            this.fNestingContainer.setFrame(this.fGroup.getContainingFrame());
            this.fContentPane.add((Component)((Object)this.fNestingContainer), "Center");
        }
    }

    void revealNestingContainer() {
        if (this.fBorderContainer != null) {
            this.fBorderContainer.revealCenterComponent();
        }
    }

    @Override
    Dimension getMinimumVisibleSize() {
        Dimension dimension = super.getMinimumVisibleSize();
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer();
        DTClient dTClient = dTDocumentContainer.getMostRecentlySelected();
        dimension.height = (int)((double)dimension.height + (dTClient == null ? 24.0 : dTClient.getInternalFrame().getMinimumVisibleSize().getHeight()));
        Rectangle rectangle = dTDocumentContainer.getTabsBounds();
        int n = dTDocumentContainer.getTabsEdge();
        if (n == 1 || n == 5) {
            dimension.height += rectangle.height;
        } else if (n == 7 || n == 3) {
            dimension.width += rectangle.width;
        }
        return dimension;
    }

    @Override
    protected void configureTitleBar(DTTitleBar dTTitleBar) {
        super.configureTitleBar(dTTitleBar);
        dTTitleBar.setName(this.fGroup.getTitle() + "TitleBar");
        dTTitleBar.setTitle(this.fGroup.getTitle());
        dTTitleBar.setShortTitle(this.fGroup.getTitle());
        dTTitleBar.setIcon(this.fGroup.getSmallIcon());
        dTTitleBar.setPromoteClose(true);
    }

    @Override
    protected Action getTitleBarCloseAction() {
        return this.fTitleBarCloseAllowed && this.fGroup.permitUserClose() ? this.fGroup.getCloseDockedAction() : null;
    }

    private void updateTitle() {
        String string;
        if (this.fTitleBar == null) {
            return;
        }
        String string2 = string = this.fGroup.getTitle();
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer();
        if (this.fGroup.shouldAppendDocumentTitle() && dTDocumentContainer.getMostRecentlySelected() != null) {
            DTClient dTClient = dTDocumentContainer.getMostRecentlySelected();
            string = string + " - " + dTClient.getSomeTitle();
            string2 = string2 + " - " + dTClient.getShortTitle();
        }
        this.fTitleBar.setTitle(string);
        this.fTitleBar.setTabTitle(string2);
    }

    private void mergeToolBars(DTClient dTClient) {
        if (dTClient != this.fMergedDocument || dTClient == null) {
            this.fToolBarContainer.removeAllToolBars();
            if (!this.usingToolstrip() && !this.fGroup.placeToolBarsWithDocumentBar()) {
                if (dTClient != null) {
                    this.fToolBarContainer.setOfferToggles(dTClient.offerToolBarToggles());
                } else {
                    this.fToolBarContainer.setOfferToggles(this.fGroup.offerToolBarToggles());
                }
                JToolBar[] jToolBarArray = null;
                String[] stringArray = null;
                String[] stringArray2 = null;
                JComponent jComponent = null;
                if (dTClient != null) {
                    jToolBarArray = dTClient.getToolBars();
                    stringArray = dTClient.getToolBarKeys();
                    stringArray2 = dTClient.getToolBarLabels();
                    jComponent = dTClient.getToolBarAlternative();
                }
                if (jComponent == null && (jToolBarArray == null || jToolBarArray.length == 0)) {
                    jToolBarArray = this.fGroup.getToolBars();
                    stringArray = this.fGroup.getToolBarKeys();
                    stringArray2 = this.fGroup.getToolBarLabels();
                    jComponent = this.fGroup.getToolBarAlternative();
                }
                this.fToolBarContainer.setToolBarAlternative(jComponent);
                for (int i = 0; i < jToolBarArray.length; ++i) {
                    this.fToolBarContainer.addToolBar(jToolBarArray[i], stringArray[i], stringArray2[i]);
                }
                Object object = this.fGroup.getToolBarState();
                if (object != null) {
                    this.fToolBarContainer.restoreState(object);
                }
            } else if (this.fGroup.placeToolBarsWithDocumentBar()) {
                JToolBar[] jToolBarArray = null;
                if (dTClient != null) {
                    jToolBarArray = dTClient.getToolBars();
                }
                if (jToolBarArray == null || jToolBarArray.length == 0) {
                    jToolBarArray = this.fGroup.getToolBars();
                }
                if (jToolBarArray != null) {
                    this.getDocumentContainer().setTopLeftToolBar(jToolBarArray.length >= 1 ? jToolBarArray[0] : null);
                }
            }
            this.fMaximizedButtons.setClient(dTClient);
            this.fMergedDocument = dTClient;
            this.updateMaximizedVisibility();
        }
    }

    private void updateMaximizedVisibility() {
        if (this.fMaximizedButtons == null) {
            return;
        }
        boolean bl = this.getDocumentContainer().getArrangement() == 1 && this.fMaximizedButtons.getClient() != null;
        this.fMaximizedButtons.setVisible(bl);
    }

    @Override
    public void toolBarStateChanged(Object object) {
        this.fGroup.updateToolBarState(object);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        Object object = propertyChangeEvent.getSource();
        if (object instanceof DTClient) {
            DTClient dTClient = (DTClient)object;
            if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    if (!dTClient.isSingleton()) {
                        this.mergeToolBars(dTClient);
                    }
                } else if (dTClient == this.fMergedDocument && this.fGroup.getDocumentContainer().getArrangement() != 1) {
                    SwingUtilities.invokeLater(new DeselectionToolBarUpdater(dTClient));
                }
                this.updateTitle();
            } else if (DTClientProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updateTitle();
            } else if (DTProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName()) || DTProperty.TOOL_BAR_ALTERNATIVE.toString().equals(propertyChangeEvent.getPropertyName())) {
                if (dTClient == this.fMergedDocument) {
                    this.fMergedDocument = null;
                    this.mergeToolBars(dTClient);
                    this.fToolBarContainer.refreshAll();
                }
            } else if (DTProperty.OFFER_TOOLBAR_TOGGLES.toString().equals(propertyChangeEvent.getPropertyName()) && dTClient == this.fMergedDocument) {
                this.fToolBarContainer.setOfferToggles((Boolean)propertyChangeEvent.getNewValue());
            }
        } else if (object == this.fGroup) {
            if (DTProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName()) || DTGroupProperty.APPEND_DOCUMENT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updateTitle();
            } else if (DTProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName()) || DTProperty.TOOL_BAR_ALTERNATIVE.toString().equals(propertyChangeEvent.getPropertyName())) {
                if (this.fMergedDocument == null) {
                    this.mergeToolBars(null);
                    this.fToolBarContainer.refreshAll();
                }
            } else if (DTProperty.OFFER_TOOLBAR_TOGGLES.toString().equals(propertyChangeEvent.getPropertyName())) {
                if (this.fMergedDocument == null) {
                    this.fToolBarContainer.setOfferToggles((Boolean)propertyChangeEvent.getNewValue());
                }
            } else if (DTGroupProperty.PERMIT_USER_TILE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.fArrangementControls.setTilingEnabled(this.fGroup.permitUserTile());
            } else if (DTGroupProperty.PERMIT_USER_FLOAT.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.fArrangementControls.setFloatingEnabled(this.fGroup.permitUserFloat());
            }
        }
    }

    @Override
    public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int n;
        DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)SwingUtilities.getAncestorOfClass(DTInternalFrame.class, mouseEvent.getComponent()));
        if (dTInternalFrame != null && dTInternalFrame.getOccupant() instanceof DTClient) {
            DTClient dTClient = (DTClient)dTInternalFrame.getOccupant();
            if (dTClient.isSingleton()) {
                return;
            }
            n = this.fGroup.getDocumentContainer().getArrangement();
            if (n == 3 || n == 2) {
                return;
            }
        }
        super.contributeToMenu(jPopupMenu, mouseEvent);
        if (this.fMergedDocument != null && this.fMergedDocument.permitUserUndock()) {
            int n2 = jPopupMenu.getComponentCount();
            for (n = 0; n < jPopupMenu.getComponentCount(); ++n) {
                Component component = jPopupMenu.getComponent(n);
                if (!(component instanceof JMenuItem) || DTMenuMergeTag.getTag((JMenuItem)component) != DTMenuMergeTag.UNDOCK) continue;
                n2 = n + 1;
                break;
            }
            ChildAction childAction = new ChildAction((Action)this.fMergedDocument.getUndockAction());
            childAction.putValue("AcceleratorKey", ChildAction.NULL_VALUE);
            jPopupMenu.insert((Action)childAction, n2);
        }
    }

    DTMaximizedButtonPanel borrowMaximizedButtons() {
        if (this.fMaximizedButtons != null) {
            if (PlatformInfo.isMacintosh()) {
                this.fToolBarContainer.removeLeftCorner((JComponent)((Object)this.fMaximizedButtons));
            } else {
                this.fUpperRightPanel.remove((Component)((Object)this.fMaximizedButtons));
            }
        }
        return this.fMaximizedButtons;
    }

    void returnMaximizedButtons() {
        if (this.fMaximizedButtons != null) {
            if (PlatformInfo.isMacintosh()) {
                this.fToolBarContainer.addLeftCorner((JComponent)((Object)this.fMaximizedButtons));
            } else {
                this.fUpperRightPanel.add((Component)((Object)this.fMaximizedButtons));
            }
        }
    }

    DTMaximizedButtonPanel getMaximizedButtons() {
        return this.fMaximizedButtons;
    }

    JComboBox getArrangementComboBox() {
        return this.fArrangementControls.fArrangementComboBox;
    }

    private static class SureFireComboBox
    extends MJComboBox
    implements PopupMenuListener {
        private boolean iActionPending;

        SureFireComboBox(Object[] objectArray) {
            super(objectArray);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.iActionPending = true;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.iActionPending = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (this.iActionPending) {
                this.fireActionEvent();
            }
        }

        protected void fireActionEvent() {
            this.iActionPending = false;
            super.fireActionEvent();
        }
    }

    private static class ArrangementIconRenderer
    extends MJPanel
    implements ListCellRenderer {
        Icon fIcon;
        Color fBackground;

        ArrangementIconRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Action action = (Action)object;
            this.fIcon = (Icon)action.getValue("SmallIcon");
            Color color = this.fBackground = bl && n >= 0 ? jList.getSelectionBackground() : jList.getBackground();
            if (n >= 0) {
                jList.setToolTipText((String)action.getValue("ShortDescription"));
            }
            return this;
        }

        public Dimension getPreferredSize() {
            return this.fIcon != null ? new Dimension(this.fIcon.getIconWidth() + 4, this.fIcon.getIconHeight() + 2) : new Dimension(0, 0);
        }

        public void paintComponent(Graphics graphics) {
            if (this.fIcon != null) {
                graphics.setColor(this.fBackground);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.fIcon.paintIcon((Component)((Object)this), graphics, 0, PlatformInfo.isMacintosh() ? 1 : -1);
            }
        }
    }

    class ArrangementControls
    extends MJPanel {
        MJToolBar fArrangementToolBar;
        MJComboBox fArrangementComboBox;
        Action[] fActions = new Action[5];
        JToggleButton[] fToggles = new JToggleButton[5];
        PropertyChangeListener fSelectionListener;
        boolean fIsRespondingToPropertyChange;
        boolean fIsShowingTileControls = true;
        boolean fIsShowingFloatControl = true;

        ArrangementControls() {
            this.setLayout(null);
            DTDocumentContainer dTDocumentContainer = DTGroupFrame.this.getDocumentContainer();
            this.fArrangementToolBar = new MJToolBar();
            this.fArrangementToolBar.setName("ArrangementToolBar");
            this.fArrangementToolBar.setFloatable(false);
            this.fArrangementToolBar.setBorder(BorderFactory.createEmptyBorder());
            this.fToggles[0] = this.fArrangementToolBar.addToggle((Action)((Object)dTDocumentContainer.getTileAction()));
            ((MJToggleButton)this.fToggles[0]).setFocusTraversable(true);
            this.fToggles[0].setFocusPainted(false);
            this.fToggles[0].addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger() && !MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent)) {
                        DTGroupFrame.this.getDocumentContainer().getTileAction().buttonPressed((Component)mouseEvent.getSource());
                    }
                }
            });
            this.fToggles[1] = this.fArrangementToolBar.addToggle((Action)dTDocumentContainer.getSplitEastWestAction());
            this.fToggles[2] = this.fArrangementToolBar.addToggle((Action)dTDocumentContainer.getSplitNorthSouthAction());
            this.fToggles[3] = this.fArrangementToolBar.addToggle((Action)dTDocumentContainer.getFloatAction());
            this.fToggles[4] = this.fArrangementToolBar.addToggle((Action)dTDocumentContainer.getMaximizeAction());
            MacAppearanceUtils.createMacToolBarButtonGroup((AbstractButton[])this.fToggles);
            int n = 0;
            this.fActions[n++] = dTDocumentContainer.getTileAction();
            this.fActions[n++] = dTDocumentContainer.getSplitEastWestAction();
            this.fActions[n++] = dTDocumentContainer.getSplitNorthSouthAction();
            this.fActions[n++] = dTDocumentContainer.getFloatAction();
            this.fActions[n] = dTDocumentContainer.getMaximizeAction();
            this.fArrangementComboBox = new SureFireComboBox(this.fActions);
            this.fArrangementComboBox.setName("ArrangementComboBox");
            for (n = 0; n < this.fActions.length; ++n) {
                if (!((MJAbstractAction)this.fActions[n]).isSelected()) continue;
                this.fArrangementComboBox.setSelectedIndex(n);
            }
            this.fArrangementComboBox.setToolTipText(DTGroupFrame.this.getOccupant().getDesktop().getString("tooltip.ArrangeDocuments"));
            this.fArrangementComboBox.setRenderer((ListCellRenderer)new ArrangementIconRenderer());
            this.fArrangementComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getModifiers() != 0 && !ArrangementControls.this.fIsRespondingToPropertyChange) {
                        Action action = (Action)ArrangementControls.this.fArrangementComboBox.getSelectedItem();
                        action.actionPerformed(actionEvent);
                    }
                }
            });
            this.fArrangementComboBox.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        Action action = (Action)ArrangementControls.this.fArrangementComboBox.getSelectedItem();
                        action.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, ""));
                        ArrangementControls.this.fArrangementComboBox.setPopupVisible(false);
                    } else if (keyEvent.getKeyCode() == 27) {
                        for (Action action : ArrangementControls.this.fActions) {
                            if (!((MJAbstractAction)action).isSelected()) continue;
                            ArrangementControls.this.fIsRespondingToPropertyChange = true;
                            ArrangementControls.this.fArrangementComboBox.setSelectedItem((Object)action);
                            ArrangementControls.this.fIsRespondingToPropertyChange = false;
                            break;
                        }
                    }
                }
            });
            this.fSelectionListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Boolean bl;
                    if (propertyChangeEvent.getPropertyName().equals("checked") && (bl = (Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        ArrangementControls.this.fIsRespondingToPropertyChange = true;
                        ArrangementControls.this.fArrangementComboBox.setSelectedItem(propertyChangeEvent.getSource());
                        ArrangementControls.this.fIsRespondingToPropertyChange = false;
                    }
                }
            };
            for (n = 0; n < this.fActions.length; ++n) {
                this.fActions[n].addPropertyChangeListener(this.fSelectionListener);
            }
            this.setTilingEnabled(DTGroupFrame.this.fGroup.permitUserTile());
            this.setFloatingEnabled(DTGroupFrame.this.fGroup.permitUserFloat());
            this.add((Component)this.fArrangementToolBar);
            this.add((Component)this.fArrangementComboBox);
        }

        void setTilingEnabled(boolean bl) {
            if (bl == this.fIsShowingTileControls) {
                return;
            }
            this.fToggles[0].setVisible(bl);
            this.fToggles[1].setVisible(bl);
            this.fToggles[2].setVisible(bl);
            if (bl) {
                this.fArrangementComboBox.insertItemAt((Object)this.fActions[0], 0);
                this.fArrangementComboBox.insertItemAt((Object)this.fActions[1], 1);
                this.fArrangementComboBox.insertItemAt((Object)this.fActions[2], 2);
            } else {
                this.fArrangementComboBox.removeItem((Object)this.fActions[0]);
                this.fArrangementComboBox.removeItem((Object)this.fActions[1]);
                this.fArrangementComboBox.removeItem((Object)this.fActions[2]);
            }
            this.fIsShowingTileControls = bl;
            this.updateControlsVisibility();
            this.revalidate();
            this.repaint();
        }

        void setFloatingEnabled(boolean bl) {
            if (bl == this.fIsShowingFloatControl) {
                return;
            }
            this.fToggles[3].setVisible(bl);
            if (bl) {
                int n = this.fArrangementComboBox.getItemCount();
                this.fArrangementComboBox.insertItemAt((Object)this.fActions[3], n - 1);
            } else {
                this.fArrangementComboBox.removeItem((Object)this.fActions[3]);
            }
            this.fIsShowingFloatControl = bl;
            this.updateControlsVisibility();
            this.revalidate();
            this.repaint();
        }

        void updateControlsVisibility() {
            boolean bl = this.fIsShowingTileControls || this.fIsShowingFloatControl;
            this.fArrangementToolBar.setVisible(bl);
            this.fArrangementComboBox.setVisible(bl);
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            Dimension dimension = this.fArrangementToolBar.getPreferredSize();
            Dimension dimension2 = this.fArrangementComboBox.getPreferredSize();
            int n = this.fIsShowingTileControls ? dimension2.width : dimension.width;
            return new Dimension(n + insets.left + insets.right, Math.max(dimension.height, dimension2.height + 2));
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            Dimension dimension = this.fArrangementToolBar.getPreferredSize();
            Dimension dimension2 = this.fArrangementComboBox.getPreferredSize();
            return new Dimension(dimension.width + insets.left + insets.right, Math.max(dimension.height, dimension2.height + 2));
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 2);
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            Dimension dimension = this.fArrangementToolBar.getPreferredSize();
            int n = insets.left;
            int n2 = this.getWidth() - insets.right;
            int n3 = insets.top;
            int n4 = this.getHeight() - insets.top - insets.bottom;
            int n5 = this.fArrangementComboBox.getPreferredSize().width;
            if (n2 - n < dimension.width) {
                this.fArrangementComboBox.setBounds(n2 - n5, n3 + 1, n5, n4 - 4);
                this.fArrangementToolBar.setBounds(this.getWidth() + 1, n3, dimension.width, n4);
                n2 -= n5;
            } else {
                this.fArrangementToolBar.setBounds(n2 - dimension.width, n3, dimension.width, n4);
                this.fArrangementComboBox.setBounds(this.getWidth() + 1, n3, n5, n4);
                n2 -= dimension.width;
            }
        }

        void cleanup() {
            this.fArrangementToolBar.dispose();
            for (Action action : this.fActions) {
                action.removePropertyChangeListener(this.fSelectionListener);
            }
        }
    }

    private class DeselectionToolBarUpdater
    implements Runnable {
        DTClient iDeselectedDocument;

        DeselectionToolBarUpdater(DTClient dTClient) {
            this.iDeselectedDocument = dTClient;
        }

        @Override
        public void run() {
            if (this.iDeselectedDocument == DTGroupFrame.this.fMergedDocument) {
                DTClient dTClient = DTGroupFrame.this.getDocumentContainer().getMostRecentlySelected();
                if (dTClient != null && dTClient.getLocation().isMinimized()) {
                    DTGroupFrame.this.mergeToolBars(null);
                }
                if (DTGroupFrame.this.isSelected() && DTGroupFrame.this.fGroup.getDesktop().getSelectionManager().getSelectedClient() == null) {
                    DTGroupFrame.this.mergeToolBars(null);
                }
            }
        }
    }
}

