/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentTabs;
import com.mathworks.widgets.desk.Desktop;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class DTDocumentTabsProperties {
    private Desktop fDesktop;
    private DTDocumentTabsProperties fParent;
    private int fEdge = 1;
    private int fMaxWidth = 250;
    private int fMinWidth = 120;
    private boolean fShrinkToFit = false;
    private Comparator<DTClient> fComparator;
    private List<DTDocumentTabs> fTabs = new ArrayList<DTDocumentTabs>();
    private List<Listener> fListeners = new ArrayList<Listener>();
    private Map<Integer, MJAbstractAction> fMoveTabsActions = new HashMap<Integer, MJAbstractAction>();
    private MJAbstractAction fToggleShrinkToFitAction;

    DTDocumentTabsProperties(Desktop desktop) {
        this.fDesktop = desktop;
    }

    DTDocumentTabsProperties(DTDocumentTabsProperties dTDocumentTabsProperties) {
        this.fDesktop = dTDocumentTabsProperties.fDesktop;
        this.fParent = dTDocumentTabsProperties;
        this.syncFromParent();
        this.fEdge = dTDocumentTabsProperties.fEdge;
        this.fMaxWidth = dTDocumentTabsProperties.fMaxWidth;
        this.fMinWidth = dTDocumentTabsProperties.fMinWidth;
        this.fShrinkToFit = dTDocumentTabsProperties.fShrinkToFit;
        this.fComparator = dTDocumentTabsProperties.fComparator;
    }

    int getEdge() {
        return this.fEdge;
    }

    int getMaxWidth() {
        return this.fMaxWidth;
    }

    int getMinWidth() {
        return this.fMinWidth;
    }

    boolean getShrinkToFit() {
        return this.fShrinkToFit;
    }

    Comparator<DTClient> getComparator() {
        return this.fComparator;
    }

    void setEdge(int n) {
        if (n != this.fEdge || n != this.getAggregateEdge()) {
            this.fEdge = n;
            for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
                dTDocumentTabs.setEdge(n);
            }
            this.updateMoveActions();
            if (this.fParent != null) {
                this.fParent.syncEdgeFromTabs();
                this.fParent.updateMoveActions();
            }
            this.fireListeners(Type.EDGE);
        }
    }

    void setMaxWidth(int n) {
        if (n != this.fMaxWidth) {
            this.fMaxWidth = n;
            for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
                dTDocumentTabs.setMaxWidth(n);
            }
            this.fireListeners(Type.MAX_WIDTH);
        }
    }

    void setMinWidth(int n) {
        if (n != this.fMinWidth) {
            this.fMaxWidth = n;
            for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
                dTDocumentTabs.setMaxWidth(n);
            }
            this.fireListeners(Type.MIN_WIDTH);
        }
    }

    void setShrinkToFit(boolean bl) {
        if (bl != this.fShrinkToFit) {
            this.fShrinkToFit = bl;
            for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
                dTDocumentTabs.setShrinkTabsToFit(bl);
            }
            if (this.fToggleShrinkToFitAction != null) {
                this.fToggleShrinkToFitAction.setSelected(this.fShrinkToFit);
            }
            this.fireListeners(Type.SHRINK_TO_FIT);
        }
    }

    void setComparator(Comparator<DTClient> comparator) {
        if (comparator != this.fComparator) {
            this.fComparator = comparator;
            for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
                dTDocumentTabs.setComparator(comparator);
            }
            this.fireListeners(Type.COMPARATOR);
        }
    }

    void register(DTDocumentTabs dTDocumentTabs) {
        this.fTabs.add(dTDocumentTabs);
    }

    void unregister(DTDocumentTabs dTDocumentTabs) {
        this.fTabs.remove((Object)dTDocumentTabs);
    }

    void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    private void fireListeners(Type type) {
        for (Listener listener : this.fListeners) {
            listener.tabPropertyChanged(this, type);
        }
    }

    MJAbstractAction getMoveAction(int n) {
        MJAbstractAction mJAbstractAction = this.fMoveTabsActions.get(n);
        if (mJAbstractAction == null) {
            mJAbstractAction = new MoveTabsAction(n);
            this.fMoveTabsActions.put(n, mJAbstractAction);
        }
        return mJAbstractAction;
    }

    void syncFromParent() {
        if (this.fParent != null) {
            this.setEdge(this.fParent.getEdge());
            this.setMaxWidth(this.fParent.getMaxWidth());
            this.setMinWidth(this.fParent.getMinWidth());
            this.setShrinkToFit(this.fParent.getShrinkToFit());
            this.setComparator(this.fParent.getComparator());
        }
    }

    private void syncEdgeFromTabs() {
        if (this.fTabs.isEmpty()) {
            return;
        }
        int n = 0;
        for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
            if (!dTDocumentTabs.isShowing()) continue;
            if (n == 0) {
                n = dTDocumentTabs.getEdge();
                continue;
            }
            if (n == dTDocumentTabs.getEdge()) continue;
            return;
        }
        if (n != 0) {
            this.setEdge(n);
        }
    }

    private int getAggregateEdge() {
        if (this.fTabs.size() <= 1) {
            return this.fEdge;
        }
        int n = 0;
        for (DTDocumentTabs dTDocumentTabs : this.fTabs) {
            if (!dTDocumentTabs.isShowing()) continue;
            if (n == 0) {
                n = dTDocumentTabs.getEdge();
                continue;
            }
            if (n == dTDocumentTabs.getEdge()) continue;
            n = 0;
            break;
        }
        return n;
    }

    void updateMoveActions() {
        int n = this.getAggregateEdge();
        for (Map.Entry<Integer, MJAbstractAction> entry : this.fMoveTabsActions.entrySet()) {
            entry.getValue().setSelected(entry.getKey() == n);
        }
    }

    MJAbstractAction getToggleShrinkToFitAction() {
        if (this.fToggleShrinkToFitAction == null) {
            this.fToggleShrinkToFitAction = new ToggleShrinkToFitAction();
        }
        return this.fToggleShrinkToFitAction;
    }

    String labelForPosition(int n) {
        switch (n) {
            case 1: {
                return this.fDesktop.getString("menuitem.North");
            }
            case 5: {
                return this.fDesktop.getString("menuitem.South");
            }
            case 7: {
                return this.fDesktop.getString("menuitem.West");
            }
            case 3: {
                return this.fDesktop.getString("menuitem.East");
            }
            case -1: {
                return this.fDesktop.getString("menuitem.Hide");
            }
        }
        return null;
    }

    private ImageIcon iconForPosition(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "bar_top_ts_16.png";
                break;
            }
            case 5: {
                string = "bar_bottom_ts_16.png";
                break;
            }
            case 7: {
                string = "bar_left_ts_16.png";
                break;
            }
            case 3: {
                string = "bar_right_ts_16.png";
                break;
            }
            case -1: {
                string = "bar_hidden_ts_16.png";
            }
        }
        return IconEnumerationUtils.getIcon((String)string);
    }

    private class ToggleShrinkToFitAction
    extends MJAbstractAction {
        private ToggleShrinkToFitAction() {
            super(DTDocumentTabsProperties.this.fDesktop.getString("Tool.shrink_tabs.Label"));
            this.setComponentName("ToggleShrinkToFit");
            this.setSelected(DTDocumentTabsProperties.this.fShrinkToFit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentTabsProperties.this.setShrinkToFit(this.isSelected());
        }
    }

    private class MoveTabsAction
    extends MJAbstractAction {
        int iToEdge;

        private MoveTabsAction(int n) {
            super(DTDocumentTabsProperties.this.labelForPosition(n), (Icon)DTDocumentTabsProperties.this.iconForPosition(n));
            this.iToEdge = n;
            this.setSelected(n == DTDocumentTabsProperties.this.fEdge);
            this.setComponentName("TabsTo" + this.getName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentTabsProperties.this.setEdge(this.iToEdge);
            this.setSelected(DTDocumentTabsProperties.this.fEdge == this.iToEdge);
        }
    }

    static interface Listener {
        public void tabPropertyChanged(DTDocumentTabsProperties var1, Type var2);
    }

    static enum Type {
        EDGE,
        MAX_WIDTH,
        MIN_WIDTH,
        SHRINK_TO_FIT,
        COMPARATOR;

    }
}

