/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class DTDocumentBarMenu
extends MJMenu
implements MenuListener {
    private Desktop fDesktop;
    private DTDocumentContainer fDocumentContainer;

    DTDocumentBarMenu(Desktop desktop, DTDocumentContainer dTDocumentContainer) {
        super(desktop.getString("menu.DocumentBar"));
        this.fDesktop = desktop;
        this.fDocumentContainer = dTDocumentContainer;
        if (DTUtilities.usingMacScreenMenus()) {
            this.populate();
        } else {
            this.addMenuListener(this);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.fDocumentContainer == null) {
            return;
        }
        this.populate();
    }

    private void populate() {
        MJAbstractAction mJAbstractAction = this.fDocumentContainer.getGroup().getAlphabetizeAction();
        if (mJAbstractAction != null) {
            this.add((JMenuItem)new MJCheckBoxMenuItem((Action)mJAbstractAction));
        }
        this.add((JMenuItem)((Object)new BarPositionMenu()));
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTDocumentBarMenu.this.dispose();
                DTDocumentBarMenu.this.removeAll();
                if (!Arrays.asList(DTDocumentBarMenu.this.getMenuListeners()).contains(DTDocumentBarMenu.this)) {
                    DTDocumentBarMenu.this.addMenuListener(DTDocumentBarMenu.this);
                }
            }
        });
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.menuDeselected(menuEvent);
    }

    class BarPositionMenu
    extends MJMenu
    implements MenuListener {
        BarPositionMenu() {
            super(DTDocumentBarMenu.this.fDesktop.getString("menu.BarPosition"));
            this.addMenuListener(this);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.getMenuComponentCount() == 0) {
                ButtonGroup buttonGroup = new ButtonGroup();
                MJRadioButtonMenuItem mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getTabsToNorthAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getTabsToSouthAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getTabsToEastAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getTabsToWestAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                this.addSeparator();
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getHideTabsAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }
}

