/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentBarMenu;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocuments;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLayoutActions;
import com.mathworks.widgets.desk.DTLayoutMenu;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class DTDesktopMenu
extends MJMenu
implements MenuListener {
    private Desktop fDesktop;
    private DTFrame fFrame;
    private DTClient fClient;
    private DTGroup fGroup;
    private DTDocumentContainer fDocumentContainer;
    private MJMenu fLayoutMenu;
    private ToolBarMenu fToolBarMenu;
    private MJMenu fDocumentBarMenu;
    private MJMenuItem fStartDesktopItem;
    private JMenuItem fStatusBarToggleItem;
    private JSeparator fStartDesktopSeparator;
    private Component fGroupSeparator;
    private int fClientItemCount;
    private int fLayoutItemCount;
    private int fSingletonItemCount;
    private int fGroupItemCount;
    private int fGroupSingletonItemCount;
    private int fToolBarItemCount;
    private boolean fToolBarItemsAdded;
    private Action fOrganizeLayoutsAction;
    private DTNotifyingList.Listener<DTClient> fSingletonListListener = new SingletonListListener();
    private DTNotifyingList.Listener<DTGroup> fGroupListListener = new GroupListListener();

    public DTDesktopMenu(Desktop desktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        super(desktop.getString("menu.Desktop"));
        this.setName("DesktopMenu");
        DTMenuMergeTag.DESKTOP.setTag((JMenuItem)((Object)this));
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fGroup = dTGroup;
        if (dTFrame.isMainFrame()) {
            int n;
            this.fLayoutMenu = new DTLayoutMenu(desktop, dTFrame);
            this.add((JMenuItem)this.fLayoutMenu);
            this.add((Action)((Object)new DTLayoutActions.SaveAction(desktop)));
            this.fOrganizeLayoutsAction = new DTLayoutActions.OrganizeAction(desktop);
            this.add(this.fOrganizeLayoutsAction);
            this.addSeparator();
            this.fLayoutItemCount = 3;
            DTNotifyingList<DTClient> dTNotifyingList = this.fDesktop.getSingletons();
            dTNotifyingList.addListener(this.fSingletonListListener);
            if (dTNotifyingList.size() > 0) {
                n = dTNotifyingList.size();
                for (int i = 0; i < n; ++i) {
                    DTClient dTClient2 = (DTClient)dTNotifyingList.get(i);
                    if (dTClient2.getGroup() != null) continue;
                    this.add((JMenuItem)((Object)new ToggleItem(dTClient2)));
                    ++this.fSingletonItemCount;
                }
                this.addSeparator();
            }
            if (!this.fDesktop.closeEmptyGroups()) {
                DTNotifyingList<DTGroup> dTNotifyingList2 = this.fDesktop.getNotifyingGroups();
                dTNotifyingList2.addListener(this.fGroupListListener);
                if (dTNotifyingList2.size() > 0) {
                    n = 0;
                    int n2 = dTNotifyingList2.size();
                    for (int i = 0; i < n2; ++i) {
                        ToggleItem toggleItem = new ToggleItem((DTGroup)dTNotifyingList2.get(i));
                        this.add((JMenuItem)((Object)toggleItem));
                        if (toggleItem.isVisible()) {
                            n = 1;
                        }
                        ++this.fGroupItemCount;
                        dTNotifyingList = ((DTGroup)dTNotifyingList2.get(i)).getSingletons();
                        for (DTClient dTClient3 : dTNotifyingList) {
                            this.add((JMenuItem)((Object)new ToggleItem(dTClient3, true)));
                            ++this.fGroupSingletonItemCount;
                        }
                    }
                    if (n != 0) {
                        this.addSeparator();
                        this.fGroupSeparator = this.getMenuComponent(this.getMenuComponentCount() - 1);
                    }
                }
            }
        } else {
            if (dTGroup != null) {
                DTNotifyingList<DTClient> dTNotifyingList = dTGroup.getSingletons();
                dTNotifyingList.addListener(this.fSingletonListListener);
                if (dTNotifyingList.size() > 0) {
                    boolean bl = false;
                    int n = this.getMenuComponentCount();
                    int n3 = dTNotifyingList.size();
                    for (int i = 0; i < n3; ++i) {
                        ToggleItem toggleItem = new ToggleItem((DTClient)dTNotifyingList.get(i));
                        this.add((JMenuItem)((Object)toggleItem));
                        if (toggleItem.isVisible()) {
                            bl = true;
                        }
                        ++this.fSingletonItemCount;
                    }
                    if (bl) {
                        this.insertSeparator(n);
                    }
                }
            }
            if (!this.fDesktop.hasMainFrame() && this.fDesktop.canHaveMainFrame()) {
                this.fStartDesktopItem = new MJMenuItem(this.fDesktop.getString("menuitem.StartDesktop"));
                this.fStartDesktopItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DTDesktopMenu.this.fDesktop.initMainFrame(false);
                    }
                });
                this.add((JMenuItem)this.fStartDesktopItem);
                this.fStartDesktopSeparator = new JSeparator();
                this.add(this.fStartDesktopSeparator);
            }
        }
        this.setClient(dTClient);
        if (this.fFrame.getToolBarContainer() != null && this.fFrame.getToolBarContainer().isAnyToolBarCustomizable()) {
            this.fToolBarMenu = new ToolBarMenu();
            this.add((JMenuItem)((Object)this.fToolBarMenu));
        }
        this.fStatusBarToggleItem = new MJCheckBoxMenuItem(this.fFrame.getToggleStatusBarAction());
        this.fStatusBarToggleItem.setVisible(false);
        if (!PlatformInfo.isMacintosh()) {
            this.add(this.fStatusBarToggleItem);
        }
        if (this.fFrame.isMainFrame()) {
            this.add((JMenuItem)new MJCheckBoxMenuItem(((DTMultipleClientFrame)this.fFrame).getToggleTitlesAction()));
        }
        this.addMenuListener(this);
    }

    void setClient(DTClient dTClient) {
        DTSelectable dTSelectable;
        DTDocumentContainer dTDocumentContainer;
        boolean bl;
        Object object;
        if (dTClient == this.fClient && this.fClient != null) {
            return;
        }
        this.fClient = dTClient;
        if (this.fToolBarMenu != null) {
            this.fToolBarMenu.clear();
        } else if (this.fToolBarItemCount > 0) {
            int n = this.getFirstToolBarIndex() + this.fToolBarItemCount - 1;
            while (this.fToolBarItemCount > 0) {
                object = this.getMenuComponent(n);
                this.remove(n);
                if (object instanceof JMenuItem) {
                    Action action = ((JMenuItem)object).getAction();
                    if (action instanceof ChildAction) {
                        ((ChildAction)action).setParent(null);
                    }
                    MJUtilities.dispose((AbstractButton)((AbstractButton)object));
                }
                --n;
                --this.fToolBarItemCount;
            }
        }
        this.fToolBarItemsAdded = false;
        if (this.fClientItemCount > 0) {
            while (this.fClientItemCount > 0) {
                Component component = this.getMenuComponent(0);
                this.remove(0);
                if (component instanceof JMenuItem) {
                    MJUtilities.dispose((AbstractButton)((AbstractButton)component));
                }
                --this.fClientItemCount;
            }
        }
        DTGroup dTGroup = this.fGroup;
        if (this.fClient != null) {
            dTGroup = this.fClient.getGroup();
        } else {
            object = ((DTMultipleClientFrame)this.fFrame).getSelection();
            if (object instanceof DTGroup) {
                dTGroup = (DTGroup)object;
            }
        }
        if (this.fClient != null && this.fFrame instanceof DTMultipleClientFrame && !PlatformInfo.isMacintosh()) {
            this.insert((Action)this.fClient.getResizeAction(), 0);
            ++this.fClientItemCount;
            this.insert((Action)this.fClient.getMoveAction(), 0);
            ++this.fClientItemCount;
        }
        boolean bl2 = bl = !(!this.fDesktop.hasMainFrame() || !(this.fFrame instanceof DTMultipleClientFrame) || dTGroup == null || dTGroup.getLocation() == null || dTGroup.getTitle() == null || !dTGroup.getLocation().isDocked() && !dTGroup.isDockable() || dTGroup.getLocation().isDocked() && !dTGroup.permitUserUndock());
        if (!(this.fClient == null || !this.fClient.isDockable() || this.fClient.getLocation() == null || this.fClient.getLocation().isDocked() && !this.fClient.permitUserUndock() || this.fClient.isSingleton() && !this.fDesktop.hasMainFrame() && this.fClient.getGroup() == null)) {
            boolean bl3 = this.fClient.getLocation().isDocked();
            if (bl3 && bl && dTGroup.getLocation().isDocked()) {
                dTDocumentContainer = new ChildAction((Action)this.fClient.getUndockAction());
                dTDocumentContainer.putValue("AcceleratorKey", ChildAction.NULL_VALUE);
                this.insert((Action)((Object)dTDocumentContainer), 0);
            } else {
                this.insert((Action)(bl3 ? this.fClient.getUndockAction() : this.fClient.getDockAction()), 0);
            }
            ++this.fClientItemCount;
        }
        if (this.fClient != null && this.fFrame instanceof DTMultipleClientFrame && this.fClient.isSingleton()) {
            if (this.fClient.permitUserMaximize()) {
                this.insert((Action)this.fClient.getMaximizeAction(), 0);
                ++this.fClientItemCount;
            }
            if (this.fClient.permitUserMinimize()) {
                this.insert((Action)this.fClient.getMinimizeAction(), 0);
                ++this.fClientItemCount;
            }
        }
        if (this.fFrame.isMainFrame() && dTGroup != null && dTGroup.getLocation() != null && !PlatformInfo.isMacintosh()) {
            this.insert((Action)dTGroup.getResizeAction(), 0);
            ++this.fClientItemCount;
            this.insert((Action)dTGroup.getMoveAction(), 0);
            ++this.fClientItemCount;
        }
        if (bl) {
            boolean bl4 = dTGroup.getLocation().isDocked();
            this.insert((Action)(bl4 ? dTGroup.getUndockAction() : dTGroup.getDockAction()), 0);
            ++this.fClientItemCount;
        }
        if (this.fClient != null && this.fClient.getGroup() != null && this.fFrame instanceof DTSingleClientFrame) {
            this.insert((Action)this.fClient.getGroup().getDockAllAction(), 0);
            ++this.fClientItemCount;
        }
        if (this.fFrame.isMainFrame() && dTGroup != null && dTGroup.getLocation() != null) {
            if (dTGroup.permitUserMaximize()) {
                this.insert((Action)dTGroup.getMaximizeAction(), 0);
                ++this.fClientItemCount;
            }
            if (dTGroup.permitUserMinimize()) {
                this.insert((Action)dTGroup.getMinimizeAction(), 0);
                ++this.fClientItemCount;
            }
        }
        if (this.fClient == null && this.fFrame.isMainFrame() && (dTSelectable = ((DTMultipleClientFrame)this.fFrame).getSelection()) instanceof DTDocumentContainer && (dTDocumentContainer = (DTDocumentContainer)((Object)dTSelectable)).getGroup() != null) {
            this.insert((Action)dTDocumentContainer.getGroup().getUndockAction(), 0);
            ++this.fClientItemCount;
        }
        if (this.fClientItemCount > 0 && this.fFrame.isMainFrame()) {
            this.insertSeparator(this.fClientItemCount++);
        }
    }

    void refreshClient(DTClient dTClient) {
        this.fClient = null;
        this.setClient(dTClient);
    }

    void refresh() {
        this.refreshClient(this.fClient);
    }

    void mainFrameCreated() {
        if (this.fStartDesktopItem != null) {
            this.remove((JMenuItem)this.fStartDesktopItem);
            this.remove(this.fStartDesktopSeparator);
            this.fStartDesktopItem = null;
            this.fStartDesktopSeparator = null;
        }
        this.refreshClient(this.fClient);
    }

    void mainFrameDestroyed() {
        this.refreshClient(this.fClient);
        if (this.fStartDesktopItem == null) {
            this.fStartDesktopItem = new MJMenuItem(this.fDesktop.getString("menuitem.StartDesktop"));
            this.fStartDesktopItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DTDesktopMenu.this.fDesktop.initMainFrame(false);
                }
            });
            this.insertSeparator(0);
            this.fStartDesktopSeparator = (JSeparator)this.getMenuComponent(0);
            this.insert((JMenuItem)this.fStartDesktopItem, 0);
        }
    }

    void setDocumentContainer(DTDocumentContainer dTDocumentContainer) {
        Component component;
        if (this.fDocumentContainer == dTDocumentContainer) {
            return;
        }
        DTDocumentContainer dTDocumentContainer2 = this.fDocumentContainer;
        this.fDocumentContainer = dTDocumentContainer;
        if (dTDocumentContainer2 != null && dTDocumentContainer2.getGroup() != null && this.fClient == null && this.fClientItemCount > 0 && (component = this.getMenuComponent(0)) instanceof JMenuItem && ((JMenuItem)component).getAction() == dTDocumentContainer2.getGroup().getUndockAction()) {
            this.remove(0);
            --this.fClientItemCount;
            if (this.fClientItemCount == 1) {
                this.remove(0);
                this.fClientItemCount = 0;
            }
        }
        if (this.fDocumentBarMenu != null) {
            this.remove((JMenuItem)this.fDocumentBarMenu);
            this.fDocumentBarMenu = null;
        }
        if (this.fDocumentContainer != null) {
            this.fDocumentBarMenu = new DTDocumentBarMenu(this.fDesktop, this.fDocumentContainer);
            this.add((JMenuItem)this.fDocumentBarMenu);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fFrame.isMainFrame()) {
            this.fDesktop.getSingletons().removeListener(this.fSingletonListListener);
            this.fDesktop.getNotifyingGroups().removeListener(this.fGroupListListener);
        } else if (this.fGroup != null) {
            this.fGroup.getSingletons().removeListener(this.fSingletonListListener);
        }
        if (PlatformInfo.isMacintosh()) {
            MJUtilities.dispose((AbstractButton)this.fStatusBarToggleItem);
        }
    }

    private int getFirstSingletonIndex() {
        return this.fClientItemCount + this.fLayoutItemCount + (this.fLayoutItemCount > 0 ? 1 : 0);
    }

    private int getFirstGroupIndex() {
        return this.getFirstSingletonIndex() + this.fSingletonItemCount + (this.fSingletonItemCount > 0 ? 1 : 0);
    }

    private int getGroupIndex(DTGroup dTGroup) {
        Component component;
        for (int i = this.getFirstGroupIndex(); i < this.getMenuComponentCount() && (component = this.getMenuComponent(i)) instanceof ToggleItem; ++i) {
            if (((ToggleItem)((Object)component)).getAction() != dTGroup.getToggleAction()) continue;
            return i;
        }
        return -1;
    }

    private int getFirstToolBarIndex() {
        return this.getFirstGroupIndex() + this.fGroupItemCount + (this.fGroupSeparator != null ? 1 : 0) + this.fGroupSingletonItemCount;
    }

    private void updateGroupSeparator() {
        boolean bl = false;
        int n = this.getFirstGroupIndex();
        int n2 = n + this.fGroupItemCount;
        for (int i = n; i < n2; ++i) {
            Component component = this.getMenuComponent(i);
            if (!component.isVisible()) continue;
            bl = true;
        }
        if (bl && this.fGroupSeparator == null) {
            this.insertSeparator(n2);
            this.fGroupSeparator = this.getMenuComponent(n2);
        } else if (!bl && this.fGroupSeparator != null) {
            this.remove(this.fGroupSeparator);
            this.fGroupSeparator = null;
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object;
        int n;
        if (this.fLayoutMenu != null) {
            this.fLayoutMenu.setEnabled(this.fDesktop.getLayoutLibrary().layoutCount() > 0);
        }
        if (this.fOrganizeLayoutsAction != null) {
            this.fOrganizeLayoutsAction.setEnabled(this.fDesktop.getLayoutLibrary().userLayoutCount() > 0);
        }
        if (this.fToolBarMenu == null && !this.fToolBarItemsAdded) {
            DTSelectable dTSelectable;
            n = this.getFirstToolBarIndex();
            if (this.fFrame.isMainFrame() || this.fClient == null) {
                if (this.fFrame.isMainFrame() || this.fClient == null && this.fGroup != null && this.fGroup.offerToolBarToggles()) {
                    this.addToolBarToggles(this.fFrame.getToolBarContainer());
                }
                if (this.fFrame.isMainFrame() && this.fClient == null && ((dTSelectable = ((DTMultipleClientFrame)this.fFrame).getSelection()) instanceof DTGroup || dTSelectable instanceof DTDocuments) && ((DTOccupant)(object = (DTOccupant)dTSelectable)).offerToolBarToggles()) {
                    this.addToolBarToggles(((DTOccupant)object).getInternalFrame().getToolBarContainer());
                }
            }
            if (this.fClient != null && this.fClient.offerToolBarToggles()) {
                if (this.fFrame instanceof DTSingleClientFrame) {
                    this.addToolBarToggles(this.fClient.getInternalFrame().getToolBarContainer());
                } else {
                    dTSelectable = this.fClient.getGroup();
                    if (dTSelectable != null && ((DTGroup)dTSelectable).hasDocumentContainer()) {
                        this.addToolBarToggles(((DTGroup)dTSelectable).getInternalFrame().getToolBarContainer());
                    }
                    if (this.fFrame.isMainFrame() && this.fClient.getToolBars().length > 0) {
                        this.addToolBarToggles(this.fClient.getInternalFrame().getToolBarContainer());
                    }
                }
            }
            if (!this.fFrame.isMainFrame() && this.fToolBarItemCount > 0) {
                this.insertSeparator(n);
                ++this.fToolBarItemCount;
            }
            this.fToolBarItemsAdded = true;
        }
        n = this.fFrame.hasStatusBar() && !this.fFrame.isStatusBarVisible() ? 1 : 0;
        this.fStatusBarToggleItem.setVisible(n != 0);
        this.fStatusBarToggleItem.setEnabled(n != 0);
        int n2 = this.getMenuComponentCount();
        if (n2 > 0 && (object = this.getMenuComponent(n2 - 1)) instanceof JSeparator) {
            this.remove(n2 - 1);
        }
    }

    private void addToolBarToggles(DTToolBarContainer dTToolBarContainer) {
        if (dTToolBarContainer == null) {
            return;
        }
        List<Action> list = dTToolBarContainer.getToggleActions();
        int n = this.getFirstToolBarIndex() + this.fToolBarItemCount;
        int n2 = 0;
        while (n2 < list.size()) {
            ChildAction childAction = new ChildAction(list.get(n2));
            childAction.setName(dTToolBarContainer.addTheWordToolBar(childAction.getName()));
            MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem((Action)childAction);
            this.add((Component)mJCheckBoxMenuItem, n);
            ++n;
            ++n2;
            ++this.fToolBarItemCount;
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    class ToolBarMenu
    extends MJMenu
    implements MenuListener {
        ToolBarMenu() {
            super(DTDesktopMenu.this.fDesktop.getString("menu.ToolBars"));
            this.addMenuListener(this);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.getMenuComponentCount() == 0) {
                Object object;
                if (DTDesktopMenu.this.fFrame.isMainFrame() || DTDesktopMenu.this.fClient == null) {
                    DTOccupant dTOccupant;
                    this.addToolBarToggles(DTDesktopMenu.this.fFrame.getToolBarContainer());
                    if (DTDesktopMenu.this.fFrame.isMainFrame() && DTDesktopMenu.this.fClient == null && ((object = ((DTMultipleClientFrame)DTDesktopMenu.this.fFrame).getSelection()) instanceof DTGroup || object instanceof DTDocuments) && (dTOccupant = (DTOccupant)object).offerToolBarToggles()) {
                        this.addToolBarToggles(dTOccupant.getInternalFrame().getToolBarContainer());
                    }
                }
                if (DTDesktopMenu.this.fClient != null && DTDesktopMenu.this.fClient.offerToolBarToggles()) {
                    if (DTDesktopMenu.this.fFrame instanceof DTSingleClientFrame) {
                        this.addToolBarToggles(DTDesktopMenu.this.fClient.getInternalFrame().getToolBarContainer());
                    } else {
                        object = DTDesktopMenu.this.fClient.getGroup();
                        if (object != null && ((DTGroup)object).hasDocumentContainer()) {
                            this.addToolBarToggles(((DTGroup)object).getInternalFrame().getToolBarContainer());
                        }
                        if (DTDesktopMenu.this.fFrame.isMainFrame() && DTDesktopMenu.this.fClient.getToolBars().length > 0) {
                            this.addToolBarToggles(DTDesktopMenu.this.fClient.getInternalFrame().getToolBarContainer());
                        }
                    }
                }
                if (this.getMenuComponentCount() > 0) {
                    this.addSeparator();
                }
                object = new MJMenuItem(DTDesktopMenu.this.fDesktop.getString("menuitem.Customize"));
                object.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DTDesktopMenu.this.fFrame.getDesktop().showToolBarCustomizationPanel(null);
                    }
                });
                this.add((JMenuItem)object);
            }
        }

        private void addToolBarToggles(DTToolBarContainer dTToolBarContainer) {
            if (dTToolBarContainer == null) {
                return;
            }
            for (Action action : dTToolBarContainer.getToggleActions()) {
                MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(action);
                this.add((JMenuItem)mJCheckBoxMenuItem);
            }
        }

        private void clear() {
            this.dispose();
            this.removeAll();
            if (!Arrays.asList(this.getMenuListeners()).contains(this)) {
                this.addMenuListener(this);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }

    private class ToggleItem
    extends MJCheckBoxMenuItem {
        boolean iIsGroupItem;

        ToggleItem(DTClient dTClient) {
            this(dTClient, false);
        }

        ToggleItem(DTClient dTClient, boolean bl) {
            super((Action)dTClient.getToggleAction());
            if (bl) {
                this.setText("   " + this.getText());
            }
            this.setVisible(dTClient.getToggleAction().isEnabled());
        }

        ToggleItem(DTGroup dTGroup) {
            super((Action)dTGroup.getToggleAction());
            this.iIsGroupItem = true;
            this.setVisible(dTGroup.getToggleAction().isEnabled());
        }

        public void setEnabled(boolean bl) {
            if ("true".equals(this.getClientProperty("disposed_button"))) {
                return;
            }
            if (bl != this.isEnabled()) {
                super.setEnabled(bl);
                this.setVisible(bl);
                if (this.iIsGroupItem) {
                    DTDesktopMenu.this.updateGroupSeparator();
                }
            }
        }
    }

    private class GroupListListener
    implements DTNotifyingList.Listener<DTGroup> {
        private GroupListListener() {
        }

        @Override
        public void objectAdded(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n) {
            DTNotifyingList<DTGroup> dTNotifyingList2 = DTDesktopMenu.this.fDesktop.getNotifyingGroups();
            int n2 = 0;
            int n3 = dTNotifyingList2.size();
            for (int i = 0; i < n3; ++i) {
                DTGroup dTGroup2 = (DTGroup)dTNotifyingList2.get(i);
                if (dTGroup2 == dTGroup) continue;
                n2 += dTGroup2.getSingletons().size() + 1;
            }
            DTDesktopMenu.this.add((Component)((Object)new ToggleItem(dTGroup)), DTDesktopMenu.this.getFirstGroupIndex() + n2);
            DTDesktopMenu.this.fGroupItemCount++;
            DTDesktopMenu.this.updateGroupSeparator();
        }

        @Override
        public void objectRemoved(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n) {
            int n2 = DTDesktopMenu.this.getGroupIndex(dTGroup);
            JMenuItem jMenuItem = (JMenuItem)DTDesktopMenu.this.getMenuComponent(n2);
            DTDesktopMenu.this.remove(n2);
            DTDesktopMenu.this.fGroupItemCount--;
            MJUtilities.dispose((AbstractButton)jMenuItem);
            DTDesktopMenu.this.updateGroupSeparator();
        }

        @Override
        public void objectMoved(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n, int n2) {
            int n3;
            Component[] componentArray = new Component[dTGroup.getSingletons().size()];
            int n4 = DTDesktopMenu.this.getGroupIndex(dTGroup) + 1;
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                componentArray[n3] = DTDesktopMenu.this.getMenuComponent(n4);
                DTDesktopMenu.this.remove(n4);
            }
            this.objectRemoved(dTNotifyingList, dTGroup, n);
            this.objectAdded(dTNotifyingList, dTGroup, n2);
            n4 = DTDesktopMenu.this.getGroupIndex(dTGroup) + 1;
            n3 = 0;
            while (n3 < componentArray.length) {
                DTDesktopMenu.this.add(componentArray[n3], n4);
                ++n3;
                ++n4;
            }
        }

        @Override
        public void objectsReordered(DTNotifyingList dTNotifyingList) {
        }
    }

    private class SingletonListListener
    implements DTNotifyingList.Listener<DTClient> {
        private SingletonListListener() {
        }

        @Override
        public void objectAdded(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
            if (dTClient.getGroup() == DTDesktopMenu.this.fGroup) {
                DTDesktopMenu.this.add((Component)((Object)new ToggleItem(dTClient)), DTDesktopMenu.this.getFirstSingletonIndex() + n);
                DTDesktopMenu.this.fSingletonItemCount++;
                if (DTDesktopMenu.this.fSingletonItemCount == 1) {
                    DTDesktopMenu.this.insertSeparator(DTDesktopMenu.this.getFirstSingletonIndex() + (DTDesktopMenu.this.fGroup != null ? 0 : 1));
                }
            } else {
                int n2 = DTDesktopMenu.this.getGroupIndex(dTClient.getGroup());
                if (n2 == -1) {
                    return;
                }
                int n3 = dTClient.getGroup().getSingletons().indexOf(dTClient);
                if (n3 == -1) {
                    return;
                }
                DTDesktopMenu.this.add((Component)((Object)new ToggleItem(dTClient, true)), n2 + n3 + 1);
                DTDesktopMenu.this.fGroupSingletonItemCount++;
            }
        }

        @Override
        public void objectRemoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
            if (dTClient.getGroup() == DTDesktopMenu.this.fGroup) {
                int n2 = DTDesktopMenu.this.getFirstSingletonIndex();
                boolean bl = DTDesktopMenu.this.getMenuComponent(n2) instanceof JSeparator;
                if (DTDesktopMenu.this.fGroup != null && bl) {
                    ++n2;
                }
                int n3 = n2 + n;
                JMenuItem jMenuItem = (JMenuItem)DTDesktopMenu.this.getMenuComponent(n3);
                DTDesktopMenu.this.remove(n3);
                DTDesktopMenu.this.fSingletonItemCount--;
                MJUtilities.dispose((AbstractButton)jMenuItem);
                if (DTDesktopMenu.this.fSingletonItemCount == 0 && (bl || DTDesktopMenu.this.fGroup == null)) {
                    DTDesktopMenu.this.remove(n2);
                }
            } else {
                int n4 = DTDesktopMenu.this.getGroupIndex(dTClient.getGroup());
                if (n4 == -1) {
                    return;
                }
                int n5 = dTClient.getGroup().getSingletons().indexOf(dTClient);
                if (n5 == -1) {
                    return;
                }
                int n6 = n4 + n5 + 1;
                JMenuItem jMenuItem = (JMenuItem)DTDesktopMenu.this.getMenuComponent(n6);
                DTDesktopMenu.this.remove(n6);
                DTDesktopMenu.this.fGroupSingletonItemCount--;
                MJUtilities.dispose((AbstractButton)jMenuItem);
            }
        }

        @Override
        public void objectMoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n, int n2) {
            if (dTClient.getGroup() == DTDesktopMenu.this.fGroup) {
                n += DTDesktopMenu.this.getFirstSingletonIndex();
                n2 += DTDesktopMenu.this.getFirstSingletonIndex();
            } else {
                n += DTDesktopMenu.this.getGroupIndex(dTClient.getGroup());
                n2 += DTDesktopMenu.this.getGroupIndex(dTClient.getGroup());
            }
            Component component = DTDesktopMenu.this.getMenuComponent(n);
            DTDesktopMenu.this.remove(n);
            DTDesktopMenu.this.add(component, n2);
        }

        @Override
        public void objectsReordered(DTNotifyingList dTNotifyingList) {
        }
    }
}

