/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.datamodel;

import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.BackingStoreEventListener;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class AbstractBackingStore<T>
implements BackingStore<T> {
    public static final String BACKING_DATA = "backingData";
    public static final Object BACKING_DATA_EMPTY_VALUE = "";
    private List<BackingStoreEventListener<T>> fEventListeners = new Vector<BackingStoreEventListener<T>>();
    private PropertyChangeSupport fPropertyChangeSupport;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(AbstractBackingStore.class.getPackage().getName() + ".resources.RES_backingstore");

    protected void checkPersistenceLocationSet() {
        this.checkPersistenceLocationSet(RESOURCE_BUNDLE.getString("AbstractBackingStore.PersistenceLocationNotSet.Error"));
    }

    protected void checkPersistenceLocationSet(String string) {
        if (!this.isPersistenceLocationSet()) {
            throw new IllegalStateException(string);
        }
    }

    public final void load(T t) throws Exception {
        this.checkPersistenceLocationSet(RESOURCE_BUNDLE.getString("AbstractBackingStore.PersistenceLocationLoad.Error"));
        this.doLoad(t);
        this.fireBackingStoreLoaded();
    }

    public final boolean negotiateSave(T t, Component component) throws Exception {
        return this.notifyListenersIfSaved(this.doNegotiateSave(t, component));
    }

    public final void save(T t) throws Exception {
        this.notifyListenersIfSaved(this.doSave(t));
    }

    public final boolean negotiateSaveAs(T t, Component component) throws Exception {
        return this.notifyListenersIfSaved(this.doNegotiateSaveAs(t, component));
    }

    public boolean shouldSaveOnClose(T t) {
        return true;
    }

    protected boolean notifyListenersIfSaved(boolean bl) {
        if (bl) {
            this.fireBackingStoreSaved();
        }
        return bl;
    }

    public void negotiateBackup(T t, Component component) throws Exception {
        if (this.doNegotiateBackup(t, component).shouldSaveEventBeFired()) {
            this.fireBackingStoreSaved();
        }
    }

    protected abstract void doLoad(T var1) throws Exception;

    protected abstract boolean doNegotiateSave(T var1, Component var2) throws Exception;

    protected abstract boolean doSave(T var1) throws Exception;

    protected abstract boolean doNegotiateSaveAs(T var1, Component var2) throws Exception;

    protected abstract BackupResult doNegotiateBackup(T var1, Component var2) throws Exception;

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.fPropertyChangeSupport == null) {
            this.fPropertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.fPropertyChangeSupport;
    }

    private void fireBackingStoreSaved() {
        for (BackingStoreEventListener<T> backingStoreEventListener : this.fEventListeners) {
            backingStoreEventListener.backingStoreSaved((BackingStore)this);
        }
    }

    private void fireBackingStoreLoaded() {
        for (BackingStoreEventListener<T> backingStoreEventListener : this.fEventListeners) {
            backingStoreEventListener.backingStoreLoaded((BackingStore)this);
        }
    }

    public final void addBackingStoreEventListener(BackingStoreEventListener<T> backingStoreEventListener) {
        this.fEventListeners.add(backingStoreEventListener);
    }

    public final void removeBackingStoreEventListener(BackingStoreEventListener<T> backingStoreEventListener) {
        this.fEventListeners.remove(backingStoreEventListener);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    public static interface UserInteractionModel {
        public boolean areDialogsAllowed();

        public void communicateError(String var1, String var2);
    }

    protected static enum BackupResult {
        SAVED_TO_EXISTING_LOCATION(true),
        SAVED_TO_NEW_LOCATION,
        CANCELED;

        private final boolean fFireEvent;

        private BackupResult() {
            this(false);
        }

        private BackupResult(boolean bl) {
            this.fFireEvent = bl;
        }

        private boolean shouldSaveEventBeFired() {
            return this.fFireEvent;
        }
    }
}

