/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.color;

import com.mathworks.common.icons.IconContainer;
import com.mathworks.widgets.color.ColorPicker;
import java.awt.Color;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public final class ColorPickerUtils {
    private static final String IMAGE_PATH = "/com/mathworks/widgets/color/resources/";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.color.resources.RES_ColorPicker");

    private ColorPickerUtils() {
    }

    public static ResourceBundle getBundle() {
        return BUNDLE;
    }

    public static String createToolTipText(Color color) {
        for (String string : ColorPicker.BUILTIN_COLORS.keySet()) {
            if (!color.equals(ColorPicker.BUILTIN_COLORS.get(string))) continue;
            return string;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format((float)color.getRed() / 255.0f) + ", " + numberFormat.format((float)color.getGreen() / 255.0f) + ", " + numberFormat.format((float)color.getBlue() / 255.0f);
    }

    public static String colorToActionCommand(Color color) {
        return String.valueOf(color.getRed()) + "," + String.valueOf(color.getBlue()) + "," + String.valueOf(color.getGreen());
    }

    public static Color colorForActionCommand(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        return new Color(n, n3, n2);
    }

    public static enum Icon implements IconContainer
    {
        FILL("colorpicker-fill"),
        FILL_DISABLED("colorpicker-fill-disabled"),
        LINE("colorpicker-line"),
        LINE_DISABLED("colorpicker-line-disabled"),
        TEXT("colorpicker-text"),
        TEXT_DISABLED("colorpicker-text-disabled");

        private final String fName;

        private Icon(String string2) {
            this.fName = string2;
        }

        public ImageIcon getIcon() {
            return new ImageIcon(this.makeImageURL(this.fName + ".gif"));
        }

        private URL makeImageURL(String string) {
            return ((Object)((Object)this)).getClass().getResource(ColorPickerUtils.IMAGE_PATH + string);
        }
    }
}

