/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJGrip;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTTitleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class LightweightWindow {
    private static final int BORDER_WIDTH = 2;
    private final DTTitleButton fCloseButton;
    private final MJDialog fDialog;
    private final WindowAdapter fWindowListener;
    private ActionListener fDisposer;

    public LightweightWindow(Frame frame, String string, Component component, MJStatusBar mJStatusBar) {
        this(frame, string, component, mJStatusBar, true);
    }

    public LightweightWindow(Frame frame, String string, Component component, MJStatusBar mJStatusBar, boolean bl) {
        if (frame == null) {
            throw new IllegalArgumentException("'parent' cannot be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("'contents' cannot be null");
        }
        this.fCloseButton = new DTTitleButton(7);
        this.fCloseButton.setName("CloseButton");
        this.fDialog = new MJDialog(frame, string, false);
        this.fDialog.setDefaultCloseOperation(2);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        if (PlatformInfo.isMacintosh()) {
            this.fDialog.getRootPane().putClientProperty("Window.style", "small");
        } else {
            this.fDialog.setUndecorated(true);
            mJPanel.add(this.buildGripBar(), "North");
        }
        mJPanel.add(component, "Center");
        if (bl && mJStatusBar == null) {
            mJStatusBar = new MJStatusBar();
        }
        if (mJStatusBar != null) {
            mJPanel.add((Component)LightweightWindow.augmentStatusBar(mJStatusBar), "South");
        }
        this.fDialog.setContentPane((Container)mJPanel);
        this.updateBorder(false);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                LightweightWindow.this.updateBorder(true);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                LightweightWindow.this.updateBorder(false);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                LightweightWindow.this.cleanup();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LightweightWindow.this.cleanup();
            }
        };
        this.fDialog.addWindowListener((WindowListener)this.fWindowListener);
    }

    private void updateBorder(boolean bl) {
        if (!PlatformInfo.isMacintosh()) {
            ((JComponent)this.fDialog.getContentPane()).setBorder(BorderFactory.createLineBorder(LightweightWindow.getPopupSelectionColor(), 2));
            this.fCloseButton.setActive(bl);
        }
    }

    public JDialog getWindow() {
        return this.fDialog;
    }

    private Component buildGripBar() {
        MJGrip mJGrip = new MJGrip(0);
        mJGrip.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        mJGrip.setComponentToMove((Component)this.fDialog);
        mJGrip.setShouldDrawGradient(true);
        mJGrip.setShouldDrawGripper(false);
        this.fDisposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LightweightWindow.this.cleanup();
            }
        };
        this.fCloseButton.addActionListener(this.fDisposer);
        MJPanel mJPanel = new MJPanel();
        FormLayout formLayout = new FormLayout("d:grow", "d");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        panelBuilder.add((Component)((Object)this.fCloseButton), cellConstraints.xy(1, 1, "right, center"));
        panelBuilder.add((Component)mJGrip, cellConstraints.xy(1, 1, "fill, fill"));
        return mJPanel;
    }

    private void cleanup() {
        this.fCloseButton.removeActionListener(this.fDisposer);
        this.fDialog.removeWindowListener((WindowListener)this.fWindowListener);
        this.fDialog.dispose();
    }

    private static MJStatusBar augmentStatusBar(MJStatusBar mJStatusBar) {
        assert (mJStatusBar != null);
        if (PlatformInfo.isMacintosh()) {
            mJStatusBar.add(Box.createHorizontalStrut(16));
        } else {
            MJCornerGrip mJCornerGrip = MJCornerGrip.createAlwaysVisibleCornerGrip();
            mJCornerGrip.setEnforceMinimumSize(true);
            mJStatusBar.add((Component)mJCornerGrip);
        }
        return mJStatusBar;
    }

    private static Color getPopupSelectionColor() {
        return UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    private static Color getPopupNonselectionColor() {
        return PlatformInfo.getWindowsColorScheme() == 2 ? UIManager.getColor("InternalFrame.inactiveBorderColor") : UIManager.getColor("InternalFrame.inactiveTitleBackground");
    }
}

