/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;

public class LightButton
extends MJButton {
    private static final Color ENABLED_BORDER_COLOR = new Color(0, 0, 0, 150);
    private static final Color DISABLED_BORDER_COLOR = new Color(100, 100, 100, 150);

    public LightButton() {
        this.initializeButton();
    }

    public LightButton(Action action) {
        super(action);
        this.initializeButton();
    }

    public LightButton(Icon icon) {
        super(icon);
        this.initializeButton();
    }

    public LightButton(String string) {
        super(string);
        this.initializeButton();
    }

    public LightButton(String string, Icon icon) {
        super(string, icon);
        this.initializeButton();
    }

    private void initializeButton() {
        float f = this.getScale();
        int n = (int)(f * 0.04f);
        this.setMargin(new Insets(n, n, n, n));
        this.setOpaque(false);
    }

    private boolean hasIcon() {
        return this.getIcon() != null;
    }

    private IntegerRoundRect getButtonShape() {
        Dimension dimension = this.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = (int)Math.floor((float)this.getFont().getSize() * 0.6f);
        return new IntegerRoundRect(0, 0, n, n2, n3, n3);
    }

    protected void paintBorder(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.isEnabled() ? ENABLED_BORDER_COLOR : DISABLED_BORDER_COLOR);
        this.getButtonShape().drawBorder(graphics2D);
    }

    private Dimension getTextSize(Graphics graphics) {
        String string = this.getText();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        int n = (int)rectangle2D.getWidth();
        LineMetrics lineMetrics = graphics.getFontMetrics().getLineMetrics(string, graphics);
        int n2 = (int)(lineMetrics.getAscent() - lineMetrics.getDescent());
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        float f = this.getScale();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        fontMetrics.stringWidth(this.getText());
        int n = (int)(f * 0.7f);
        int n2 = fontMetrics.stringWidth(this.getText()) + n;
        n2 -= (n2 - 1) % 2;
        int n3 = (int)(f * 0.008f);
        int n4 = fontMetrics.getHeight() + n3;
        n4 -= (n4 - 1) % 2;
        if (this.hasIcon()) {
            n2 += this.getIcon().getIconWidth();
        }
        return new Dimension(n2, n4);
    }

    private float getScale() {
        return 1.6666666f * this.getFont().getSize2D();
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Serializable serializable;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ButtonModel buttonModel = this.getModel();
        boolean bl = buttonModel.isPressed();
        Color color = UIManager.getColor("ToolTip.background");
        Dimension dimension = this.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (bl) {
            color2 = color.darker();
            color3 = color.brighter();
        }
        if (!this.isEnabled()) {
            double d = 0.8;
            color2 = color3 = (serializable = new Color(Math.max((int)((double)color.getRed() * d), 0), Math.max((int)((double)color.getGreen() * d), 0), Math.max((int)((double)color.getBlue() * d), 0)));
        }
        GradientPaint gradientPaint = new GradientPaint(new Point(0, 0), color2, new Point(0, n2), color3);
        graphics2D.setPaint(gradientPaint);
        this.getButtonShape().fill(graphics2D);
        String string = this.getText();
        serializable = this.getTextSize(graphics2D);
        int n3 = ((Dimension)serializable).width;
        int n4 = ((Dimension)serializable).height;
        int n5 = (n - n3) / 2 + 1;
        int n6 = (n2 + n4) / 2;
        if (this.hasIcon()) {
            object = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
            object.paintIcon((Component)((Object)this), graphics2D, (n5 -= this.getIcon().getIconWidth() / 2) + n3, Math.max(0, n2 / 2 - this.getIcon().getIconHeight() / 2));
        }
        object = UIManager.getColor("Button.disabledForeground") != null ? UIManager.getColor("Button.disabledForeground") : DISABLED_BORDER_COLOR;
        graphics2D.setColor((Color)(this.isEnabled() ? UIManager.getColor("Button.foreground") : object));
        graphics2D.drawString(string, n5, n6);
        graphics2D.dispose();
    }

    private static class IntegerRoundRect {
        private int fArchHeight;
        private int fArcWidth;
        private int fHeight;
        private int fWidth;
        private int fY;
        private int fX;

        private IntegerRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            this.fX = n;
            this.fY = n2;
            this.fWidth = n3;
            this.fHeight = n4;
            this.fArcWidth = n5;
            this.fArchHeight = n6;
        }

        public void drawBorder(Graphics2D graphics2D) {
            graphics2D.drawRoundRect(this.fX, this.fY, this.fWidth - 1, this.fHeight - 1, this.fArcWidth, this.fArchHeight);
        }

        public void fill(Graphics2D graphics2D) {
            graphics2D.fillRoundRect(this.fX, this.fY, this.fWidth, this.fHeight, this.fArcWidth, this.fArchHeight);
        }
    }
}

