/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.emu.MonitorConnectionBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class ConnectionBuffer {
    private final String portID;
    protected final long remoteAddress;
    protected int securityOpt;
    protected final InputStream is;
    protected final OutputStream os;
    protected boolean closed;
    protected ConnectionBuffer connected;
    protected boolean serverSide;
    protected boolean serverAccepted;
    protected MonitorConnectionBuffer monitor;

    protected ConnectionBuffer(long remoteAddress, String portID, InputStream is, OutputStream os) {
        this.remoteAddress = remoteAddress;
        this.portID = portID;
        this.is = is;
        this.os = os;
    }

    void connect(ConnectionBuffer pair) {
        this.connected = pair;
        pair.connected = this;
    }

    synchronized void accepted() {
        this.serverAccepted = true;
        this.notifyAll();
    }

    boolean isServerAccepted() {
        return this.serverAccepted;
    }

    long getRemoteAddress() {
        return this.remoteAddress;
    }

    void setSecurityOpt(int securityOpt) {
        this.securityOpt = securityOpt;
    }

    int getSecurityOpt(int expected) throws IOException {
        return this.securityOpt;
    }

    boolean encrypt(long remoteAddress, boolean on) throws IOException {
        if (this.remoteAddress != remoteAddress) {
            throw new IllegalArgumentException("Connection not to this device");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() throws IOException {
        this.closed = true;
        this.monitor.closedTimeStamp = System.currentTimeMillis();
        try {
            this.os.close();
        }
        finally {
            this.is.close();
        }
        this.notifyAll();
    }

    boolean isServerSide() {
        return this.serverSide;
    }

    void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    void setMonitor(MonitorConnectionBuffer monitor) {
        this.monitor = monitor;
    }

    boolean isClosed() {
        return this.closed;
    }

    public String getPortID() {
        return this.portID;
    }
}

