/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import java.awt.Point;

public class LayoutClipboard {
    private static LayoutClipboard sClipboard;
    private Object fBufferFigure;
    private Object[] fClipboardContent;
    private boolean[] fSourceEnclosable;
    private LOControlWrapper fPasteParent;
    private Point fPasteLocation = new Point(0, 0);
    private int fPasteCount = 0;

    private LayoutClipboard() {
    }

    public static LayoutClipboard getClipboard() {
        if (sClipboard == null) {
            sClipboard = new LayoutClipboard();
        }
        return sClipboard;
    }

    public boolean canPaste(LayoutArea layoutArea) {
        return this.fBufferFigure != null && this.fClipboardContent != null;
    }

    public void clearClipboard() {
        this.fSourceEnclosable = new boolean[0];
        this.fClipboardContent = null;
    }

    Object getBufferFigure() {
        return this.fBufferFigure;
    }

    private void resetPasteCount() {
        this.fPasteCount = 0;
    }

    private int getPasteStepSize() {
        return 10;
    }

    private int getPasteOffset() {
        return this.getPasteStepSize() * (this.fPasteCount + 1);
    }

    void updatePasteLocation(Point point) {
        this.setPasteLocation(new Point(point.x - this.getPasteStepSize(), point.y - this.getPasteStepSize()));
    }

    private void setPasteLocation(Point point) {
        if (!this.fPasteLocation.equals(point)) {
            this.resetPasteCount();
            if (point != null) {
                this.fPasteLocation = point;
            } else {
                this.fPasteLocation.setLocation(0, 0);
            }
        }
    }

    public void copy(LayoutArea layoutArea, Object object) {
        this.clearClipboard();
        Point point = new Point(0, 0);
        Object[] objectArray = (Object[])object;
        if (objectArray != null && objectArray.length > 0) {
            this.fSourceEnclosable = new boolean[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)objectArray[i];
                this.fSourceEnclosable[i] = lOControlWrapper.isEnclosable();
                if (i == 0) {
                    this.fPasteParent = lOControlWrapper.getParent();
                    point = lOControlWrapper.getControl().getLocation();
                }
                if (point.x > lOControlWrapper.getControl().getLocation().x) {
                    point.x = lOControlWrapper.getControl().getLocation().x;
                }
                if (point.y <= lOControlWrapper.getControl().getLocation().y) continue;
                point.y = lOControlWrapper.getControl().getLocation().y;
            }
            if (this.fPasteParent != null) {
                this.fPasteParent.translateToBaseCoordinates(point);
            }
            LayoutLooper.copy(objectArray, new CopyCompleted(layoutArea));
        }
        this.setPasteLocation(point);
    }

    public void paste(LayoutArea layoutArea) {
        if (this.canPaste(layoutArea)) {
            LOControlWrapper lOControlWrapper = layoutArea.findControl(this.fPasteLocation);
            boolean bl = false;
            block0: while (lOControlWrapper != null && !bl) {
                if (lOControlWrapper.isEnclosure()) {
                    bl = true;
                    for (Object object : (Object)this.fSourceEnclosable) {
                        if (object != false) continue;
                        lOControlWrapper = lOControlWrapper.getParent();
                        bl = false;
                        continue block0;
                    }
                    continue;
                }
                lOControlWrapper = lOControlWrapper.getParent();
            }
            this.fPasteParent = lOControlWrapper;
            Object object = layoutArea.getRootObject();
            Point point = new Point(this.fPasteLocation);
            if (this.fPasteParent != null) {
                object = this.fPasteParent.getBean();
                this.fPasteParent.translateFromBaseCoordinates(point);
            }
            int[] nArray = new int[]{point.x += this.getPasteOffset(), point.y += this.getPasteOffset()};
            LayoutLooper.paste(this.fClipboardContent, object, nArray, new PasteCompleted(layoutArea));
            ++this.fPasteCount;
        }
    }

    static /* synthetic */ Object[] access$002(LayoutClipboard layoutClipboard, Object[] objectArray) {
        layoutClipboard.fClipboardContent = objectArray;
        return objectArray;
    }

    private class PasteCompleted
    implements CompletionObserver {
        private LayoutArea fLayout;

        PasteCompleted(LayoutArea layoutArea) {
            this.fLayout = layoutArea;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fLayout.duplicateComplete(object);
            }
        }
    }

    private class CopyCompleted
    implements CompletionObserver {
        private LayoutArea fLayoutArea;

        CopyCompleted(LayoutArea layoutArea) {
            this.fLayoutArea = layoutArea;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                LayoutClipboard.access$002(LayoutClipboard.this, (Object[])objectArray[0]);
                LayoutClipboard.this.fBufferFigure = objectArray[1];
                if (this.fLayoutArea != null) {
                    this.fLayoutArea.updatePasteCmd();
                }
            } else {
                LayoutClipboard.this.clearClipboard();
            }
        }
    }
}

