/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.shared.computils.threads.CountingThreadFactory;
import com.mathworks.toolbox.shared.computils.threads.WrappingExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class ComparisonsExecutor {
    private static final String THREAD_NAME = "Comparisons Thread";
    private static final ThreadPoolExecutor INNER_EXECUTOR = ComparisonsExecutor.createInnerExecutor();
    private static final WrappingExecutorService EXECUTOR = ComparisonsExecutor.createExecutor();

    private ComparisonsExecutor() {
    }

    public static WrappingExecutorService getInstance() {
        return EXECUTOR;
    }

    public static int getNumActiveThreads() {
        return INNER_EXECUTOR.getActiveCount();
    }

    private static ThreadPoolExecutor createInnerExecutor() {
        return (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)new CountingThreadFactory(THREAD_NAME));
    }

    private static WrappingExecutorService createExecutor() {
        final WrappingExecutorService wrappingExecutorService = new WrappingExecutorService((ExecutorService)INNER_EXECUTOR);
        if (Matlab.isMatlabAvailable()) {
            Matlab.registerQuitListener((Runnable)new Runnable(){

                @Override
                public void run() {
                    wrappingExecutorService.shutdown();
                }
            });
        }
        return wrappingExecutorService;
    }
}

