/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.register.impl;

import com.mathworks.comparisons.register.ComparisonDataType;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeComparator;
import com.mathworks.comparisons.register.ComparisonTypeDeterminant;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.register.datatype.CDataTypeBinary;
import com.mathworks.comparisons.register.datatype.CDataTypeList;
import com.mathworks.comparisons.register.determinant.CTypeDeterminantCSTypeFile;
import com.mathworks.comparisons.register.impl.ComparisonTypeComparatorImpl;
import com.mathworks.comparisons.register.impl.ComparisonTypeListWrapper;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ComparisonTypeRegisterImpl
implements ComparisonTypeRegister {
    private final String fDefaultFileComparisonDataTypeName;
    private final String fDefaultListComparisonDataTypeName;
    private final ComparisonTypeComparator fComparisonTypeComparator;
    private final Set<ComparisonTypeDeterminant> fComparisonTypeDeterminantRegister;
    private final SortedSet<ComparisonType> fComparisonTypeRegister;
    private final Map<String, ComparisonType> fDataTypeNameToComparisonType;

    public static ComparisonTypeRegister createNewRegister() {
        return new ComparisonTypeRegisterImpl(CDataTypeBinary.getInstance(), CDataTypeList.getInstance(), new ComparisonTypeComparatorImpl());
    }

    public ComparisonTypeRegisterImpl(ComparisonDataType comparisonDataType, ComparisonDataType comparisonDataType2, ComparisonTypeComparator comparisonTypeComparator) {
        CheckNullArgument.check(comparisonDataType, "aDefaultFileComparisonDataType");
        CheckNullArgument.check(comparisonDataType2, "aDefaultListComparisonDataType");
        CheckNullArgument.check(comparisonTypeComparator, "aComparator");
        this.fDefaultFileComparisonDataTypeName = comparisonDataType.getName();
        this.fDefaultListComparisonDataTypeName = comparisonDataType2.getName();
        this.fComparisonTypeComparator = comparisonTypeComparator;
        this.fComparisonTypeDeterminantRegister = new HashSet<ComparisonTypeDeterminant>();
        this.fComparisonTypeRegister = new TreeSet<ComparisonType>(this.fComparisonTypeComparator);
        this.fDataTypeNameToComparisonType = new HashMap<String, ComparisonType>();
    }

    @Override
    public synchronized void register(ComparisonType comparisonType) {
        String string = comparisonType.getDataType().getName();
        if (this.fDataTypeNameToComparisonType.containsKey(string)) {
            throw new RuntimeException(ResourceManager.format("exception.toomanycomparisontypes", string));
        }
        this.fDataTypeNameToComparisonType.put(string, comparisonType);
        this.fComparisonTypeRegister.add(comparisonType);
        this.fComparisonTypeDeterminantRegister.addAll(comparisonType.getDeterminants());
    }

    @Override
    public Collection<String> getDataTypeNames() {
        return Collections.unmodifiableCollection(this.fDataTypeNameToComparisonType.keySet());
    }

    @Override
    public boolean hasDataTypeName(String string) {
        return this.fDataTypeNameToComparisonType.containsKey(string);
    }

    @Override
    public String getDescriptionByDataTypeName(String string) {
        if (this.hasDataTypeName(string)) {
            return this.fDataTypeNameToComparisonType.get(string).getDescription();
        }
        throw new UnsupportedOperationException(ResourceManager.format("exception.unknowndatatype", string));
    }

    @Override
    public ComparisonType getByDataTypeName(String string, ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        ComparisonType comparisonType = null;
        if (this.fDataTypeNameToComparisonType.containsKey(string)) {
            List<ComparisonType> list = this.getCompatibleComparisonTypes(comparisonSource, comparisonSource2, set);
            for (ComparisonType comparisonType2 : list) {
                if (!comparisonType2.getDataType().getName().equals(string)) continue;
                comparisonType = comparisonType2;
            }
            if (comparisonType == null) {
                throw new UnsupportedOperationException(ResourceManager.format("exception.unsuitabledatatype", string));
            }
        } else {
            throw new UnsupportedOperationException(ResourceManager.format("exception.unknowndatatype", string));
        }
        return comparisonType;
    }

    @Override
    public ComparisonType getMostSuitableComparisonType(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        List<ComparisonType> list = this.getCompatibleComparisonTypes(comparisonSource, comparisonSource2, set);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ComparisonType> getCompatibleComparisonTypes(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Set<ComparisonTypeFeature> set) {
        CheckNullArgument.check(comparisonSource, "aSource1");
        ArrayList<ComparisonType> arrayList = new ArrayList<ComparisonType>();
        SortedSet<ComparisonType> sortedSet = this.getAllowedComparisonTypes(comparisonSource);
        if (comparisonSource2 == null) {
            arrayList.addAll(sortedSet);
        } else {
            SortedSet<ComparisonType> sortedSet2 = this.getAllowedComparisonTypes(comparisonSource2);
            boolean bl = false;
            for (ComparisonType comparisonType : sortedSet) {
                if (sortedSet2.contains(comparisonType)) {
                    arrayList.add(comparisonType);
                    continue;
                }
                if (bl || !comparisonType.hasFeature(ComparisonTypeFeature.ISLISTCOMPARISON)) continue;
                bl = true;
                ComparisonType comparisonType2 = ComparisonTypeRegisterImpl.getFirstListComparison(sortedSet2);
                if (comparisonType2 == null) continue;
                assert (this.fDataTypeNameToComparisonType.containsKey(this.fDefaultListComparisonDataTypeName));
                ComparisonTypeListWrapper comparisonTypeListWrapper = new ComparisonTypeListWrapper(comparisonSource, comparisonType, comparisonSource2, comparisonType2, this.fDataTypeNameToComparisonType.get(this.fDefaultListComparisonDataTypeName));
                arrayList.add(comparisonTypeListWrapper);
            }
        }
        ComparisonTypeRegisterImpl.removeDuplicateModelType(arrayList);
        return ComparisonTypeRegisterImpl.applyRequiredFeatures(arrayList, set);
    }

    private static void removeDuplicateModelType(Collection<ComparisonType> collection) {
        boolean bl = false;
        boolean bl2 = false;
        ComparisonType comparisonType = null;
        for (ComparisonType comparisonType2 : collection) {
            String string = comparisonType2.getDataType().getName();
            if ("MDL".equals(string)) {
                bl = true;
                continue;
            }
            if (!"SLX".equals(string)) continue;
            bl2 = true;
            comparisonType = comparisonType2;
        }
        if (bl && bl2) {
            collection.remove(comparisonType);
        }
    }

    private SortedSet<ComparisonType> getAllowedComparisonTypes(ComparisonSource comparisonSource) {
        assert (comparisonSource != null);
        TreeSet<ComparisonType> treeSet = new TreeSet<ComparisonType>(this.fComparisonTypeComparator);
        Map<ComparisonTypeDeterminant, Object> map = this.getDeterminantValues(comparisonSource);
        for (ComparisonType comparisonType : this.fComparisonTypeRegister) {
            if (!comparisonType.checkDeterminantValues(map)) continue;
            treeSet.add(comparisonType);
        }
        if (treeSet.isEmpty() && ((Boolean)CTypeDeterminantCSTypeFile.getInstance().getValue(comparisonSource)).booleanValue()) {
            assert (this.fDataTypeNameToComparisonType.containsKey(this.fDefaultFileComparisonDataTypeName));
            ComparisonType comparisonType = this.fDataTypeNameToComparisonType.get(this.fDefaultFileComparisonDataTypeName);
            treeSet.add(comparisonType);
        }
        return this.addAncestorComparisonTypes(treeSet);
    }

    private static ComparisonType getFirstListComparison(SortedSet<ComparisonType> sortedSet) {
        ComparisonType comparisonType = null;
        for (ComparisonType comparisonType2 : sortedSet) {
            if (!comparisonType2.hasFeature(ComparisonTypeFeature.ISLISTCOMPARISON)) continue;
            comparisonType = comparisonType2;
            break;
        }
        return comparisonType;
    }

    private SortedSet<ComparisonType> addAncestorComparisonTypes(SortedSet<ComparisonType> sortedSet) {
        assert (sortedSet != null);
        TreeSet<ComparisonType> treeSet = new TreeSet<ComparisonType>(sortedSet);
        for (ComparisonType comparisonType : sortedSet) {
            for (ComparisonDataType comparisonDataType = comparisonType.getParentDataType(); comparisonDataType != null; comparisonDataType = comparisonDataType.getParentDataType()) {
                if (!this.fDataTypeNameToComparisonType.containsKey(comparisonDataType.getName())) continue;
                ComparisonType comparisonType2 = this.fDataTypeNameToComparisonType.get(comparisonDataType.getName());
                treeSet.add(comparisonType2);
            }
        }
        return treeSet;
    }

    private Map<ComparisonTypeDeterminant, Object> getDeterminantValues(ComparisonSource comparisonSource) {
        assert (comparisonSource != null);
        HashMap<ComparisonTypeDeterminant, Object> hashMap = new HashMap<ComparisonTypeDeterminant, Object>();
        for (ComparisonTypeDeterminant comparisonTypeDeterminant : this.fComparisonTypeDeterminantRegister) {
            Object t = comparisonTypeDeterminant.getValue(comparisonSource);
            if (t == null) continue;
            hashMap.put(comparisonTypeDeterminant, t);
        }
        return hashMap;
    }

    private static List<ComparisonType> applyRequiredFeatures(List<ComparisonType> list, Set<ComparisonTypeFeature> set) {
        List<ComparisonType> list2;
        if (set == null || set.isEmpty()) {
            list2 = list;
        } else {
            list2 = new ArrayList<ComparisonType>();
            for (ComparisonType comparisonType : list) {
                if (!ComparisonTypeRegisterImpl.hasRequiredFeatures(comparisonType, set)) continue;
                list2.add(comparisonType);
            }
        }
        return list2;
    }

    private static boolean hasRequiredFeatures(ComparisonType comparisonType, Set<ComparisonTypeFeature> set) {
        for (ComparisonTypeFeature comparisonTypeFeature : set) {
            if (comparisonType.hasFeature(comparisonTypeFeature)) continue;
            return false;
        }
        return true;
    }
}

