/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.prefs;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ColorProfileBuilder {
    public static final String LEFT_DIFFERENCE_COLOR_NAME = "LeftDifferenceColor";
    public static final String RIGHT_DIFFERENCE_COLOR_NAME = "RightDifferenceColor";
    public static final String MODIFIED_LINE_COLOR_NAME = "ModifiedLineColor";
    public static final String MODIFIED_CONTENT_COLOR_NAME = "ModifiedContentColor";
    public static final String MERGED_COLOR_NAME = "MergedColor";
    private final String fProfileName;
    private final Map<String, Color> fColorsMap;

    public ColorProfileBuilder(String string, Map<String, Color> map) {
        Validate.notNull((Object)string);
        Validate.notNull(map);
        Validate.isTrue((boolean)map.containsKey(LEFT_DIFFERENCE_COLOR_NAME));
        Validate.isTrue((boolean)map.containsKey(RIGHT_DIFFERENCE_COLOR_NAME));
        Validate.isTrue((boolean)map.containsKey(MODIFIED_LINE_COLOR_NAME));
        Validate.isTrue((boolean)map.containsKey(MODIFIED_CONTENT_COLOR_NAME));
        Validate.isTrue((boolean)map.containsKey(MERGED_COLOR_NAME));
        this.fColorsMap = new HashMap<String, Color>(map);
        this.fProfileName = string;
    }

    public Color getLeftDifferenceColor() {
        return this.fColorsMap.get(LEFT_DIFFERENCE_COLOR_NAME);
    }

    public Color getRightDifferenceColor() {
        return this.fColorsMap.get(RIGHT_DIFFERENCE_COLOR_NAME);
    }

    public Color getModifiedLineColor() {
        return this.fColorsMap.get(MODIFIED_LINE_COLOR_NAME);
    }

    public Color getModifiedContentColor() {
        return this.fColorsMap.get(MODIFIED_CONTENT_COLOR_NAME);
    }

    public Color getMergedColor() {
        return this.fColorsMap.get(MERGED_COLOR_NAME);
    }

    public String getProfileName() {
        return this.fProfileName;
    }
}

