/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.filter.text;

import com.mathworks.comparisons.filter.ComparisonFilterState;
import com.mathworks.comparisons.filter.Filter;
import com.mathworks.comparisons.filter.text.IgnoreWhiteSpaceFilter;
import com.mathworks.comparisons.filter.text.ShowDifferencesOnlyFilter;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterIgnoreWhitespace;
import com.mathworks.comparisons.param.parameter.CParameterShowDifferencesOnly;
import com.mathworks.comparisons.prefs.PreferenceAware;
import com.mathworks.comparisons.prefs.preference.CPreferenceIgnoreWhitespace;
import com.mathworks.comparisons.prefs.preference.CPreferenceShowDifferencesOnly;
import com.mathworks.comparisons.util.Restorable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TextComparisonFilterState
implements ComparisonFilterState<Filter>,
PreferenceAware {
    private final Filter fIgnoreWhiteSpaceFilter;
    private final Filter fShowDifferencesOnlyFilter;
    private final Map<Filter, Boolean> fFilterStates;
    private final ComparisonParameterSet fParameters;

    public TextComparisonFilterState(ComparisonParameterSet comparisonParameterSet) {
        if (comparisonParameterSet == null) {
            throw new IllegalArgumentException("Comparison parameters cannot be null");
        }
        if (!comparisonParameterSet.hasParameter(CParameterIgnoreWhitespace.getInstance())) {
            throw new IllegalArgumentException("Comparison parameters must contain ignore whitespace parameter");
        }
        if (!comparisonParameterSet.hasParameter(CParameterShowDifferencesOnly.getInstance())) {
            throw new IllegalArgumentException("Comparison parameters must contain show differences only parameter");
        }
        this.fIgnoreWhiteSpaceFilter = new IgnoreWhiteSpaceFilter();
        this.fShowDifferencesOnlyFilter = new ShowDifferencesOnlyFilter();
        this.fParameters = comparisonParameterSet;
        this.fFilterStates = new ConcurrentHashMap<Filter, Boolean>();
        this.fFilterStates.put(this.fIgnoreWhiteSpaceFilter, (Boolean)comparisonParameterSet.getValue(CParameterIgnoreWhitespace.getInstance()));
        this.fFilterStates.put(this.fShowDifferencesOnlyFilter, (Boolean)comparisonParameterSet.getValue(CParameterShowDifferencesOnly.getInstance()));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TextComparisonFilterState)) {
            return false;
        }
        ComparisonFilterState comparisonFilterState = (ComparisonFilterState)object;
        return this.doFilterListsMatch(comparisonFilterState.getFilterStates());
    }

    @Override
    public Collection<Filter> getFilters() {
        return new CopyOnWriteArrayList<Filter>(this.fFilterStates.keySet());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.fFilterStates).toHashCode();
    }

    @Override
    public Restorable.Memento createMemento() {
        HashMap<Filter, Boolean> hashMap = new HashMap<Filter, Boolean>();
        hashMap.putAll(this.fFilterStates);
        return new TextFiltersMemento(hashMap);
    }

    @Override
    public void restoreFromMemento(Restorable.Memento memento) {
        if (!(memento instanceof TextFiltersMemento)) {
            throw new IllegalArgumentException("Memento must be instance of TextFiltersMemento.");
        }
        TextFiltersMemento textFiltersMemento = (TextFiltersMemento)memento;
        textFiltersMemento.restore(this);
    }

    @Override
    public void saveToPreferences() {
        CPreferenceIgnoreWhitespace.getInstance().set(this.fFilterStates.get(this.fIgnoreWhiteSpaceFilter));
        CPreferenceShowDifferencesOnly.getInstance().set(this.fFilterStates.get(this.fShowDifferencesOnlyFilter));
        this.fParameters.setValue(CParameterIgnoreWhitespace.getInstance(), this.fFilterStates.get(this.fIgnoreWhiteSpaceFilter));
        this.fParameters.setValue(CParameterShowDifferencesOnly.getInstance(), this.fFilterStates.get(this.fShowDifferencesOnlyFilter));
    }

    @Override
    public Map<Filter, Boolean> getFilterStates() {
        return new ConcurrentHashMap<Filter, Boolean>(this.fFilterStates);
    }

    @Override
    public boolean isEnabled(Filter filter) {
        Validate.notNull((Object)filter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(filter), (String)"Filter must be part of group");
        return this.fFilterStates.get(filter);
    }

    @Override
    public void setEnabled(Filter filter, boolean bl) {
        Validate.notNull((Object)filter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(filter), (String)"Filter must be part of group");
        this.fFilterStates.put(filter, bl);
    }

    @Override
    public boolean isVisible(Filter filter) {
        Validate.notNull((Object)filter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(filter), (String)"Filter must be part of group");
        return true;
    }

    private boolean doFilterListsMatch(Map<Filter, Boolean> map) {
        boolean bl = true;
        for (Map.Entry<Filter, Boolean> entry : this.fFilterStates.entrySet()) {
            Filter filter = entry.getKey();
            if (!map.containsKey(filter)) {
                bl = false;
                break;
            }
            bl = map.get(filter).equals(entry.getValue());
            if (bl) continue;
            break;
        }
        return bl;
    }

    private static class TextFiltersMemento
    implements Restorable.Memento {
        private final Map<Filter, Boolean> fFilterStateMap = new HashMap<Filter, Boolean>();

        private TextFiltersMemento(Map<Filter, Boolean> map) {
            this.fFilterStateMap.putAll(map);
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37);
            for (Map.Entry<Filter, Boolean> entry : this.fFilterStateMap.entrySet()) {
                hashCodeBuilder.append((Object)entry.getKey());
                hashCodeBuilder.append((Object)entry.getValue());
            }
            return hashCodeBuilder.toHashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TextFiltersMemento)) {
                return false;
            }
            TextFiltersMemento textFiltersMemento = (TextFiltersMemento)object;
            Map<Filter, Boolean> map = textFiltersMemento.fFilterStateMap;
            if (this.fFilterStateMap.size() != map.size()) {
                return false;
            }
            for (Map.Entry<Filter, Boolean> entry : this.fFilterStateMap.entrySet()) {
                Filter filter = entry.getKey();
                Boolean bl = entry.getValue();
                if (!map.containsKey(filter)) {
                    return false;
                }
                if (map.get(filter).equals(bl)) continue;
                return false;
            }
            return true;
        }

        private void restore(TextComparisonFilterState textComparisonFilterState) {
            textComparisonFilterState.fFilterStates.clear();
            textComparisonFilterState.fFilterStates.putAll(this.fFilterStateMap);
        }
    }
}

