/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport;

import com.mathworks.comparisons.decorator.actionid.ActionIDSaveAs;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHtmlComponent;
import com.mathworks.comparisons.util.ComparisonsExecutor;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.html.HtmlFileWriter;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.toolbox.shared.computils.dialogs.ProgressBarDialog;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class SaveAsHtmlAction
extends MJAbstractAction {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.report.toolstrip.resources.RES_Save_As_Comparison_Toolstrip");
    private final transient ComparisonHtmlComponent fHtmlComponent;

    public SaveAsHtmlAction(ComparisonHtmlComponent comparisonHtmlComponent) {
        this.fHtmlComponent = comparisonHtmlComponent;
        this.setComponentName(ActionIDSaveAs.getInstance().getName());
        this.putValue("Name", RESOURCE_BUNDLE.getString("Tool.save_to_html.Label"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("html");
        arrayList.add("htm");
        FileExtensionFilter fileExtensionFilter = new FileExtensionFilter(HTMLUtils.sRes.getString("filetype.html"), arrayList, true);
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)fileExtensionFilter);
        mJFileChooserPerPlatform.setMultiSelectionEnabled(false);
        mJFileChooserPerPlatform.setSelectedFile(new File(ResourceManager.format("save.as.html.default.file.name", new Object[0])));
        mJFileChooserPerPlatform.showSaveDialog(this.fHtmlComponent.getComponent());
        if (mJFileChooserPerPlatform.getState() == 0) {
            String string;
            File file = mJFileChooserPerPlatform.getSelectedFile();
            if (!fileExtensionFilter.accept(file) && ((string = FilenameUtils.getExtension((String)file.getName())) == null || string.isEmpty())) {
                file = SaveAsHtmlAction.addFileExtension(file);
            }
            this.saveHtmlToFile(file);
        }
    }

    private static File addFileExtension(File file) {
        return new File(file.getAbsolutePath() + ".html");
    }

    private void saveHtmlToFile(final File file) {
        final AtomicReference atomicReference = new AtomicReference();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialog progressBarDialog = ProgressBarDialog.createInternalProgressBar((RootPaneContainer)SaveAsHtmlAction.getRootPaneContainer((Container)SaveAsHtmlAction.this.fHtmlComponent.getComponent()), (String)ResourceManager.format("text.progress.title", new Object[0]), null);
                progressBarDialog.setCircularProgressBar(true);
                progressBarDialog.setCancelButtonVisible(false);
                progressBarDialog.setProgressStatusLabel(ResourceManager.format("text.progress.save.html", new Object[0]));
                progressBarDialog.setVisible(true);
                atomicReference.set(progressBarDialog);
            }
        });
        ComparisonsExecutor.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                HtmlFileWriter htmlFileWriter = new HtmlFileWriter(file, SaveAsHtmlAction.this.getHtmlTextWithAllLinksRemoved(), SaveAsHtmlAction.this.fHtmlComponent.getCurrentLocation(), false);
                htmlFileWriter.saveFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBarDialog progressBarDialog = (ProgressBarDialog)atomicReference.get();
                        progressBarDialog.setVisible(false);
                        progressBarDialog.dispose();
                    }
                });
            }
        });
    }

    private static RootPaneContainer getRootPaneContainer(Container container) {
        while (container != null && !(container instanceof RootPaneContainer)) {
            container = container.getParent();
        }
        if (container == null) {
            return null;
        }
        return (RootPaneContainer)((Object)container);
    }

    private String getHtmlTextWithAllLinksRemoved() {
        return this.fHtmlComponent.executeScriptWithReturn("getHtmlTextToSave()");
    }
}

