/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.impl.CompareInMatlab;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.variable.VariableComparisonDecorator;
import com.mathworks.comparisons.decorator.variable.VariableDifferences;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyDataAccessFcn;
import com.mathworks.comparisons.source.property.CSPropertyName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class VariableComparison
extends CompareInMatlab
implements VariableComparisonDecorator.SubsrefCallbackProvider {
    private VariableComparisonDecorator fDecorator;
    private ComparisonSource fSource1;
    private ComparisonSource fSource2;
    private String fSubsref1;
    private String fSubsref2;
    private ComparisonParameterSet fParameterSet;
    private static final Map<String, VariableComparison> COMPARISONS = new HashMap<String, VariableComparison>();

    public VariableComparison() {
        super("comparisons_private", 1);
        VariableComparison.addComparison(this);
    }

    @Override
    public void compareAndDisplay(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        this.fSource1 = comparisonSource;
        this.fSource2 = comparisonSource2;
        this.fParameterSet = comparisonParameterSet;
        this.fSubsref1 = null;
        this.fSubsref2 = null;
        super.compareAndDisplay(comparisonSource, comparisonSource2, comparisonParameterSet);
    }

    @Override
    public void overrideDefaultDecorator(ComparisonReportDecorator comparisonReportDecorator) {
        if (!(comparisonReportDecorator instanceof VariableComparisonDecorator)) {
            throw new IllegalArgumentException("Decorator should be VariableComparisonDecorator implementation");
        }
        this.dispose();
        this.fDecorator = (VariableComparisonDecorator)comparisonReportDecorator;
    }

    @Override
    public ComparisonReportDecorator getDecorator() {
        if (this.fDecorator == null) {
            this.fDecorator = new VariableComparisonDecorator(this);
        }
        return this.fDecorator;
    }

    @Override
    public void dispose() {
        if (this.fDecorator != null) {
            this.fDecorator.dispose();
            this.fDecorator = null;
        }
        VariableComparison.removeComparison(this);
    }

    @Override
    public void doSubsref(String string, String string2) {
        this.fSubsref1 = string;
        this.fSubsref2 = string2;
        super.compareAndDisplay(this.fSource1, this.fSource2, this.fParameterSet);
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    public Object getSource1() {
        return this.fSource1;
    }

    public Object getSource2() {
        return this.fSource2;
    }

    @Override
    protected void displayComparisonResult(Object object) throws Exception {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        if (!this.fSource1.hasProperty(cSPropertyName) || !this.fSource2.hasProperty(cSPropertyName)) {
            throw new IllegalStateException("Sources must have name property");
        }
        VariableDifferences variableDifferences = (VariableDifferences)object;
        String string = (String)this.fSource1.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        String string2 = (String)this.fSource2.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        variableDifferences.setName1(string);
        variableDifferences.setName2(string2);
        if (this.fDecorator != null) {
            this.fDecorator.showDifferences(this.fSubsref1, this.fSubsref2, variableDifferences);
        }
        this.fSubsref1 = null;
        this.fSubsref2 = null;
    }

    @Override
    protected void setInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        assert (this.fSource1 == comparisonSource);
        assert (this.fSource2 == comparisonSource2);
        assert (this.fParameterSet == comparisonParameterSet);
        this.mInputArgs = new Object[5];
        this.mInputArgs[0] = "vardiff";
        CSPropertyDataAccessFcn cSPropertyDataAccessFcn = CSPropertyDataAccessFcn.getInstance();
        assert (this.fSource1.hasProperty(cSPropertyDataAccessFcn));
        String string = (String)this.fSource1.getPropertyValue(cSPropertyDataAccessFcn, new ComparisonSourcePropertyInfo[0]);
        assert (this.fSource2.hasProperty(cSPropertyDataAccessFcn));
        String string2 = (String)this.fSource2.getPropertyValue(cSPropertyDataAccessFcn, new ComparisonSourcePropertyInfo[0]);
        this.mInputArgs[1] = string;
        this.mInputArgs[2] = string2;
        this.mInputArgs[3] = this.fSubsref1;
        this.mInputArgs[4] = this.fSubsref2;
    }

    protected ComparisonResult convertToComparisonResult(Object object) {
        return null;
    }

    @Override
    protected void handle(final Exception exception, boolean bl) {
        if (!bl) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariableComparison.this.fDecorator.showError(exception.getMessage(), VariableComparison.this.fSubsref1 != null && !VariableComparison.this.fSubsref1.isEmpty());
            }
        });
    }

    private static void addComparison(VariableComparison variableComparison) {
        COMPARISONS.put(variableComparison.getReportID(), variableComparison);
    }

    private static void removeComparison(VariableComparison variableComparison) {
        COMPARISONS.remove(variableComparison.getReportID());
    }

    public static VariableComparison getComparison(String string) {
        return COMPARISONS.get(string);
    }

    public static Collection<String> getComparisonCodes() {
        return COMPARISONS.keySet();
    }
}

