/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.html.HtmlCallbackProvider;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.toolbox.shared.computils.dialogs.ProgressBarDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringEscapeUtils;

public class ListReportUpdater {
    private String fScript;
    private Thread fThread;
    private final AtomicBoolean fReportReady;
    private final AtomicBoolean fReportClosed;
    private final ProgressBarDialog fProgressBar;
    private final String fReportID;
    private final HtmlCallbackProvider fReport;

    public ListReportUpdater(HtmlCallbackProvider htmlCallbackProvider, String string, ProgressBarDialog progressBarDialog) {
        this.fReport = htmlCallbackProvider;
        this.fReportReady = new AtomicBoolean(false);
        this.fReportClosed = new AtomicBoolean(false);
        this.fReportID = string;
        this.fProgressBar = progressBarDialog;
    }

    public void reportClosed() {
        this.fReportClosed.set(true);
    }

    public synchronized void updateReport(String string, String string2, int n) {
        String string3 = ListReportUpdater.constructReplaceTableCellsCommand(string2, string, n);
        if (this.fThread != null) {
            assert (this.fScript != null);
            this.fScript = this.fScript + '\n' + string3;
        } else if (this.fReportReady.get()) {
            this.doUpdate(string3);
        } else {
            this.fScript = string3;
            this.startWaitThread();
        }
    }

    private static String constructReplaceTableCellsCommand(String string, CharSequence charSequence, int n) {
        List<String> list = ListReportUpdater.extractTableCellsFromRow(charSequence);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(function(){");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            String string3 = StringEscapeUtils.escapeJavaScript((String)ListReportUpdater.extractColourFromCell(string2));
            String string4 = StringEscapeUtils.escapeJavaScript((String)ListReportUpdater.extractContentsFromCell(string2));
            string4 = string4.replace(":", "&#58;");
            stringBuilder.append("replace_table_cell(\"" + string + "\"," + i + ", \"" + string3 + "\",\"" + string4 + "\");");
        }
        stringBuilder.append("setQueueLength(" + n + ");");
        stringBuilder.append("})();");
        return stringBuilder.toString();
    }

    private static List<String> extractTableCellsFromRow(CharSequence charSequence) {
        Pattern pattern = Pattern.compile("<td(.*?)</td>", 32);
        Matcher matcher = pattern.matcher(charSequence);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    private static String extractColourFromCell(CharSequence charSequence) {
        Pattern pattern = Pattern.compile("style=\"background:(.*?)\"");
        Matcher matcher = pattern.matcher(charSequence);
        matcher.find();
        return matcher.group(1);
    }

    private static String extractContentsFromCell(CharSequence charSequence) {
        Pattern pattern = Pattern.compile("<td[^>]+>(.*?)</td>", 32);
        Matcher matcher = pattern.matcher(charSequence);
        matcher.find();
        return matcher.group(1);
    }

    private void doUpdate(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ListReportUpdater.this.fReportClosed.get()) {
                    ListReportUpdater.this.fReport.executeScript(string);
                }
            }
        });
    }

    public boolean isReportReady() {
        if (this.fReportReady.get()) {
            return true;
        }
        try {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final StringBuilder stringBuilder = new StringBuilder(0);
            this.fReport.executeScript("pageid", (HtmlDataListener)new HtmlDataListener<String>(){

                public void dataRetrieved(String string) {
                    stringBuilder.append(string);
                    countDownLatch.countDown();
                }
            });
            if (this.fReport.isInitialized()) {
                countDownLatch.await(200L, TimeUnit.MILLISECONDS);
            }
            if (!stringBuilder.toString().equals(this.fReportID)) {
                return false;
            }
            this.fReportReady.set(true);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private synchronized void executePendingScript() {
        String string = this.fScript;
        this.fScript = null;
        this.fThread = null;
        this.doUpdate(string);
    }

    private void startWaitThread() {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    ListReportUpdater.this.fReportReady.set(ListReportUpdater.this.isReportReady());
                    if (ListReportUpdater.this.fReportReady.get()) {
                        this.disposeProgressBar();
                        ListReportUpdater.this.executePendingScript();
                        return;
                    }
                    if (ListReportUpdater.this.fReportClosed.get()) {
                        ListReportUpdater.this.fThread = null;
                        return;
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return;
                    }
                }
                this.disposeProgressBar();
                throw new RuntimeException("Page not ready to receive Javascript updates");
            }

            private void disposeProgressBar() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ListReportUpdater.this.fProgressBar != null) {
                            ListReportUpdater.this.fProgressBar.dispose();
                        }
                    }
                });
            }
        };
        this.fThread = new Thread(runnable);
        this.fThread.start();
    }
}

