/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocCenterResultComparator;
import com.mathworks.helpsearch.reference.ReferenceData;
import java.util.regex.Pattern;

public class ReferenceEntityNameComparator
extends DocCenterResultComparator<ReferenceData> {
    private final Pattern fPageNamePattern;

    public ReferenceEntityNameComparator(String entityName) {
        super(entityName);
        this.fPageNamePattern = Pattern.compile("(^|/)" + Pattern.quote(entityName) + "\\.html$", 2);
    }

    @Override
    public int compare(ReferenceData t1, ReferenceData t2) {
        int compare = super.compare(t1, t2);
        if (compare == 0) {
            if (this.fPageNamePattern.matcher(t1.getRelativePath()).find()) {
                --compare;
            }
            if (this.fPageNamePattern.matcher(t2.getRelativePath()).find()) {
                ++compare;
            }
        }
        return compare;
    }

    @Override
    protected String getTitle(ReferenceData item) {
        return item.getTopic();
    }

    @Override
    protected int getPopularity(ReferenceData item) {
        return 1;
    }

    @Override
    protected float getScore(ReferenceData item) {
        return 1.0f;
    }
}

