/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.validation.DocSetValidationCheck;
import com.mathworks.helpsearch.product.validation.ValidationResponse;
import com.mathworks.search.SearchField;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexUtils;
import java.util.HashMap;
import java.util.Map;

public class UnknownProductsCheck
extends DocSetValidationCheck {
    private final Map<String, Integer> fProductStats;

    public UnknownProductsCheck(DocumentationSet docSet, Map<String, Integer> productStats) {
        super(docSet);
        this.fProductStats = new HashMap<String, Integer>(productStats);
    }

    public UnknownProductsCheck(DocumentationSet docSet, IndexLocation location) {
        super(docSet);
        Map productStats = null;
        try {
            productStats = LuceneIndexUtils.getSearchFieldStatistics((IndexLocation)location, (SearchField)DocumentationSearchField.PRODUCT);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fProductStats = productStats;
    }

    @Override
    public ValidationResponse validate(DocumentationSet docSet) {
        ValidationResponse response = new ValidationResponse();
        if (this.fProductStats == null) {
            response.addMessage(ValidationResponse.Status.ERROR, "Failed to load product data from the search index.");
            response.addTroubleshootingStep("Check that this documentation set has a valid search index.");
            return response;
        }
        boolean unknownProductExists = false;
        DocCenterItemResolver resolver = new DocCenterItemResolver(docSet);
        for (String product : this.fProductStats.keySet()) {
            DocProduct fromDocSet = resolver.getDocProductByIndexString(product);
            if (fromDocSet == null) {
                response.addMessage(ValidationResponse.Status.ERROR, "Search index contains an unknown product: \"" + product + "\"");
                unknownProductExists = true;
                continue;
            }
            response.addMessage(ValidationResponse.Status.OK, product + " : " + fromDocSet.getDisplayName());
        }
        if (unknownProductExists) {
            response.addTroubleshootingStep("The search index may not have been updated after products were changed or removed from the documentation set.  Rebuilding the search index will typically solve this issue");
        }
        return response;
    }

    @Override
    public String getName() {
        return "Unknown Products in Search Index";
    }

    @Override
    public String getDescription() {
        return "Validates that every product in the search index is defined in the corresponding documentation set.  If this validation fails, it typically means that the documentation set has been updated without a corresponding update to the search index.";
    }
}

