/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.DocProduct;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class MatlabeticalProductComparator
implements Comparator<DocProduct> {
    private static final Map<String, SortPriority> PRIORITY_MAP = new HashMap<String, SortPriority>();

    @Override
    public int compare(DocProduct prod1, DocProduct prod2) {
        SortPriority priority2;
        SortPriority priority1 = this.getSortPriority(prod1);
        if (priority1 == (priority2 = this.getSortPriority(prod2))) {
            if (priority1 == SortPriority.ALPHABETICAL) {
                return prod1.getDisplayName().compareToIgnoreCase(prod2.getDisplayName());
            }
            return 0;
        }
        return priority1.compareTo(priority2);
    }

    private SortPriority getSortPriority(DocProduct product) {
        SortPriority priority = PRIORITY_MAP.get(product.getShortName());
        return priority == null ? SortPriority.ALPHABETICAL : priority;
    }

    static {
        PRIORITY_MAP.put("matlab", SortPriority.MATLAB);
        PRIORITY_MAP.put("simulink", SortPriority.SIMULINK);
    }

    private static enum SortPriority {
        MATLAB,
        SIMULINK,
        ALPHABETICAL;

    }
}

