/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.report.ReportPart;
import com.mathworks.helpsearch.index.report.StringReportPart;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListReportPart
extends ReportPart {
    private final List<ReportPart> fListParts = new LinkedList<ReportPart>();
    private final Direction fDirection;

    public ListReportPart(Collection<ReportPart> parts, Direction direction) {
        this.fListParts.addAll(parts);
        this.fDirection = direction;
    }

    public static ListReportPart fromStrings(Collection<String> strings, Direction direction) {
        LinkedList<ReportPart> parts = new LinkedList<ReportPart>();
        for (String string : strings) {
            parts.add(new StringReportPart(string));
        }
        return new ListReportPart(parts, direction);
    }

    @Override
    public void appendToReport(StringBuilder builder) {
        if (!this.fListParts.isEmpty()) {
            builder.append("<table class=\"reportlisttable\">\n");
            if (this.fDirection == Direction.HORIZONTAL) {
                builder.append("<tr class=\"reportlistrow\">");
            }
            for (ReportPart part : this.fListParts) {
                if (this.fDirection == Direction.VERTICAL) {
                    builder.append("<tr class=\"reportlistrow\">");
                }
                builder.append("<td class=\"reportlistcell\">");
                part.appendToReport(builder);
                builder.append("</td>");
                if (this.fDirection != Direction.VERTICAL) continue;
                builder.append("</tr>");
            }
            if (this.fDirection == Direction.HORIZONTAL) {
                builder.append("</tr>");
            }
            builder.append("</table>");
        }
    }

    @Override
    protected Map<String, String> getCssRules() {
        LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
        rules.put("table.reportlisttable", "border:0;");
        rules.put("tr.reportlistrow", "border:0;");
        rules.put("td.reportlistcell", "border:0;");
        return Collections.unmodifiableMap(rules);
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

