/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentQueue;
import com.mathworks.helpsearch.index.DocumentationDocument;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;

public class TraversalStrategyQueue
implements DocumentQueue {
    private static final List<Pattern> EXCLUSION_PATTERNS = TraversalStrategyQueue.setupExceptions();
    private final DocTraversalStrategy fTraversalStrategy;
    private final Queue<String> fPendingDocs = new LinkedList<String>();

    public TraversalStrategyQueue(DocTraversalStrategy dts) {
        this.fTraversalStrategy = dts;
        Collection<String> initialDocs = dts.getPendingDocuments();
        TraversalStrategyQueue.addDocumentsToList(this.fPendingDocs, initialDocs);
    }

    private static List<Pattern> setupExceptions() {
        LinkedList<Pattern> exceptions = new LinkedList<Pattern>();
        exceptions.add(Pattern.compile("rmvd_matlablink"));
        return exceptions;
    }

    @Override
    public boolean hasNext() {
        return !this.fPendingDocs.isEmpty();
    }

    @Override
    public String next() {
        return this.fPendingDocs.remove();
    }

    @Override
    public void remove() {
    }

    @Override
    public void updateAfterDocument(DocumentationDocument doc, boolean indexed) {
        Collection<String> newDocs = this.fTraversalStrategy.updateAfterDocument(doc, indexed);
        if (newDocs != null && !newDocs.isEmpty()) {
            this.addDocuments(newDocs);
        }
        if (this.fPendingDocs.isEmpty()) {
            this.addPendingDocuments();
        }
    }

    private void addPendingDocuments() {
        Collection<String> pendingDocs = this.fTraversalStrategy.getPendingDocuments();
        if (pendingDocs != null && !pendingDocs.isEmpty()) {
            this.addDocuments(pendingDocs);
        }
    }

    private void addDocuments(Collection<String> documents) {
        TraversalStrategyQueue.addDocumentsToList(this.fPendingDocs, documents);
    }

    private static void addDocumentsToList(Queue<String> docList, Collection<String> newDocs) {
        LinkedList<String> toAdd = new LinkedList<String>();
        for (String newDoc : newDocs) {
            if (!TraversalStrategyQueue.acceptDocument(newDoc) || docList.contains(newDoc)) continue;
            toAdd.add(newDoc);
        }
        docList.addAll(toAdd);
    }

    private static boolean acceptDocument(String filename) {
        for (Pattern exclusion : EXCLUSION_PATTERNS) {
            if (!exclusion.matcher(filename).find()) continue;
            return false;
        }
        return true;
    }
}

