/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.index.DefaultDomDocumentBuilder;
import com.mathworks.helpsearch.index.DirectoryListingTraversalStrategy;
import com.mathworks.helpsearch.index.DocCrawler;
import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentParser;
import com.mathworks.helpsearch.index.DocumentQueue;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DomDocumentBuilder;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexDocumentIterator;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.SingleDocumentHandler;
import com.mathworks.helpsearch.index.TraversalStrategyQueue;
import com.mathworks.helpsearch.index.classic.ClassicDocHtmlParserFactory;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlParserFactory;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DocSearchIndexDocumentIterator<T extends SearchField>
implements IndexDocumentIterator {
    private final DocumentQueue fQueue;
    private final AggregateIndexObserver fObserver = new AggregateIndexObserver();
    private final SingleDocumentHandler<T> fDocumentHandler;
    private final List<IndexDocument<T>> fRemaining = new LinkedList<IndexDocument<T>>();

    public DocSearchIndexDocumentIterator(IndexerConfig config, DocSetItem docSetItem, HtmlToDomAdapter domAdapter, IndexDocumentBuilder<T> indexDocBuilder) {
        this(config.getDocRoot(), docSetItem, DocSearchIndexDocumentIterator.getQueue(docSetItem, config), DocSearchIndexDocumentIterator.createDomDocBuilder(config.getFileLocator(), domAdapter), DocSearchIndexDocumentIterator.createDocumentParser(docSetItem), indexDocBuilder, config.getFileLocator());
    }

    DocSearchIndexDocumentIterator(File docRoot, DocSetItem docSetItem, DocumentQueue documentQueue, DomDocumentBuilder domDocBuilder, DocumentParser docParser, IndexDocumentBuilder<T> indexDocBuilder, LocalizedFileLocator locator) {
        this.fQueue = documentQueue;
        this.fDocumentHandler = new SingleDocumentHandler<T>(docRoot, docSetItem, locator, domDocBuilder, docParser, indexDocBuilder);
    }

    private static DocumentQueue getQueue(DocSetItem docSetItem, IndexerConfig config) {
        return new TraversalStrategyQueue(DocSearchIndexDocumentIterator.getTraversalStrategy(docSetItem, config));
    }

    private static DocTraversalStrategy getTraversalStrategy(DocSetItem docSetItem, IndexerConfig config) {
        switch (docSetItem.getDocSet().getFormat()) {
            case CLASSIC_DOC: {
                File docRoot = config.getDocRoot();
                File helpDir = docSetItem.getHelpLocation().buildHelpPath(docRoot, new FileHelpPathBuilder(), new String[0]);
                return new DirectoryListingTraversalStrategy(helpDir);
            }
        }
        return new DocCrawler(config.getFileLocator());
    }

    private static DomDocumentBuilder createDomDocBuilder(LocalizedFileLocator locator, HtmlToDomAdapter domAdapter) {
        return new DefaultDomDocumentBuilder(locator, domAdapter);
    }

    private static DocumentParser createDocumentParser(DocSetItem docSetItem) {
        HtmlParserFactory parserFactory = DocSearchIndexDocumentIterator.getParserFactory(docSetItem);
        return new DocumentParser(docSetItem.getDocSet().getFormat(), parserFactory);
    }

    private static HtmlParserFactory getParserFactory(DocSetItem docSetItem) {
        ContentFormat format = docSetItem.getDocSet().getFormat();
        switch (format) {
            case CLASSIC_DOC: {
                return new ClassicDocHtmlParserFactory();
            }
        }
        return new DocCenterHtmlParserFactory(docSetItem);
    }

    @Override
    public void beforeIndex() {
        this.fObserver.indexingStarted();
        this.fRemaining.addAll(this.createNextDocuments());
    }

    @Override
    public boolean hasNext() {
        return !this.fRemaining.isEmpty();
    }

    @Override
    public IndexDocument<T> next() {
        if (this.fRemaining.isEmpty()) {
            throw new IllegalStateException("No more documents.");
        }
        IndexDocument<T> returnVal = this.fRemaining.remove(0);
        if (this.fRemaining.isEmpty()) {
            this.fRemaining.addAll(this.createNextDocuments());
        }
        return returnVal;
    }

    @Override
    public void remove() {
    }

    @Override
    public void afterIndex() {
        this.fObserver.indexingFinished();
    }

    public void addObserver(IndexerObserver<T> observer) {
        this.fObserver.addObserver(observer);
    }

    List<IndexDocument<T>> createNextDocuments() {
        try {
            while (this.fQueue.hasNext()) {
                List<IndexDocument<T>> next = this.attemptParse();
                if (next == null || next.isEmpty()) continue;
                return next;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while indexing", e);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IndexDocument<T>> attemptParse() throws Exception {
        String next = (String)this.fQueue.next();
        DocumentTracker<T> tracker = this.fDocumentHandler.createDocumentTracker(next);
        this.fObserver.startDocument(tracker);
        ArrayList<IndexDocument<T>> indexDocs = new ArrayList<IndexDocument<T>>();
        try {
            this.fDocumentHandler.createIndexDocument(tracker, this.fObserver);
            indexDocs.addAll(tracker.getIndexDocuments());
            ArrayList<IndexDocument<T>> arrayList = indexDocs;
            this.fQueue.updateAfterDocument(tracker.getDocumentationDocument(), !indexDocs.isEmpty());
            this.fObserver.endDocument(tracker);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.fQueue.updateAfterDocument(tracker.getDocumentationDocument(), !indexDocs.isEmpty());
            this.fObserver.endDocument(tracker);
            throw throwable;
        }
    }

    private class AggregateIndexObserver
    implements IndexerObserver<T> {
        private final List<IndexerObserver<T>> iObservers = new LinkedList();

        private AggregateIndexObserver() {
        }

        private void addObserver(IndexerObserver<T> observer) {
            this.iObservers.add(observer);
        }

        @Override
        public void indexingStarted() {
            for (IndexerObserver observer : this.iObservers) {
                observer.indexingStarted();
            }
        }

        @Override
        public void startDocument(DocumentTracker<T> tracker) {
            for (IndexerObserver observer : this.iObservers) {
                observer.startDocument(tracker);
            }
        }

        @Override
        public void parsedDocument(DocumentTracker<T> tracker) {
            for (IndexerObserver observer : this.iObservers) {
                observer.parsedDocument(tracker);
            }
        }

        @Override
        public void createdIndexDocument(DocumentTracker<T> tracker) {
            for (IndexerObserver observer : this.iObservers) {
                observer.createdIndexDocument(tracker);
            }
        }

        @Override
        public void endDocument(DocumentTracker<T> tracker) {
            for (IndexerObserver observer : this.iObservers) {
                observer.endDocument(tracker);
            }
        }

        @Override
        public void indexingFinished() {
            for (IndexerObserver observer : this.iObservers) {
                observer.indexingFinished();
            }
        }
    }
}

