/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.HelpLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class HelpPathBuilder<T> {
    final T buildHelpPath(T docRoot, HelpLocation location, String ... pathParts) {
        T basePath = this.createBasePath(docRoot, location);
        if (basePath != null && pathParts.length > 0) {
            List<String> correctedParts = this.correctPathParts(pathParts);
            return this.appendPathParts(basePath, correctedParts);
        }
        return basePath;
    }

    private List<String> correctPathParts(String[] pathParts) {
        ArrayList<String> corrected = new ArrayList<String>(pathParts.length);
        for (String pathPart : pathParts) {
            corrected.add(pathPart.replaceFirst("^/*(.*?)/*$", "$1"));
        }
        return corrected;
    }

    protected abstract T createBasePath(T var1, HelpLocation var2);

    protected abstract T appendPathParts(T var1, List<String> var2);

    protected final List<String> getRelativePathParts(HelpLocation location) {
        return location.getRelativePathParts();
    }

    protected final File getHelpLocationFile(File docRoot, HelpLocation location) {
        return location.toFile(docRoot);
    }
}

