/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.constants.TimeConstants;
import com.sun.jini.constants.TxnConstants;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.AbortJob;
import com.sun.jini.mahalo.AbortRecord;
import com.sun.jini.mahalo.CommitJob;
import com.sun.jini.mahalo.CommitRecord;
import com.sun.jini.mahalo.InternalManagerException;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.PrepareAndCommitJob;
import com.sun.jini.mahalo.PrepareJob;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;

class TxnManagerTransaction
implements TransactionConstants,
TimeConstants,
Serializable,
LeasedResource {
    static final long serialVersionUID = -2088463193687796098L;
    private static final boolean[][] states = new boolean[][]{{false, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, true, false, false, true, true}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, true, false}, {false, false, false, false, false, false, true}};
    private List parts = new Vector();
    private final ServerTransaction str;
    private int trstate;
    private long expires;
    private LogManager logmgr;
    private TaskManager threadpool;
    private WakeupManager wm;
    private TxnSettler settler;
    private Job job;
    private Uuid uuid;
    private Object leaseLock = new Object();
    private Object jobLock = new Object();
    private Object stateLock = new Object();
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger transactionsLogger = TxnManagerImpl.transactionsLogger;

    TxnManagerTransaction(TransactionManager transactionManager, LogManager logManager, long l, TaskManager taskManager, WakeupManager wakeupManager, TxnSettler txnSettler, Uuid uuid) {
        if (logManager == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: log manager must be non-null");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: transaction manager must be non-null");
        }
        if (taskManager == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: threadpool must be non-null");
        }
        if (wakeupManager == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: wakeup manager must be non-null");
        }
        if (txnSettler == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: settler must be non-null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: uuid must be non-null");
        }
        this.threadpool = taskManager;
        this.wm = wakeupManager;
        this.logmgr = logManager;
        this.str = new ServerTransaction(transactionManager, l);
        this.settler = txnSettler;
        this.uuid = uuid;
        this.trstate = 1;
    }

    void add(ParticipantHandle participantHandle) throws InternalManagerException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "add", participantHandle);
        }
        if (participantHandle == null) {
            throw new NullPointerException("ParticipantHolder: add: cannot add null handle");
        }
        try {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Adding ParticipantHandle: {0}", participantHandle);
            }
            this.parts.add(participantHandle);
        }
        catch (Exception exception) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Unable to add ParticipantHandle", exception);
            }
            throw new InternalManagerException("TxnManagerTransaction: add: " + exception.getMessage());
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "add");
        }
    }

    void modifyParticipant(ParticipantHandle participantHandle, int n) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyParticipant", new Object[]{participantHandle, new Integer(n)});
        }
        ParticipantHandle participantHandle2 = null;
        if (participantHandle == null) {
            throw new NullPointerException("ParticipantHolder: modifyParticipant: cannot modify null handle");
        }
        if (this.parts.contains(participantHandle2)) {
            participantHandle2 = (ParticipantHandle)this.parts.get(this.parts.indexOf(participantHandle));
        }
        if (participantHandle2 == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
            }
            return;
        }
        participantHandle2.setPrepState(n);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean modifyTxnState(int n) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyTxnState", new Integer(n));
        }
        boolean bl = false;
        Object object = this.stateLock;
        synchronized (object) {
            switch (n) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    bl = states[this.trstate][n];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TxnManagerTransaction: modifyTxnState: invalid state");
                }
            }
            if (bl) {
                this.trstate = n;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyTxnState", new Boolean(bl));
        }
        return bl;
    }

    public void join(TransactionParticipant transactionParticipant, long l) throws CannotJoinException, CrashCountException, RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "join", new Object[]{transactionParticipant, new Long(l)});
        }
        if (this.getState() != 1) {
            throw new CannotJoinException("not active");
        }
        if (this.getState() == 1 && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotJoinException("Lease expired");
        }
        try {
            ParticipantHandle participantHandle = new ParticipantHandle(transactionParticipant, l);
            ParticipantHandle participantHandle2 = this.parts.contains(participantHandle) ? this.parts.get(this.parts.indexOf(participantHandle)) : null;
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Retrieved ParticipantHandle: {0}", participantHandle2);
            }
            if (participantHandle2 != null) {
                long l2 = participantHandle2.getCrashCount();
                if (l2 == l) {
                    return;
                }
                throw new CrashCountException("TxnManagerTransaction: join: old = " + l2 + " new = " + l);
            }
            this.add(participantHandle);
        }
        catch (InternalManagerException internalManagerException) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "TransactionParticipant unable to join", internalManagerException);
            }
            throw internalManagerException;
        }
        catch (RemoteException remoteException) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "TransactionParticipant unable to be stored", remoteException);
            }
            throw remoteException;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "join");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getState");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getState", new Integer(this.trstate));
            }
            return this.trstate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void commit(long l) throws CannotCommitException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "commit", new Long(l));
        }
        long l2 = System.currentTimeMillis();
        if (this.getState() == 1 && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotCommitException("Lease expired");
        }
        if (this.getState() == 6) {
            throw new CannotCommitException("attempt to commit ABORTED transaction");
        }
        Vector vector = this.parthandles();
        if (vector == null) {
            if (!this.modifyTxnState(2)) {
                throw new CannotCommitException("attempt to commit ABORTED transaction");
            }
            if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit ABORTED transaction");
            return;
        }
        try {
            Object object;
            Enumeration enumeration = vector.elements();
            int n = vector.size();
            Object[] objectArray = new ParticipantHandle[n];
            vector.copyInto(objectArray);
            long l3 = l2;
            long l4 = 0L;
            long l5 = 0L;
            ClientLog clientLog = this.logmgr.logFor(this.str.id);
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "{0} TransactionParticipants have joined", new Integer(n));
            }
            int n2 = this.getState();
            Integer n3 = new Integer(6);
            if (this.modifyTxnState(2)) {
                if (n2 == 1) {
                    clientLog.write(new CommitRecord((ParticipantHandle[])objectArray));
                }
                object = this.jobLock;
                synchronized (object) {
                    if (this.job == null) {
                        this.job = objectArray.length == 1 ? new PrepareAndCommitJob((Transaction)this.str, this.threadpool, this.wm, clientLog, (ParticipantHandle)objectArray[0]) : new PrepareJob((Transaction)this.str, this.threadpool, this.wm, clientLog, (ParticipantHandle[])objectArray);
                        this.job.scheduleTasks();
                    }
                }
                object = this.jobLock;
                synchronized (object) {
                    if (this.job instanceof PrepareJob || this.job instanceof PrepareAndCommitJob) {
                        try {
                            if (this.job.isCompleted(Long.MAX_VALUE)) {
                                n3 = (Integer)this.job.computeResult();
                            }
                        }
                        catch (JobNotStartedException jobNotStartedException) {
                            n3 = new Integer(4);
                        }
                        catch (ResultNotReadyException resultNotReadyException) {
                        }
                        catch (JobException jobException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.getState() == 6) {
                throw new CannotCommitException("transaction ABORTED");
            }
            if (this.getState() == 5) {
                n3 = new Integer(5);
            }
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Voting result: {0}", TxnConstants.getName(n3));
            }
            switch (n3) {
                case 4: {
                    break;
                }
                case 6: {
                    l3 = System.currentTimeMillis();
                    l4 = l3 - l2;
                    l5 = l - l4;
                    if (l5 >= 0L) {
                        this.doAbort(l5);
                        throw new CannotCommitException("Unable to commit transaction");
                    } else {
                        this.doAbort(0L);
                    }
                    throw new CannotCommitException("Unable to commit transaction");
                }
                case 3: {
                    if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit ABORTED transaction");
                    object = this.jobLock;
                    synchronized (object) {
                        this.job = new CommitJob((Transaction)this.str, this.threadpool, this.wm, clientLog, (ParticipantHandle[])objectArray);
                        this.job.scheduleTasks();
                    }
                }
                case 5: {
                    object = this.jobLock;
                    synchronized (object) {
                        if (this.job instanceof PrepareAndCommitJob) {
                            if (!this.modifyTxnState(5)) {
                                throw new CannotCommitException("transaction ABORTED");
                            }
                            break;
                        }
                        if (this.job instanceof AbortJob) {
                            throw new CannotCommitException("transaction ABORTED");
                        }
                    }
                    if (this.getState() != 5) {
                        throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(n3));
                    }
                    l3 = System.currentTimeMillis();
                    l4 = l3 - l2;
                    boolean bl = false;
                    try {
                        l5 = l - l4;
                        Object object2 = this.jobLock;
                        synchronized (object2) {
                            if (l5 <= 0L || !this.job.isCompleted(l5)) {
                                this.settler.noteUnsettledTxn(this.str.id);
                                throw new TimeoutExpiredException("timeout expired", true);
                            }
                            n3 = (Integer)this.job.computeResult();
                            bl = true;
                        }
                    }
                    catch (ResultNotReadyException resultNotReadyException) {
                    }
                    catch (JobNotStartedException jobNotStartedException) {
                    }
                    catch (JobException jobException) {
                        // empty catch block
                    }
                    if (bl) break;
                }
                default: {
                    throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(n3));
                }
            }
            clientLog.invalidate();
        }
        catch (RuntimeException runtimeException) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw runtimeException;
            transactionsLogger.log(Level.FINEST, "Problem committing transaction", runtimeException);
            throw runtimeException;
        }
        catch (LogException logException) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw new CannotCommitException("Unable to log");
            transactionsLogger.log(Level.FINEST, "Problem persisting transaction", logException);
            throw new CannotCommitException("Unable to log");
        }
        if (!operationsLogger.isLoggable(Level.FINER)) return;
        operationsLogger.exiting(TxnManagerTransaction.class.getName(), "commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(long l) throws CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "abort", new Long(l));
        }
        long l2 = System.currentTimeMillis();
        try {
            Vector vector = this.parthandles();
            if (vector == null) {
                if (this.modifyTxnState(6)) {
                    return;
                }
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            Enumeration enumeration = vector.elements();
            int n = vector.size();
            Object[] objectArray = new ParticipantHandle[n];
            vector.copyInto(objectArray);
            ClientLog clientLog = this.logmgr.logFor(this.str.id);
            if (this.modifyTxnState(6)) {
                clientLog.write(new AbortRecord((ParticipantHandle[])objectArray));
                Object object = this.jobLock;
                synchronized (object) {
                    if (!(this.job instanceof AbortJob)) {
                        if (this.job != null) {
                            this.job.stop();
                        }
                        this.job = new AbortJob((Transaction)this.str, this.threadpool, this.wm, clientLog, (ParticipantHandle[])objectArray);
                        this.job.scheduleTasks();
                    }
                }
            } else {
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            Integer n2 = new Integer(1);
            boolean bl = false;
            long l5 = l - l4;
            try {
                Object object = this.jobLock;
                synchronized (object) {
                    if (l5 <= 0L || !this.job.isCompleted(l5)) {
                        this.settler.noteUnsettledTxn(this.str.id);
                        throw new TimeoutExpiredException("timeout expired", false);
                    }
                    n2 = (Integer)this.job.computeResult();
                    bl = true;
                }
            }
            catch (ResultNotReadyException resultNotReadyException) {
            }
            catch (JobNotStartedException jobNotStartedException) {
            }
            catch (JobException jobException) {
                this.settler.noteUnsettledTxn(this.str.id);
                throw new TimeoutExpiredException("timeout expired", false);
            }
            if (!bl) {
                throw new InternalManagerException("TxnManagerTransaction: abort: AbortJob got bad state: " + TxnConstants.getName(n2));
            }
            clientLog.invalidate();
        }
        catch (RuntimeException runtimeException) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem aborting transaction", runtimeException);
            }
            throw new InternalManagerException("TxnManagerTransaction: abort: fatal error");
        }
        catch (LogException logException) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem persisting transaction", logException);
            }
            throw new CannotAbortException("Unable to log");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "abort");
        }
    }

    public Transaction getTransaction() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getTransaction");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getTransaction", this.str);
        }
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiration() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getExpiration");
        }
        Object object = this.leaseLock;
        synchronized (object) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getExpiration", new Date(this.expires));
            }
            return this.expires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(long l) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "setExpiration", new Date(l));
        }
        Object object = this.leaseLock;
        synchronized (object) {
            this.expires = l;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "setExpiration");
        }
    }

    public Uuid getCookie() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getCookie");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getCookie", this.uuid);
        }
        return this.uuid;
    }

    private void doAbort(long l) {
        block8: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(TxnManagerTransaction.class.getName(), "doAbort", new Long(l));
            }
            try {
                this.str.abort(l);
            }
            catch (RemoteException remoteException) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", remoteException);
                }
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", timeoutExpiredException);
                }
            }
            catch (TransactionException transactionException) {
                if (!transactionsLogger.isLoggable(Levels.HANDLED)) break block8;
                transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", transactionException);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "doAbort");
        }
    }

    synchronized boolean ensureCurrent() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "ensureCurrent");
        }
        long l = System.currentTimeMillis();
        boolean bl = false;
        long l2 = this.getExpiration();
        if (l2 > l) {
            bl = true;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "ensureCurrent", new Boolean(bl));
        }
        return bl;
    }

    private Vector parthandles() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "parthandles");
        }
        if (this.parts == null || this.parts.size() == 0) {
            return null;
        }
        Vector vector = new Vector(this.parts);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved {0} participants", new Integer(vector.size()));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "parthandles");
        }
        return vector;
    }

    void restoreTransientState(ProxyPreparer proxyPreparer) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
        if (this.parts == null || this.parts.size() == 0) {
            return;
        }
        ParticipantHandle[] participantHandleArray = this.parts.toArray(new ParticipantHandle[this.parts.size()]);
        for (int i = 0; i < participantHandleArray.length; ++i) {
            participantHandleArray[i].restoreTransientState(proxyPreparer);
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Restored transient state for {0}", participantHandleArray[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
    }
}

