/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium.console;

import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsoleHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;

public class FileConsoleHandler
implements JavaScriptConsoleHandler {
    private final Writer fFileWriter;
    private final Timer fTimer;

    public FileConsoleHandler(File file) throws IOException {
        this.fFileWriter = new BufferedWriter(new FileWriter(file));
        this.fTimer = new Timer(true);
        this.fTimer.schedule((TimerTask)new FlushTask(), 2000L, 2000L);
    }

    public FileConsoleHandler(String string) throws IOException {
        this(new File(string));
    }

    @Override
    public void log(String string) {
        try {
            this.fFileWriter.write(string + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        this.fTimer.cancel();
        try {
            this.fFileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void settingsChanged() {
    }

    private class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            try {
                FileConsoleHandler.this.fFileWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

