/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse;

import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse.MouseStreamHandler;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MouseStream
implements Subscriber {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("mouse stream");
            thread.setDaemon(true);
            return thread;
        }
    });
    public static final int HOVERING = 1;
    public static final int CLICKING = 2;
    public static final int DOUBLE_CLICKING = 3;
    public static final int POSSIBLE_DOUBLE_CLICK = 4;
    public static final int MOVING = 5;
    public static final int DRAGGING = 6;
    public static final int NO_BUTTON = 0;
    public static final int LEFT_BUTTON = 1;
    public static final int MIDDLE_BUTTON = 2;
    public static final int RIGHT_BUTTON = 4;
    public static final int NO_KEY = 0;
    public static final int SHIFT_KEY = 1;
    public static final int CTRL_KEY = 2;
    public static final int ALT_KEY = 4;
    public static final int META_KEY = 8;
    private static final int CLICK_TOLERANCE = 3;
    private static final int DOUBLE_CLICK_TIMEOUT = 300;
    private static final int DRAGGING_TIMEOUT = 60000;
    private static final int MOVING_TIMEOUT = 300;
    private String channel;
    private MessageService messageService;
    private MouseStreamHandler handler = null;
    private int state = 1;
    private int buttons = 0;
    private int lastButtons = 0;
    private int modifiers = 0;
    private Point location = null;
    private Point lastLocation = null;
    private ScheduledFuture<?> pendingTimeout = null;

    public MouseStream(String channel) {
        this(channel, MessageServiceFactory.getMessageService());
    }

    public MouseStream(String channel, MessageService messageService) {
        this.channel = channel;
        this.messageService = messageService;
    }

    public void start() {
        this.messageService.subscribe(this.channel + "/*", (Subscriber)this);
    }

    public void stop() {
        this.messageService.unsubscribe(this.channel + "/*", (Subscriber)this);
    }

    public void setMouseStreamListener(MouseStreamHandler handler) {
        this.handler = handler;
    }

    public String getChannel() {
        return this.channel;
    }

    public Map<String, Object> getCursor() {
        return this.handler.getCursor();
    }

    public void handle(Message message) {
        Map data = (Map)message.getData();
        int x = (int)Math.floor((Double)data.get("x"));
        int y = (int)Math.floor((Double)data.get("y"));
        int zoomData = 0;
        Point location = new Point(x, y);
        if (data.containsKey("zoom")) {
            zoomData = (int)Math.floor((Double)data.get("zoom"));
        }
        int newButtons = 0;
        if (((Map)message.getData()).get("buttons") != null) {
            Map buttonsData = (Map)data.get("buttons");
            if (buttonsData.get("left") != null && buttonsData.get("left").equals(true)) {
                newButtons |= 1;
            }
            if (buttonsData.get("middle") != null && buttonsData.get("middle").equals(true)) {
                newButtons |= 2;
            }
            if (buttonsData.get("right") != null && buttonsData.get("right").equals(true)) {
                newButtons |= 4;
            }
        }
        int newModifiers = 0;
        if (((Map)message.getData()).get("modifiers") != null) {
            Map modifiersData = (Map)data.get("modifiers");
            if (modifiersData.get("altKey") != null && modifiersData.get("altKey").equals(true)) {
                newModifiers |= 4;
            }
            if (modifiersData.get("ctrlKey") != null && modifiersData.get("ctrlKey").equals(true)) {
                newModifiers |= 2;
            }
            if (modifiersData.get("shiftKey") != null && modifiersData.get("shiftKey").equals(true)) {
                newModifiers |= 1;
            }
            if (modifiersData.get("metaKey") != null && modifiersData.get("metaKey").equals(true)) {
                newModifiers |= 8;
            }
        }
        if (message.getChannel().endsWith("pressed")) {
            newButtons = this.buttons | newButtons;
            this.setButtons(newButtons);
            this.pressed(location, newModifiers, newButtons);
        } else if (message.getChannel().endsWith("released")) {
            newButtons = this.buttons == 1 || this.buttons == 2 || this.buttons == 4 ? 0 : this.buttons ^ newButtons;
            this.released(location, newModifiers, newButtons);
        } else if (message.getChannel().endsWith("moved")) {
            this.moved(location, newModifiers, newButtons);
        } else if (message.getChannel().endsWith("scroll")) {
            this.scroll(location, zoomData);
        }
        HashMap<String, Map> response = new HashMap<String, Map>();
        if (this.handler != null) {
            response.put("cursor", this.handler.getCursor());
        }
        this.messageService.publish(this.getChannel() + "/ready", response);
    }

    public void scroll(Point newLocation, int zoom) {
        this.emitScrolled(zoom);
    }

    public void pressed(Point newLocation, int newModifiers, int newButtons) {
        this.setLocation(newLocation);
        this.modifiers = newModifiers;
        this.setButtons(newButtons);
        int clickCount = 1;
        switch (this.state) {
            case 1: {
                this.changeState(2);
                break;
            }
            case 3: {
                this.changeState(2);
                break;
            }
            case 4: {
                clickCount = 2;
                this.changeState(3);
                break;
            }
            case 5: 
            case 6: {
                this.changeState(2);
            }
        }
        this.emitPressed(clickCount);
    }

    public void released(Point newLocation, int newModifiers, int newButtons) {
        this.setLocation(newLocation);
        this.modifiers = newModifiers;
        this.setButtons(newButtons);
        switch (this.state) {
            case 1: 
            case 4: {
                this.emitReleased(1);
                this.changeState(1);
                break;
            }
            case 3: {
                this.emitReleased(2);
                this.emitClicked(2);
                if (this.buttons != 0) break;
                this.changeState(1);
                break;
            }
            case 2: {
                this.emitReleased(1);
                this.emitClicked(1);
                if (this.buttons != 0) break;
                this.changeState(4);
                break;
            }
            case 6: {
                this.emitReleased(1);
                this.changeState(5);
            }
        }
    }

    public void moved(Point newLocation, int newModifiers, int newButtons) {
        this.setLocation(newLocation);
        this.modifiers = newModifiers;
        this.setButtons(newButtons);
        switch (this.state) {
            case 5: {
                this.emitMoved();
                if (this.buttons <= 0) break;
                this.emitPressed(1);
                this.changeState(6);
                break;
            }
            case 6: {
                this.emitDragged();
                if (this.buttons != 0) break;
                this.emitReleased(1);
                this.changeState(5);
                break;
            }
            case 1: {
                this.changeState(5);
                this.emitMoved();
                break;
            }
            case 4: {
                if (this.locationChangedBy(3)) {
                    this.changeState(5);
                    this.emitMoved();
                    break;
                }
                this.location = this.lastLocation;
                break;
            }
            case 2: 
            case 3: {
                if (this.locationChangedBy(3)) {
                    this.changeState(6);
                    this.emitDragged();
                    break;
                }
                this.location = this.lastLocation;
            }
        }
    }

    private boolean locationChangedBy(int clickTolerance) {
        return this.lastLocation == null || Math.pow(this.location.getX() - this.lastLocation.getX(), 2.0) + Math.pow(this.location.getY() - this.lastLocation.getY(), 2.0) > Math.pow(clickTolerance, 2.0);
    }

    private void timeout() {
        switch (this.state) {
            case 6: {
                this.setButtons(0);
                this.emitReleased(1);
                this.changeState(1);
                break;
            }
            case 5: {
                this.changeState(1);
                break;
            }
            case 4: {
                this.changeState(1);
            }
        }
    }

    private void changeState(int newState) {
        this.state = newState;
        this.clearTimeout();
        switch (this.state) {
            case 6: {
                this.setTimeout(60000);
                break;
            }
            case 4: {
                this.setTimeout(300);
                break;
            }
            case 5: {
                this.setTimeout(300);
            }
        }
    }

    private void emitPressed(int clickCount) {
        this.handler.mousePressed(this.location.x, this.location.y, this.modifiers, this.buttons, clickCount);
    }

    private void emitReleased(int clickCount) {
        this.handler.mouseReleased(this.location.x, this.location.y, this.modifiers, this.lastButtons, clickCount);
    }

    private void emitClicked(int clickCount) {
        this.handler.mouseClicked(this.location.x, this.location.y, this.modifiers, this.lastButtons, clickCount);
    }

    private void emitDragged() {
        this.handler.mouseDragged(this.location.x, this.location.y, this.modifiers, this.buttons);
    }

    private void emitMoved() {
        this.handler.mouseMoved(this.location.x, this.location.y, this.modifiers);
    }

    private void emitScrolled(int zoom) {
        this.handler.mouseScrolled(this.location.x, this.location.y, zoom);
    }

    private void clearTimeout() {
        if (this.pendingTimeout != null && !this.pendingTimeout.isDone() && !this.pendingTimeout.isCancelled()) {
            this.pendingTimeout.cancel(false);
        }
    }

    private void setTimeout(int ms) {
        this.pendingTimeout = executor.schedule(new Runnable(){

            @Override
            public void run() {
                MouseStream.this.timeout();
            }
        }, (long)ms, TimeUnit.MILLISECONDS);
    }

    private void setButtons(int buttons) {
        this.lastButtons = this.buttons;
        this.buttons = buttons;
    }

    private void setLocation(Point location) {
        if (this.lastLocation != location) {
            this.lastLocation = this.location;
            this.location = location;
        }
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    int getButtons() {
        return this.buttons;
    }

    int getModifiers() {
        return this.modifiers;
    }
}

