/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers;

import com.mathworks.hg.peer.GraphicsImageGrabber;
import com.mathworks.hg.peer.GraphicsImageListener;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.AbstractPixelHandler;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClient;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.SwingUtilities;

public class JavaSceneServerGLCanvasHandler2
extends AbstractPixelHandler
implements GraphicsImageListener {
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final boolean NEEDS_FORCED_REPAINT;
    private static boolean loggingEnabled;
    private static int copyCount;
    private static int totalImageUpdates;
    private GraphicsImageGrabber source;
    private BufferedImage latestImage;
    private ScheduledFuture lastRepaint;
    private boolean forcedRepaint;

    public static void printStatistics() {
        System.out.println("Copied images: " + copyCount);
        System.out.println("Total image updates: " + totalImageUpdates);
    }

    public static void resetStatistics() {
        copyCount = 0;
        totalImageUpdates = 0;
    }

    public static void setLogging(boolean enabled) {
        loggingEnabled = enabled;
    }

    @Override
    protected void addRepaintListener() {
        this.source = new GraphicsImageGrabber((GLAutoDrawable)this.getComponent());
        this.source.setGraphicsImageListener(this);
        this.source.setEnabled(true);
    }

    @Override
    protected void removeRepaintListener() {
        this.source.setEnabled(false);
        this.source.removeGraphicsImageListener();
    }

    @Override
    public void acceptImage(BufferedImage image) {
        if (loggingEnabled) {
            System.out.println("New image from HG is ready: " + image.getWidth() + "x" + image.getHeight());
        }
        this.latestImage = image;
        this.imageUpdated();
        if (NEEDS_FORCED_REPAINT) {
            this.forceRepaint();
        }
    }

    @Override
    public void clientStateChange(final ImageStreamClient.State state) {
        this.invokeLaterEDT(new Runnable(){

            @Override
            public void run() {
                JavaSceneServerGLCanvasHandler2.this.source.setEnabled(state == ImageStreamClient.State.READY);
            }
        });
    }

    @Override
    protected BufferedImage getComponentImage(final BufferedImage image) {
        final BufferedImage[] newImage = new BufferedImage[1];
        if (this.latestImage == null) {
            return image;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (loggingEnabled) {
                        System.out.print("Updating MGG copy of image from HG. ");
                        if (image != null) {
                            System.out.print("old = " + image.getWidth() + "x" + image.getHeight() + " ");
                        }
                        if (JavaSceneServerGLCanvasHandler2.this.latestImage != null) {
                            System.out.print("new = " + JavaSceneServerGLCanvasHandler2.this.latestImage.getWidth() + "x" + JavaSceneServerGLCanvasHandler2.this.latestImage.getHeight());
                        }
                        System.out.print("\n");
                    }
                    totalImageUpdates += 1;
                    Component comp = JavaSceneServerGLCanvasHandler2.this.getComponent();
                    if (comp != null && JavaSceneServerGLCanvasHandler2.this.latestImage != null && JavaSceneServerGLCanvasHandler2.this.latestImage.getWidth() > 0 && JavaSceneServerGLCanvasHandler2.this.latestImage.getHeight() > 0) {
                        if (image != null && image.getWidth() == JavaSceneServerGLCanvasHandler2.this.latestImage.getWidth() && image.getHeight() == JavaSceneServerGLCanvasHandler2.this.latestImage.getHeight()) {
                            try {
                                image.getGraphics().drawImage(JavaSceneServerGLCanvasHandler2.this.latestImage, 0, 0, JavaSceneServerGLCanvasHandler2.this.latestImage.getWidth(), JavaSceneServerGLCanvasHandler2.this.latestImage.getHeight(), null);
                            }
                            catch (Exception e) {
                                newImage[0] = JavaSceneServerGLCanvasHandler2.this.copyLatestImageWithGC();
                            }
                        } else {
                            newImage[0] = JavaSceneServerGLCanvasHandler2.this.copyLatestImageWithGC();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newImage[0] != null) {
            return newImage[0];
        }
        return image;
    }

    private BufferedImage copyLatestImageWithGC() {
        if (loggingEnabled) {
            System.out.println("Copying HG image");
        }
        ++copyCount;
        try {
            return this.copyLatestImage();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            System.runFinalization();
            System.gc();
            if (loggingEnabled) {
                System.out.println("Ran out of JVM memory, retrying after forcing GC");
            }
            return this.copyLatestImage();
        }
    }

    private BufferedImage copyLatestImage() {
        ColorModel cm = this.latestImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = this.latestImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private void forceRepaint() {
        if (this.lastRepaint != null) {
            this.lastRepaint.cancel(false);
        }
        if (!this.forcedRepaint) {
            this.lastRepaint = scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JavaSceneServerGLCanvasHandler2.this.forcedRepaint = true;
                            JavaSceneServerGLCanvasHandler2.this.component.repaint();
                        }
                    });
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
        this.forcedRepaint = false;
    }

    static {
        copyCount = 0;
        totalImageUpdates = 0;
        boolean isMGGVersionOfClass = false;
        try {
            GraphicsImageGrabber.class.getField("MGG_CLASS");
            isMGGVersionOfClass = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        NEEDS_FORCED_REPAINT = isMGGVersionOfClass;
    }
}

