/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.hg.peer.utils.MultilineLabel;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.matlabserver.jcp.utils.MouseHandler;
import com.mathworks.matlabserver.jcp.utils.ObservableRepaintManager;
import com.mathworks.matlabserver.jcp.utils.RepaintListener;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

public class MultilineLabelHandler
extends AbstractTextComponentHandler {
    private RepaintListener repaintListener = new RepaintListener(){

        @Override
        public void componentRepainted(JComponent component) {
            MultilineLabelHandler.this.markDirty();
        }
    };
    private Observer clickObserver;
    private MouseHandler mouseHandler;

    @Override
    public String getType() {
        return "Label";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.mouseHandler = new MouseHandler(component);
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        ObservableRepaintManager.getInstance().addRepaintListener((JComponent)this.component, this.repaintListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        ObservableRepaintManager.getInstance().removeRepaintListener((JComponent)this.component, this.repaintListener);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.clickObserver = new Observer(){

            public void handle(Event event) {
                MultilineLabelHandler.this.invokeLaterEDT(new Runnable(){

                    @Override
                    public void run() {
                        MultilineLabelHandler.this.mouseHandler.click(new Point(MultilineLabelHandler.this.component.getWidth() / 2, MultilineLabelHandler.this.component.getHeight() / 2));
                    }
                });
            }
        };
        this.peerNode.addPeerEventListener("clicked", this.clickObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removePeerEventListener("clicked", this.clickObserver);
    }

    @Override
    public Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        properties.put("text", this.extractTextFromLabelComponent((MultilineLabel)component));
        properties.put("lineHeight", this.extractLineAttributesFromLabelComponent((MultilineLabel)component));
        FontMetrics fm = component.getFontMetrics(component.getFont());
        properties.put("textWidth", fm.stringWidth(properties.get("text").toString()));
        return properties;
    }

    protected String extractTextFromLabelComponent(MultilineLabel multilineLabel) {
        String labelText = "";
        try {
            Field privateStringField = MultilineLabel.class.getDeclaredField("fLines");
            privateStringField.setAccessible(true);
            Object[] lineValues = (String[])privateStringField.get(multilineLabel);
            labelText = StringUtils.join((Object[])lineValues, (String)"\n");
        }
        catch (IllegalAccessException | NoSuchFieldException nse) {
            nse.printStackTrace();
        }
        return labelText;
    }

    protected int extractLineAttributesFromLabelComponent(MultilineLabel multilineLabel) {
        int lineHeight = 10;
        try {
            Field privatefLineHeightField = MultilineLabel.class.getDeclaredField("fLineHeight");
            privatefLineHeightField.setAccessible(true);
            lineHeight = (Integer)privatefLineHeightField.get(multilineLabel);
        }
        catch (IllegalAccessException | NoSuchFieldException nse) {
            nse.printStackTrace();
        }
        return lineHeight;
    }
}

