/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.utils.TextUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public abstract class AbstractTextComponentHandler
extends AbstractComponentHandler {
    private static final Map<Integer, String> ALIGNMENT_MAP = new HashMap<Integer, String>();
    private static final Map<Integer, String> VERTICAL_ALIGNMENT_MAP = new HashMap<Integer, String>();
    private static final Map<Integer, String> DOCUMENT_ALIGNMENT_MAP = new HashMap<Integer, String>();

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        properties.putAll(this.doGetTextProperties(component));
        return properties;
    }

    protected Map<String, Object> doGetTextProperties(Component component) {
        ConcurrentHashMap<String, Object> properties;
        block10: {
            properties = new ConcurrentHashMap<String, Object>();
            TextUtils.setFontProperties(component, properties);
            try {
                Method getText = component.getClass().getMethod("getText", new Class[0]);
                String text = (String)getText.invoke((Object)component, new Object[0]);
                if (text == null) {
                    text = "";
                }
                if (text.equals("Create New Datatip             Alt-Click")) {
                    text = "Create New Datatip";
                } else if (text.equals("Delete Current Datatip            Delete")) {
                    text = "Delete Current Datatip";
                }
                properties.put("text", text);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                Method getHorizontalAlignment = component.getClass().getMethod("getHorizontalAlignment", new Class[0]);
                int horizontalAlignment = (Integer)getHorizontalAlignment.invoke((Object)component, new Object[0]);
                properties.put("horizontalAlignment", ALIGNMENT_MAP.get(horizontalAlignment));
            }
            catch (Exception ignore2) {
                Style logicalStyle;
                if (!(component instanceof JTextPane) || (logicalStyle = ((JTextPane)component).getStyledDocument().getLogicalStyle(0)) == null) break block10;
                String style = DOCUMENT_ALIGNMENT_MAP.get(StyleConstants.getAlignment(logicalStyle));
                properties.put("horizontalAlignment", style);
            }
        }
        try {
            Method getVerticalAlignment = component.getClass().getMethod("getVerticalAlignment", new Class[0]);
            int verticalAlignment = (Integer)getVerticalAlignment.invoke((Object)component, new Object[0]);
            properties.put("verticalAlignment", VERTICAL_ALIGNMENT_MAP.get(verticalAlignment));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    static {
        ALIGNMENT_MAP.put(0, "center");
        ALIGNMENT_MAP.put(2, "left");
        ALIGNMENT_MAP.put(4, "right");
        ALIGNMENT_MAP.put(10, "left");
        ALIGNMENT_MAP.put(11, "right");
        VERTICAL_ALIGNMENT_MAP.put(0, "middle");
        VERTICAL_ALIGNMENT_MAP.put(1, "top");
        VERTICAL_ALIGNMENT_MAP.put(3, "bottom");
        VERTICAL_ALIGNMENT_MAP.put(10, "top");
        VERTICAL_ALIGNMENT_MAP.put(11, "bottom");
        DOCUMENT_ALIGNMENT_MAP.put(0, "left");
        DOCUMENT_ALIGNMENT_MAP.put(1, "center");
        DOCUMENT_ALIGNMENT_MAP.put(2, "right");
        DOCUMENT_ALIGNMENT_MAP.put(3, "center");
    }
}

