/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.DefaultCellHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import com.mathworks.mlwidgets.inspector.JidePropertyItem;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class InspectorJPanelHandler<R>
extends DefaultCellHandler<R, JPanel> {
    public InspectorJPanelHandler(String type) {
        super(type);
    }

    @Override
    public Map<String, Object> getProperties(JComponent component, R renderer, JPanel cell) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", this.type);
        return props;
    }

    @Override
    public Object getCellValue(JComponent component, R renderer, JPanel cell, Object value) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        HashMap<String, Object> valueProps = new HashMap<String, Object>();
        HashMap<String, Object> renderProps = new HashMap<String, Object>();
        props.put("renderer", renderProps);
        props.put("value", valueProps);
        JidePropertyItem item = this.getJidePropertyItem(renderer);
        if (item != null && item.getItemNode().getPropertyCell().getClass().getName().contains("PropertyCellEnum")) {
            try {
                PropertyCell propertyCell = item.getItemNode().getPropertyCell();
                Method getEditor = propertyCell.getClass().getSuperclass().getDeclaredMethod("getEditor", new Class[0]);
                getEditor.setAccessible(true);
                renderProps.put("type", "list");
                renderProps.put("listValues", ((PropertyEditor)getEditor.invoke((Object)propertyCell, new Object[0])).getTags());
                renderProps.put("enabled", cell.getComponentCount() == 2);
                props.put("value", ((PropertyEditor)getEditor.invoke((Object)propertyCell, new Object[0])).getAsText());
            }
            catch (Exception ignore) {}
        } else {
            Component[] components;
            renderProps.put("type", "prop");
            this.setProps(valueProps, "left", null);
            this.setProps(valueProps, "middle", null);
            this.setProps(valueProps, "right", null);
            if (item != null && item.isEditable() && item.getItemNode().getEditorComponent() instanceof JPanel) {
                cell = (JPanel)item.getItemNode().getEditorComponent();
            }
            int w = ((JTable)component).getColumnModel().getColumn(1).getWidth();
            int h = ((JTable)component).getRowHeight();
            cell.setBounds(cell.getX(), cell.getY(), w, h);
            cell.validate();
            cell.doLayout();
            for (Component c : components = cell.getComponents()) {
                int x = c.getWidth();
                if (x == 30) {
                    this.setProps(valueProps, "left", c);
                    continue;
                }
                if (x == 16) {
                    this.setProps(valueProps, "right", c);
                    continue;
                }
                this.setProps(valueProps, "middle", c);
            }
        }
        return props;
    }

    private JidePropertyItem getJidePropertyItem(Object renderer) {
        try {
            Field enclosingField = renderer.getClass().getDeclaredField("this$0");
            enclosingField.setAccessible(true);
            return (JidePropertyItem)enclosingField.get(renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setProps(Map<String, Object> props, String prefix, Component component) {
        if (component != null) {
            if (component instanceof JPanel) {
                this.setPanelProps(props, prefix, (JPanel)component);
            } else if (component instanceof JButton) {
                this.setButtonProps(props, prefix, (JButton)component);
            } else if (component instanceof JLabel) {
                this.setLabelProps(props, prefix, (JLabel)component);
            } else if (component instanceof JTextField) {
                this.setTextProps(props, prefix, (JTextField)component);
            } else {
                this.setFallbackProps(props, prefix, component);
            }
        } else {
            props.put(prefix + "Type", "space");
        }
    }

    private void setPanelProps(Map<String, Object> props, String prefix, JPanel component) {
        if (component.getComponentCount() == 1) {
            this.setProps(props, prefix, component.getComponent(0));
        } else if (component.getComponentCount() == 2) {
            this.setFallbackProps(props, prefix, component);
        } else {
            props.put(prefix + "Type", "space");
        }
    }

    private void setLabelProps(Map<String, Object> props, String prefix, JLabel component) {
        if (component.getText() != null && component.getText().length() > 0 || component.getIcon() != null) {
            props.put(prefix + "Type", "label");
            if (component.getText() != null && component.getText().length() > 0) {
                props.put(prefix + "Text", component.getText());
            }
            if (component.getIcon() != null) {
                props.put(prefix + "Icon", this.convertIcon(component.getIcon(), component));
            }
        } else {
            this.setFallbackProps(props, prefix, component);
        }
    }

    private void setTextProps(Map<String, Object> props, String prefix, JTextField component) {
        props.put(prefix + "Type", "text");
        props.put(prefix + "Text", component.getText());
    }

    private void setButtonProps(Map<String, Object> props, String prefix, JButton component) {
        props.put(prefix + "Type", "button");
        if (component.getText().length() > 0) {
            props.put(prefix + "Text", component.getText());
        }
        if (component.getIcon() != null) {
            props.put(prefix + "Icon", this.convertIcon(component.getIcon(), component));
        }
    }

    private void setFallbackProps(Map<String, Object> props, String prefix, Component component) {
        props.put(prefix + "Type", "label");
        props.put(prefix + "Icon", ImageUtils.getImageFromComponent(component));
    }

    private Object convertIcon(Icon icon, Component component) {
        if (icon instanceof ImageIcon && ((ImageIcon)icon).getDescription() != null) {
            if (((ImageIcon)icon).getDescription().contains("ui_edit.gif")) {
                return "edit";
            }
            if (((ImageIcon)icon).getDescription().contains("ui_dropdown.gif")) {
                return "dropdown";
            }
        }
        return ImageUtils.getImageFromIcon(icon, component);
    }

    @Override
    public boolean setCellValue(JComponent component, R editor, JPanel cell, Object value) {
        JidePropertyItem item = this.getJidePropertyItem(editor);
        if (item != null && item.getItemNode().getPropertyCell().getClass().getName().contains("PropertyCellEnum")) {
            try {
                PropertyCell propertyCell = item.getItemNode().getPropertyCell();
                Method getEditor = propertyCell.getClass().getSuperclass().getDeclaredMethod("getEditor", new Class[0]);
                getEditor.setAccessible(true);
                PropertyEditor propertyEditor = (PropertyEditor)getEditor.invoke((Object)propertyCell, new Object[0]);
                propertyEditor.setAsText((String)((Map)value).get("value"));
            }
            catch (Exception ignore) {}
        } else if (item != null && value instanceof Map && ((Map)value).containsKey("value")) {
            for (Component c : cell.getComponents()) {
                if (!(c instanceof JTextField)) continue;
                c.requestFocus();
                ((JTextField)c).setText(((Map)((Map)value).get("value")).get("middleText").toString());
                ((JTextField)c).postActionEvent();
                FocusManager.getCurrentManager().focusNextComponent();
            }
        }
        return true;
    }

    @Override
    public boolean dispatchCellEvent(JComponent component, R editor, JPanel cell, Map<String, Object> data) {
        this.findAndClickButton(cell);
        return true;
    }

    private boolean findAndClickButton(Component component) {
        if (component instanceof JButton) {
            ((JButton)component).doClick(50);
            return true;
        }
        if (component instanceof JComponent) {
            for (Component child : ((JComponent)component).getComponents()) {
                if (!this.findAndClickButton(child)) continue;
                return true;
            }
        }
        return false;
    }
}

