/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.DefaultCellHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import com.mathworks.matlabserver.jcp.utils.TextUtils;
import com.mathworks.page.plottool.plotbrowser.LegendIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconPanelHandler<R>
extends DefaultCellHandler<R, JPanel> {
    public IconPanelHandler(String type) {
        super(type);
    }

    @Override
    public Map<String, Object> getProperties(JComponent component, R renderer, JPanel cell) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", this.type);
        String alignment = this.getAlignment(renderer, cell);
        if (alignment.length() > 0) {
            props.put("textAlign", alignment);
        }
        return props;
    }

    @Override
    public Object getCellValue(JComponent component, R renderer, JPanel cell, Object value) {
        BufferedImage icon = this.getIcon(cell);
        String text = this.getText(cell);
        if (icon != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("value", text);
            props.put("icon", icon);
            return props;
        }
        return text;
    }

    protected String getText(Component cell) {
        if (cell == null) {
            return "";
        }
        if (cell instanceof JLabel && ((JLabel)cell).getText() != null && ((JLabel)cell).getText().length() > 0 && cell.isVisible()) {
            return ((JLabel)cell).getText();
        }
        if (cell instanceof Container) {
            for (Component child : ((Container)cell).getComponents()) {
                String text = this.getText(child);
                if (text.length() <= 0) continue;
                return text;
            }
        }
        return "";
    }

    protected BufferedImage getIcon(Component cell) {
        if (cell == null) {
            return null;
        }
        if (cell instanceof JLabel && ((JLabel)cell).getIcon() != null && cell.isVisible()) {
            return ImageUtils.getImageFromIcon(((JLabel)cell).getIcon(), cell);
        }
        if (cell instanceof LegendIcon && cell.isVisible()) {
            return ImageUtils.getImageFromComponent(cell);
        }
        if (cell instanceof Container) {
            for (Component child : ((Container)cell).getComponents()) {
                BufferedImage icon = this.getIcon(child);
                if (icon == null) continue;
                return icon;
            }
        }
        return null;
    }

    protected String getAlignment(R renderer, JPanel cell) {
        try {
            Field alignmentField = renderer.getClass().getDeclaredField("fAlignment");
            alignmentField.setAccessible(true);
            return TextUtils.getAlignmentText((Integer)alignmentField.get(renderer));
        }
        catch (Exception ignore) {
            return this.getAlignment(cell);
        }
    }

    protected String getAlignment(Component cell) {
        if (cell == null) {
            return "";
        }
        if (cell instanceof JLabel) {
            return TextUtils.getAlignmentText(((JLabel)cell).getHorizontalAlignment());
        }
        if (cell instanceof Container) {
            for (Component child : ((Container)cell).getComponents()) {
                String alignment = this.getAlignment(child);
                if (alignment.length() <= 0) continue;
                return alignment;
            }
        }
        return "";
    }
}

