/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.ListDataModelHandler;
import java.util.Arrays;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;

public class PathBrowserListDataModelHandler
extends ListDataModelHandler {
    private int[] rowMap;
    private static String userHomePrefix = "/users";

    public static void setUserHomePrefix(String prefix) {
        userHomePrefix = prefix;
    }

    public PathBrowserListDataModelHandler(JList list) {
        super(list);
    }

    private void updateRowMap() {
        int[] newRowMap = new int[this.dataModel.getSize()];
        int j = 0;
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            String folder = (String)this.dataModel.getElementAt(i);
            if (!folder.startsWith(userHomePrefix)) continue;
            newRowMap[j] = i;
            ++j;
        }
        this.rowMap = Arrays.copyOf(newRowMap, j);
    }

    @Override
    public int convertClientRowToListRow(int row) {
        if (this.rowMap == null) {
            this.updateRowMap();
        }
        if (row >= 0 && row < this.rowMap.length) {
            return this.rowMap[row];
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this.rowMap == null) {
            this.updateRowMap();
        }
        return this.rowMap.length;
    }

    @Override
    public Object getValueAt(int row) {
        if (row >= 0 && row < this.rowMap.length) {
            return super.getValueAt(this.rowMap[row]);
        }
        return null;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateRowMap();
        this.markDirty();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateRowMap();
        this.markDirty();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateRowMap();
        this.markDirty();
    }
}

