/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp;

import com.google.gson.ImageStreamBufferedImageConverter;
import com.mathworks.matlabserver.common.util.CalledFromMATLAB;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerVisitor;
import com.mathworks.matlabserver.jcp.handlers.RootHandler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.handlers.menuHandlers.JMenuHandler;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClient;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClientJSONConverter;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.StreamBufferedImage;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse.MouseStream;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse.MouseStreamClientJSONConverter;
import com.mathworks.matlabserver.jcp.utils.ObservableRepaintManager;
import com.mathworks.matlabserver.jcp.utils.WindowUtils;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.json.JSONCustomConverters;
import com.mathworks.messageservice.json.converters.JSONTypeConverter;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.RepaintManager;

public class GraphicsAndGuis {
    private static final String NAMESPACE = "/jcp";
    private static PeerModelManager manager;
    private static RootHandler rootHandler;
    private static boolean activated;
    private static boolean originalEditorDocked;
    private static boolean originalFiguresDocked;
    private static String originalKeySet;
    private static final Desktop matlabDesktop;
    private static KeyBindingManager keyManager;

    public static String getVersion() {
        String path = "/META-INF/maven/com.mathworks/mgg_server/pom.properties";
        InputStream stream = GraphicsAndGuis.class.getResourceAsStream(path);
        Properties props = new Properties();
        try {
            props.load(stream);
            return props.getProperty("version");
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    @CalledFromMATLAB
    public static void activate() {
        if (!activated) {
            if (matlabDesktop != null) {
                originalEditorDocked = MatlabDesktopServices.getDesktop().isGroupDocked("Editor");
                matlabDesktop.setGroupDocked("Editor", true);
                originalFiguresDocked = MatlabDesktopServices.getDesktop().isGroupDocked("Figures");
                matlabDesktop.setGroupDocked("Figures", false);
            }
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.osgi.framework.BundleActivator");
                keyManager = MatlabKeyBindings.getManager();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (keyManager != null) {
                originalKeySet = keyManager.getCurrentKeyBindingSet().getID();
                keyManager.setCurrentKeyBindingSet("Windows");
            }
            manager = PeerModelManagers.getInstance((String)NAMESPACE);
            rootHandler = new RootHandler(manager);
            rootHandler.start();
            manager.setSyncEnabled(true);
            try {
                MJFileChooserPerPlatform.setUseSwingDialog((boolean)true);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            System.setProperty("mathworks.WarnIfWrongThread", "false");
            RepaintManager.setCurrentManager(ObservableRepaintManager.getInstance());
            MessageService messageService = MessageServiceFactory.getMessageService();
            if (messageService instanceof JSONCustomConverters) {
                ((JSONCustomConverters)messageService).registerConverter(ImageStreamClient.class, "imageStream", (JSONTypeConverter)new ImageStreamClientJSONConverter());
                ((JSONCustomConverters)messageService).registerConverter(StreamBufferedImage.class, "streamImage", (JSONTypeConverter)new ImageStreamBufferedImageConverter());
                ((JSONCustomConverters)messageService).registerConverter(MouseStream.class, "mouseStream", (JSONTypeConverter)new MouseStreamClientJSONConverter());
            }
            activated = true;
        }
    }

    @CalledFromMATLAB
    public static void deactivate() {
        if (activated) {
            rootHandler.stop();
            manager.setSyncEnabled(false);
            RepaintManager.setCurrentManager(null);
            try {
                MJFileChooserPerPlatform.setUseSwingDialog((boolean)PlatformInfo.isXWindows());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (keyManager != null) {
                keyManager.setCurrentKeyBindingSet(originalKeySet);
            }
            if (matlabDesktop != null) {
                matlabDesktop.setGroupDocked("Editor", originalEditorDocked);
                matlabDesktop.setGroupDocked("Figures", originalFiguresDocked);
            }
            activated = false;
        }
    }

    @CalledFromMATLAB
    public static boolean isActivated() {
        return activated;
    }

    @CalledFromMATLAB
    public static void setImageDifferenceStrategy(String strategy) {
        ImageDifferencer.setStrategy((String)strategy);
    }

    @CalledFromMATLAB
    public static void forceDefaultUndocked(boolean undocked) {
        WindowUtils.forceDefaultUndocked(undocked);
    }

    @CalledFromMATLAB
    public static void setMenuFocusBypassed(boolean bypassed) {
        JMenuHandler.setMenuFocusBypass(bypassed);
    }

    @CalledFromMATLAB
    public static void forceMenuUpdate() {
        RootHandler.accept(new HandlerVisitor(){

            @Override
            public void visit(Handler handler) {
                if (handler instanceof JMenuHandler) {
                    ((JMenuHandler)handler).forceMenuUpdate();
                }
            }
        });
    }

    @CalledFromMATLAB
    public static void setFocusTrackingEnabled(boolean enabled) {
        AbstractComponentHandler.setFocusTrackingEnabled(enabled);
    }

    @CalledFromMATLAB
    public static boolean isFocusTrackingEnabled() {
        return AbstractComponentHandler.isFocusTrackingEnabled();
    }

    public static PeerModelManager getManager() {
        return manager;
    }

    static {
        activated = false;
        originalEditorDocked = false;
        originalFiguresDocked = true;
        matlabDesktop = MatlabDesktopServices.getDesktop();
    }
}

