/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.text.mcode;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.MatlabHyperlinkHandler;
import com.mathworks.mlwidgets.text.mcode.MLintPrefsHelper;
import com.mathworks.mlwidgets.text.mcode.MLintTableRow;
import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.TableCell;
import com.mathworks.mwswing.TableUtils;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.HTMLUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.LightButton;
import com.mathworks.widgets.LightScrollPane;
import com.mathworks.widgets.WidgetUtils;
import com.mathworks.widgets.glazedlists.GlazedTableSupport;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.ToolTipManager;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class MLintTable
extends MJTable {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.text.mcode.resources.RES_mcode");
    public static final String MLINT_CATEGORY_ENABLED_BUTTON_NAME = "MLintCategoryEnabledButton";
    private static final int BULLET_SIZE = UIManager.getFont("Table.font").getSize() % 2 == 0 ? UIManager.getFont("Table.font").getSize() - 1 : UIManager.getFont("Table.font").getSize();
    private final JPopupMenu fPopup = new MJPopupMenu();
    private MJMenuItem fEnablePopupMenuItem;
    private MJMenuItem fDisableMenuItem;
    private BalloonToolTip fTip;
    private static final TermMatcher REGULAR_TERM_MATCHER = new TermMatcher(){

        @Override
        public List<Integer> getMatches(String string, String string2) {
            Vector<Integer> vector = new Vector<Integer>();
            int n = string.indexOf(string2);
            while (n != -1) {
                vector.add(n);
                n = string.indexOf(string2, n + string2.length());
            }
            return vector;
        }
    };
    private static final TermMatcher HTML_TERM_MATCHER = new TermMatcher(){

        @Override
        public List<Integer> getMatches(String string, String string2) {
            return HTMLUtils.findMatchingInText((String)string, (String)string2);
        }
    };
    public static final int MODIFIED_COLUMN = 0;
    public static final int ENABLED_COLUMN = 1;
    public static final int SEVERITY_COLUMN = 2;
    public static final int MESSAGE_COLUMN = 3;
    public static final String NAME_BALLONTIP = "Preferences.MLintBalloonTip";
    private final TreeList<MLintTableRow> fTreeList;
    private final EventTableModel<MLintTableRow> fEventTableModel;
    private final MLintPrefsHelper fPrefsHelper;
    private GlazedTableSupport fSupport;
    private boolean fJustClicked;
    private String fSearchText;
    private TransformedList<MLintTableRow, MLintTableRow> fSwingList;
    private final ToolTipManager fToolTipManager = new ToolTipManager();
    private JViewport fViewport;

    public MLintTable(EventList<MLintTableRow> eventList, MLintPrefsHelper mLintPrefsHelper) {
        this.fPrefsHelper = mLintPrefsHelper;
        eventList.getReadWriteLock().writeLock().lock();
        this.fTreeList = this.buildTreeList(eventList);
        this.fEventTableModel = new EventTableModel(this.fTreeList, (TableFormat)new MLintProxyTableModel());
        eventList.getReadWriteLock().writeLock().unlock();
        this.setModel((TableModel)this.fEventTableModel);
        this.setSelectionModel((ListSelectionModel)new EventSelectionModel(this.fTreeList));
        this.setUpRendering();
        this.setRightSelectionEnabled(true);
        this.setRowSelectionAllowed(true);
        this.setTableHeader(null);
        this.setSelectionAppearanceReflectsFocus(false);
        this.setUpListeners();
        this.buildPopupMenu();
    }

    private TreeList<MLintTableRow> buildTreeList(EventList<MLintTableRow> eventList) {
        this.fSwingList = GlazedListsSwing.swingThreadProxyList(eventList);
        TreeList.Format<MLintTableRow> format = new TreeList.Format<MLintTableRow>(){

            public void getPath(List<MLintTableRow> list, MLintTableRow mLintTableRow) {
                assert (mLintTableRow != null) : "Provided a null message" + list;
                String string = mLintTableRow.getCategoryTag();
                list.add(new CategoryRow(string, MLintTable.this.fPrefsHelper.getCategoryName(mLintTableRow)));
                list.add(mLintTableRow);
            }

            public boolean allowsChildren(MLintTableRow mLintTableRow) {
                return mLintTableRow.isCategory();
            }
        };
        return new TreeList(this.fSwingList, (TreeList.Format)format, TreeList.NODES_START_EXPANDED, (Comparator)new ProxyCategoryComparator());
    }

    private void setUpRendering() {
        this.setShowGrid(false);
        this.setCellViewerEnabled(true);
        int n = WidgetUtils.getEmSize().width;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        TableColumn tableColumn4 = tableColumnModel.getColumn(3);
        tableColumn.setResizable(false);
        tableColumn2.setResizable(false);
        tableColumn3.setResizable(false);
        tableColumn.setMaxWidth(BULLET_SIZE + n);
        tableColumn.setCellRenderer(new ModifiedFromDefaultRenderer());
        tableColumn2.setCellRenderer(new MLintCheckBoxRenderer());
        int n2 = MLintTable.buildTableCheckBox().getPreferredSize().width;
        tableColumn2.setMaxWidth(n2 + n);
        tableColumn2.setCellEditor(new MLintCheckBoxEditor());
        tableColumn3.setCellRenderer(new SeverityCellRenderer());
        tableColumn3.setMaxWidth(MiscellaneousIcon.DIRTY_MARKER.getIcon().getIconWidth() + n);
        tableColumn4.setCellRenderer(new MessageRenderer());
        CustomTitleRowRenderer customTitleRowRenderer = new CustomTitleRowRenderer();
        tableColumn4.setCellEditor(customTitleRowRenderer);
        this.fSupport = GlazedTableSupport.install((JTable)((Object)this), this.fTreeList, (TableCellRenderer)customTitleRowRenderer);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        if (n2 != 3) {
            return super.prepareEditor(tableCellEditor, n, n2);
        }
        return this.getColumn(this.getColumnName(3)).getCellRenderer().getTableCellRendererComponent((JTable)((Object)this), null, true, false, n, n2);
    }

    private void setUpListeners() {
        TableHyperlinkFaker tableHyperlinkFaker = new TableHyperlinkFaker();
        this.addMouseListener(tableHyperlinkFaker);
        this.addMouseMotionListener(tableHyperlinkFaker);
        this.addMouseWheelListener(new TableTipMouseWheelDispatcher());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (MLintTable.this.getSelectedRowCount() == 1) {
                    int n = MLintTable.this.getSelectedRow();
                    MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
                    if (keyEvent.getKeyCode() == 32) {
                        mLintTableRow.setEnabled(mLintTableRow.isEnabled() == false);
                        MLintTable.this.refresh();
                        MLintTable.this.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ((ListSelectionModel)listSelectionEvent.getSource()).getLeadSelectionIndex();
                if (!listSelectionEvent.getValueIsAdjusting() && !MLintTable.this.fJustClicked) {
                    MLintTableRow mLintTableRow;
                    MLintTable.this.fToolTipManager.hideTip();
                    if (n >= 0 && (mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n)).hasExtendedHelp().booleanValue()) {
                        MLintTable.this.showExtendedHelpTipFromScroll(mLintTableRow);
                    }
                }
                MLintTable.this.fJustClicked = false;
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MLintTable.this.fToolTipManager.hideTip();
            }
        });
    }

    private MJMenuItem makeCollapseExpandMenuItem(String string, final boolean bl) {
        return new MJMenuItem((Action)new AbstractAction(BUNDLE.getString(string)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < MLintTable.this.fTreeList.size(); ++i) {
                    if (!MLintTable.this.fTreeList.hasChildren(i)) continue;
                    MLintTable.this.fTreeList.setExpanded(i, bl);
                }
            }
        });
    }

    private MJMenuItem makeEnableDisableMenuItem(String string, final boolean bl) {
        return new MJMenuItem((Action)new AbstractAction(BUNDLE.getString(string)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int n : MLintTable.this.getSelectedRows()) {
                    MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
                    if (!MLintTable.this.fPrefsHelper.isCategoryEnabled(mLintTableRow)) continue;
                    mLintTableRow.setEnabled(bl);
                }
                MLintTable.this.refresh();
            }
        });
    }

    public synchronized void setSearchText(String string) {
        this.fSearchText = string;
        this.refresh();
    }

    public void hideExtendedHelp() {
        this.fToolTipManager.hideTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        if (this.columnAtPoint(mouseEvent.getPoint()) == 0 && ((MLintTableRow)this.fEventTableModel.getElementAt(n = this.rowAtPoint(mouseEvent.getPoint()))).isChangedFromDefault().booleanValue()) {
            return BUNDLE.getString("mlint.table.changedToolTip");
        }
        return super.getToolTipText(mouseEvent);
    }

    public JPopupMenu getComponentPopupMenu() {
        int[] nArray = this.getSelectedRows();
        boolean bl = false;
        for (int n : nArray) {
            MLintTableRow mLintTableRow = (MLintTableRow)this.fEventTableModel.getElementAt(n);
            if (this.fPrefsHelper.getConfiguration().isReadOnly() || mLintTableRow.isCategory() || !this.fPrefsHelper.isCategoryEnabled(mLintTableRow)) continue;
            bl = true;
            break;
        }
        this.fEnablePopupMenuItem.setEnabled(bl);
        this.fDisableMenuItem.setEnabled(bl);
        return this.fPopup;
    }

    private void buildPopupMenu() {
        this.fEnablePopupMenuItem = this.makeEnableDisableMenuItem("mlint.action.enableSelected", true);
        this.fPopup.add((JMenuItem)this.fEnablePopupMenuItem);
        this.fDisableMenuItem = this.makeEnableDisableMenuItem("mlint.action.disableSelected", false);
        this.fPopup.add((JMenuItem)this.fDisableMenuItem);
        this.fPopup.add((JMenuItem)this.makeCollapseExpandMenuItem("mlint.action.expandAll", true));
        this.fPopup.add((JMenuItem)this.makeCollapseExpandMenuItem("mlint.action.collapseAll", false));
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            this.fViewport = jScrollPane.getViewport();
        }
    }

    public Dimension getCellViewerOffset(TableCell tableCell) {
        int n = tableCell.getRow();
        Dimension dimension = super.getCellViewerOffset(tableCell);
        if (((MLintTableRow)this.fEventTableModel.getElementAt(n)).isCategory()) {
            dimension.width = -TableUtils.getXForColumn((JTable)((Object)this), (int)tableCell.getColumn());
        }
        return dimension;
    }

    public boolean shouldShowCellViewer(TableCell tableCell) {
        boolean bl = super.shouldShowCellViewer(tableCell);
        int n = tableCell.getRow();
        if (((MLintTableRow)this.fEventTableModel.getElementAt(n)).isCategory()) {
            Rectangle rectangle = this.getVisibleRect();
            Rectangle rectangle2 = this.getCellRect(n, 0, true);
            Rectangle rectangle3 = this.getCellRect(n, this.getModel().getColumnCount(), true);
            Dimension dimension = this.getCellRenderer(n, tableCell.getColumn()).getTableCellRendererComponent((JTable)((Object)this), null, false, false, n, tableCell.getColumn()).getPreferredSize();
            bl = CellViewer.shouldShow((Rectangle)rectangle, (Rectangle)rectangle2.union(rectangle3), (Dimension)dimension);
        }
        return bl;
    }

    public Component getCellPainter(TableCell tableCell) {
        int n = tableCell.getRow();
        if (((MLintTableRow)this.fEventTableModel.getElementAt(n)).isCategory()) {
            tableCell = new TableCell(n, 0);
        }
        return super.getCellPainter(tableCell);
    }

    private static boolean shouldHighlightRow(JTable jTable, boolean bl) {
        return bl && jTable.getEditingColumn() != 1;
    }

    private boolean isCategoryEnabled(MLintTableRow mLintTableRow) {
        return this.fPrefsHelper.isCategoryEnabled(mLintTableRow);
    }

    private void setCategoryEnabled(MLintTableRow mLintTableRow, boolean bl) {
        this.fPrefsHelper.setCategoryEnabled(mLintTableRow, bl);
    }

    private static JCheckBox buildTableCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        jCheckBox.putClientProperty("JComponent.sizeVariant", "small");
        jCheckBox.setBorder(BorderFactory.createEmptyBorder());
        return jCheckBox;
    }

    private String highlightSearchResultsInHtml(String string) {
        String string2 = string;
        String string3 = "</span>";
        int n = string3.length();
        int n2 = 0;
        Collection<PairAndColor> collection = this.getPairs(string2, HTML_TERM_MATCHER);
        for (PairAndColor pairAndColor : collection) {
            String string4 = "<span style='background-color:" + HTMLUtils.convertColorToHex((Color)pairAndColor.getColor()) + "'>";
            int n3 = string4.length();
            int n4 = pairAndColor.getStart() + n2;
            string2 = string2.substring(0, n4) + string4 + string2.substring(n4, n4 + pairAndColor.getLength()) + string3 + string2.substring(n4 + pairAndColor.getLength());
            n2 += n3 + n;
        }
        return string2;
    }

    private synchronized Collection<PairAndColor> getPairs(String string, TermMatcher termMatcher) {
        TreeMap<Integer, PairAndColor> treeMap = new TreeMap<Integer, PairAndColor>();
        String string2 = string.toUpperCase(Locale.getDefault());
        if (this.fSearchText != null && this.fSearchText.length() > 0) {
            String[] stringArray = this.fSearchText.toUpperCase(Locale.getDefault()).split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() <= 0) continue;
                for (int n : termMatcher.getMatches(string2, string3)) {
                    int n2 = string3.length();
                    if (treeMap.containsKey(n) && ((PairAndColor)treeMap.get(n)).getLength() < n2) {
                        treeMap.remove(n);
                        treeMap.put(n, new PairAndColor(n, n2, ColorPrefs.getSearchResultColor((int)i)));
                        continue;
                    }
                    treeMap.put(n, new PairAndColor(n, n2, ColorPrefs.getSearchResultColor((int)i)));
                }
            }
        }
        return treeMap.values();
    }

    private void showExtendedHelpTipFromScroll(MLintTableRow mLintTableRow) {
        this.fToolTipManager.showTipFromScroll(this.makeTip(mLintTableRow));
    }

    private void showExtendedHelpTipFromClick(MLintTableRow mLintTableRow) {
        this.fToolTipManager.showTipFromClick(this.makeTip(mLintTableRow));
    }

    private BalloonToolTip makeTip(MLintTableRow mLintTableRow) {
        int n;
        for (n = 0; n < this.fEventTableModel.getRowCount() && !((MLintTableRow)this.fEventTableModel.getElementAt(n)).equals(mLintTableRow); ++n) {
        }
        Rectangle rectangle = this.getCellRect(n, 3, true);
        rectangle.y = this.getLocationOnScreen().y + rectangle.y;
        rectangle.x = this.getLocationOnScreen().x;
        rectangle.width = this.fViewport == null ? this.getWidth() : this.fViewport.getExtentSize().width;
        String string = this.highlightSearchResultsInHtml(mLintTableRow.getExtendedHelp());
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new MatlabHyperlinkHandler()){

            protected JScrollPane makeScrollPane(JComponent jComponent) {
                return new LightScrollPane((Component)jComponent);
            }
        };
        hyperlinkTextLabel.setBackgroundColor(TooltipUtils.getTooltipBackground());
        hyperlinkTextLabel.setFontColor(TooltipUtils.getTooltipFontColor());
        hyperlinkTextLabel.setFont(TooltipUtils.getTooltipHtmlFont());
        hyperlinkTextLabel.setMargin(new Insets(4, 4, 4, 4));
        Dimension dimension = WindowUtils.getScreenBounds().getSize();
        hyperlinkTextLabel.constrainSize(dimension.width / 4, dimension.height / 4);
        BalloonToolTip balloonToolTip = new BalloonToolTip((Frame)MJFrame.getFrame((Component)((Object)this)), (Component)hyperlinkTextLabel.getComponent(), BalloonToolTip.EAST_WEST, dimension, rectangle, null, true);
        balloonToolTip.getDialog().setName(NAME_BALLONTIP);
        this.fTip = balloonToolTip;
        return balloonToolTip;
    }

    public void refresh() {
        this.fEventTableModel.fireTableDataChanged();
    }

    public void dispose() {
        this.fToolTipManager.dispose();
        this.fSupport.uninstall();
        this.fEventTableModel.dispose();
        this.fTreeList.dispose();
        this.fSwingList.dispose();
    }

    private TreeList<MLintTableRow> getTreeList() {
        return this.fTreeList;
    }

    private class TableTipMouseWheelDispatcher
    implements MouseWheelListener {
        private TableTipMouseWheelDispatcher() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            block4: {
                Container container;
                block3: {
                    if (MLintTable.this.fTip == null || !MLintTable.this.fTip.isShowing()) break block3;
                    for (MouseWheelListener mouseWheelListener : MLintTable.this.fTip.getContent().getMouseWheelListeners()) {
                        mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                    }
                    break block4;
                }
                for (container = MLintTable.this.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                }
                if (container == null) break block4;
                for (MouseWheelListener mouseWheelListener : container.getMouseWheelListeners()) {
                    if (mouseWheelListener == this) continue;
                    mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                }
            }
        }
    }

    private static class CategoryRow
    implements MLintTableRow {
        private final String fCategoryName;
        private String fCategoryTag;

        private CategoryRow(String string, String string2) {
            this.fCategoryTag = string;
            this.fCategoryName = string2;
        }

        @Override
        public String getCategoryTag() {
            return this.fCategoryTag;
        }

        @Override
        public Boolean isEnabled() {
            return false;
        }

        @Override
        public Integer getSeverity() {
            return -1;
        }

        @Override
        public String getMessage() {
            return this.getCategoryName();
        }

        @Override
        public Boolean hasExtendedHelp() {
            return false;
        }

        @Override
        public String getCategoryName() {
            return this.fCategoryName;
        }

        @Override
        public Boolean isChangedFromDefault() {
            return false;
        }

        @Override
        public String getExtendedHelp() {
            return "";
        }

        @Override
        public String getTag() {
            return "";
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public String getURL() {
            return null;
        }

        @Override
        public boolean isCategory() {
            return true;
        }
    }

    private class TableHyperlinkFaker
    extends MouseInputAdapter {
        private TableHyperlinkFaker() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.overLink(mouseEvent)) {
                MLintTable.this.fJustClicked = true;
                MLintTable.this.showExtendedHelpTipFromClick((MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(MLintTable.this.rowAtPoint(mouseEvent.getPoint())));
            } else {
                MLintTable.this.fJustClicked = false;
            }
        }

        private boolean overLink(MouseEvent mouseEvent) {
            int n = MLintTable.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = MLintTable.this.columnAtPoint(mouseEvent.getPoint());
            return n != -1 && ((MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n)).hasExtendedHelp() != false && n2 == 3;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.overLink(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static class PairAndColor {
        private final int fStart;
        private final int fLength;
        private final Color fColor;

        private PairAndColor(int n, int n2, Color color) {
            this.fStart = n;
            this.fLength = n2;
            this.fColor = color;
        }

        public int getStart() {
            return this.fStart;
        }

        public int getLength() {
            return this.fLength;
        }

        public Color getColor() {
            return this.fColor;
        }

        public String toString() {
            return "[PairAndColor " + this.fStart + "," + this.fLength + "]";
        }
    }

    private static class MLintCheckBoxEditor
    extends DefaultCellEditor {
        private MLintCheckBoxEditor() {
            super(MLintTable.buildTableCheckBox());
        }
    }

    private class MLintCheckBoxRenderer
    implements TableCellRenderer {
        private MLintCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JCheckBox jCheckBox = MLintTable.buildTableCheckBox();
            if (MLintTable.shouldHighlightRow(jTable, bl)) {
                jCheckBox.setForeground(jTable.getSelectionForeground());
                jCheckBox.setBackground(jTable.getSelectionBackground());
            } else {
                jCheckBox.setForeground(jTable.getForeground());
                jCheckBox.setBackground(jTable.getBackground());
            }
            MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
            jCheckBox.setSelected(mLintTableRow.isEnabled());
            if (!MLintTable.this.isCategoryEnabled(mLintTableRow) || MLintTable.this.fPrefsHelper.getConfiguration().isReadOnly()) {
                jCheckBox.setEnabled(false);
                jCheckBox.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            return jCheckBox;
        }
    }

    private class MessageRenderer
    extends DefaultTableCellRenderer {
        private MessageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Component component = super.getTableCellRendererComponent(jTable, object, MLintTable.shouldHighlightRow(jTable, bl), bl2, n, n2);
            String string = (String)object;
            if (string == null) {
                string = "";
            }
            StyledLabel styledLabel = new StyledLabel(string);
            styledLabel.setOpaque(true);
            styledLabel.setBackground(component.getBackground());
            MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
            Color color2 = color = mLintTableRow.hasExtendedHelp() != false && !bl ? ColorUtils.getContrastingHyperlinkColor((Color)component.getBackground()) : component.getForeground();
            if (!MLintTable.this.isCategoryEnabled(mLintTableRow)) {
                color = UIManager.getColor("Label.disabledForeground");
            }
            int n3 = mLintTableRow.hasExtendedHelp() != false ? 8 : 0;
            Collection collection = MLintTable.this.getPairs(string, REGULAR_TERM_MATCHER);
            if (!bl && !collection.isEmpty()) {
                int n4 = 0;
                for (PairAndColor pairAndColor : collection) {
                    int n5 = pairAndColor.getStart();
                    int n6 = pairAndColor.getLength();
                    if (n5 > n4) {
                        styledLabel.addStyleRange(new StyleRange(n4, n5 - n4, 0, color, n3));
                    }
                    styledLabel.addStyleRange(new StyleRange(n5, n6, 0, color, pairAndColor.getColor(), n3));
                    n4 = n5 + n6;
                }
                if (n4 < string.length()) {
                    styledLabel.addStyleRange(new StyleRange(n4, string.length() - n4, 0, color, n3));
                }
            } else {
                styledLabel.addStyleRange(new StyleRange(0, color, n3, null));
            }
            return styledLabel;
        }
    }

    private class ModifiedFromDefaultRenderer
    extends DefaultTableCellRenderer {
        private ModifiedFromDefaultRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = MLintTable.shouldHighlightRow(jTable, bl);
            super.getTableCellRendererComponent(jTable, object, bl3, bl2, n, n2);
            this.setText(null);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder());
            MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
            boolean bl4 = mLintTableRow.isChangedFromDefault();
            if (bl4) {
                this.setIcon(bl3 ? MiscellaneousIcon.DIRTY_MARKER_INVERTED.getIcon() : MiscellaneousIcon.DIRTY_MARKER.getIcon());
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private static class SeverityCellRenderer
    extends DefaultTableCellRenderer {
        private SeverityCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, MLintTable.shouldHighlightRow(jTable, bl), bl2, n, n2);
            this.setText(null);
            Integer n3 = (Integer)object;
            if (n3 == null) {
                n3 = 0;
            }
            this.setIcon(CodeAnalyzerUtils.getSeverityIcon((int)n3, (int)BULLET_SIZE));
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getAccessibleContext().setAccessibleName(CodeAnalyzerUtils.isWarning((Integer)n3) ? "Warning" : "Error");
            return this;
        }
    }

    private static class ProxyCategoryComparator
    implements Comparator<MLintTableRow> {
        private ProxyCategoryComparator() {
        }

        @Override
        public int compare(MLintTableRow mLintTableRow, MLintTableRow mLintTableRow2) {
            return Collator.getInstance().compare(mLintTableRow.getCategoryName(), mLintTableRow2.getCategoryName());
        }
    }

    private class MLintProxyTableModel
    implements WritableTableFormat<MLintTableRow> {
        private MLintProxyTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "dirty";
                }
                case 1: {
                    return "enabled";
                }
                case 2: {
                    return "severity";
                }
                case 3: {
                    return "message";
                }
            }
            assert (false) : "There are only 4 columns";
            return null;
        }

        public Object getColumnValue(MLintTableRow mLintTableRow, int n) {
            Object object = null;
            switch (n) {
                case 0: {
                    object = mLintTableRow.isChangedFromDefault();
                    break;
                }
                case 1: {
                    object = mLintTableRow.isEnabled();
                    break;
                }
                case 2: {
                    object = mLintTableRow.getSeverity();
                    break;
                }
                case 3: {
                    object = mLintTableRow.getMessage();
                }
            }
            return object;
        }

        public boolean isEditable(MLintTableRow mLintTableRow, int n) {
            boolean bl = mLintTableRow.isCategory();
            return !MLintTable.this.fPrefsHelper.getConfiguration().isReadOnly() && !bl && n == 1 && MLintTable.this.fPrefsHelper.isCategoryEnabled(mLintTableRow) || bl && MLintPrefsUtils.isCategoryEnableable((String)mLintTableRow.getCategoryTag()) && n == 3;
        }

        public MLintTableRow setColumnValue(MLintTableRow mLintTableRow, Object object, int n) {
            if (n == 1) {
                boolean bl = (Boolean)object;
                mLintTableRow.setEnabled(bl);
            }
            if (n == 3) {
                return null;
            }
            return mLintTableRow;
        }
    }

    private class CustomTitleRowRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private CustomTitleRowRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            final MLintTableRow mLintTableRow = (MLintTableRow)MLintTable.this.fEventTableModel.getElementAt(n);
            MJLabel mJLabel = new MJLabel(mLintTableRow.getCategoryName());
            mJLabel.setFont(mJLabel.getFont().deriveFont(1));
            mJLabel.setHorizontalAlignment(2);
            mJLabel.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            mJLabel.setBorder(BorderFactory.createEmptyBorder());
            MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(3, 5, 0));
            mJPanel.setOpaque(false);
            mJPanel.setBorder(BorderFactory.createEmptyBorder());
            mJPanel.add((Component)mJLabel);
            if (MLintPrefsUtils.isCategoryEnableable((String)mLintTableRow.getCategoryTag())) {
                final boolean bl3 = MLintTable.this.isCategoryEnabled(mLintTableRow);
                final LightButton lightButton = new LightButton();
                lightButton.setAction((Action)new AbstractAction(this.getCategoryDisableButtonName(bl3)){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MLintTable.this.setCategoryEnabled(mLintTableRow, !bl3);
                        lightButton.setText(CustomTitleRowRenderer.this.getCategoryDisableButtonName(!bl3));
                        CustomTitleRowRenderer.this.fireEditingStopped();
                        MLintTable.this.refresh();
                    }
                });
                lightButton.setName(MLintTable.MLINT_CATEGORY_ENABLED_BUTTON_NAME + mLintTableRow.getCategoryTag());
                lightButton.setEnabled(!MLintTable.this.fPrefsHelper.getConfiguration().isReadOnly());
                mJPanel.add((Component)lightButton);
            }
            return mJPanel;
        }

        private String getCategoryDisableButtonName(boolean bl) {
            return BUNDLE.getString(bl ? "mlint.table.disableCategoryButton" : "mlint.table.enableCategoryButton");
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.getTableCellRendererComponent(jTable, object, false, false, n, n2);
        }
    }

    private static interface TermMatcher {
        public List<Integer> getMatches(String var1, String var2);
    }
}

