/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.mathworks.mlwidgets.prefs.binding.KeyBindingPanelUtils;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.CustomKeyBindingSetUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.binding.KeyBindingPreferences;
import com.mathworks.services.binding.MatlabKeyBindingPreferenceUtils;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

class KeyBindingSetEntry {
    private KeyBindingSet fOriginalSet;
    private CustomKeyBindingSet fSetToModify;
    private boolean fIsModifiedDefaultOrUserMadeChanges;
    private final boolean fCreatedFromDefaultSet;
    private CustomKeyBindingSet fObsoleteModifiedDefaultSet;
    private KeyBindingSet fObsoleteParentSet;
    private final KeyBindingManager fManager;
    private final KeyBindingPreferences fPrefSetter;
    private CustomKeyBindingSet.ChangeListener fChangeListener;

    KeyBindingSetEntry(KeyBindingManager keyBindingManager, KeyBindingPreferences keyBindingPreferences, KeyBindingSet keyBindingSet, boolean bl, CustomKeyBindingSet.ChangeListener changeListener) {
        this.fManager = keyBindingManager;
        this.fPrefSetter = keyBindingPreferences;
        this.fCreatedFromDefaultSet = bl;
        this.fChangeListener = changeListener;
        this.createSetInProgress(keyBindingSet);
    }

    private void createSetInProgress(KeyBindingSet keyBindingSet) {
        if (this.fSetToModify != null) {
            this.fSetToModify.removeChangeListener(this.fChangeListener);
        }
        this.fOriginalSet = keyBindingSet;
        this.fIsModifiedDefaultOrUserMadeChanges = this.fOriginalSet.isModifiedDefault();
        this.fSetToModify = new CustomKeyBindingSet(this.fOriginalSet.getID(), keyBindingSet, keyBindingSet.getName());
        this.fSetToModify.addChangeListener(this.fChangeListener);
    }

    void restoreModifiedDefaultSet() {
        assert (this.fCreatedFromDefaultSet) : "Can only be called with sets that are created from default sets";
        assert (this.isModifiedDefaultSetEntry()) : "Can only restore modified default sets";
        if (this.fObsoleteModifiedDefaultSet == null) {
            this.fObsoleteModifiedDefaultSet = this.fSetToModify;
        }
        if (this.fObsoleteParentSet == null) {
            this.fObsoleteParentSet = this.fOriginalSet;
        }
        this.createSetInProgress((KeyBindingSet)this.fSetToModify.getParent());
    }

    void discardChangesFromParent() {
        this.createSetInProgress(this.fObsoleteParentSet == null ? this.fOriginalSet : this.fObsoleteParentSet);
    }

    void saveKeyBindingSet() throws Exception {
        if (this.obsoleteDefaultSetExists()) {
            assert (this.fCreatedFromDefaultSet) : "We should only have an obsolete modified set if it was originally a modified default";
            assert (this.fObsoleteParentSet != null) : "If an obsolete modified set exists, we must also have stored an obsolete parent set";
            this.fManager.removeCustomKeyBindingSet(this.fObsoleteModifiedDefaultSet.getID());
            this.fPrefSetter.clearModifiedDefaultSetFromPrefs(this.fSetToModify.getParent());
            this.fObsoleteModifiedDefaultSet = null;
            this.fObsoleteParentSet = null;
        }
        if (!this.setHasBeenModifiedByUser()) {
            this.setAsCurrentSet();
        } else {
            if (this.fCreatedFromDefaultSet) {
                if (this.fIsModifiedDefaultOrUserMadeChanges) {
                    String string = this.fSetToModify.getID();
                    CustomKeyBindingSet customKeyBindingSet = this.fPrefSetter.addModifiedDefaultSetToPrefs(this.fSetToModify, this.fSetToModify.getParent());
                    if (this.fManager.containsCustomKeyBindingSet(string)) {
                        this.fManager.removeCustomKeyBindingSet(string);
                    }
                    this.fManager.addCustomKeyBindingSet(customKeyBindingSet);
                    this.fManager.setCurrentKeyBindingSet(customKeyBindingSet.getID());
                    this.createSetInProgress((KeyBindingSet)customKeyBindingSet);
                } else {
                    this.fPrefSetter.clearModifiedDefaultSetFromPrefs(this.fSetToModify.getParent());
                    this.fManager.setCurrentKeyBindingSet(this.fSetToModify.getParent().getID());
                }
            } else {
                String string = this.checkCustomSetCanBeWritten();
                CustomKeyBindingSetUtils.writeToFile((File)new File(string), (CustomKeyBindingSet)this.fSetToModify);
                this.fManager.removeCustomKeyBindingSet(string);
                this.fManager.addCustomKeyBindingSet(this.fSetToModify);
                this.fManager.setCurrentKeyBindingSet(this.fSetToModify.getID());
                this.createSetInProgress((KeyBindingSet)this.fSetToModify);
            }
            this.fPrefSetter.storeCurrentSetInPrefs(this.fManager.getCurrentKeyBindingSet());
        }
    }

    void setAsCurrentSet() {
        assert (!this.setHasBeenModifiedByUser()) : "The set being reverted to should have no unsaved changes.";
        this.fManager.setCurrentKeyBindingSet(this.fSetToModify.getID());
        this.fPrefSetter.storeCurrentSetInPrefs(this.fManager.getCurrentKeyBindingSet());
    }

    private boolean obsoleteDefaultSetExists() {
        return this.fObsoleteModifiedDefaultSet != null && this.fManager.containsCustomKeyBindingSet(this.fObsoleteModifiedDefaultSet.getID());
    }

    String checkCustomSetCanBeWritten() throws IOException {
        if (!this.fCreatedFromDefaultSet) {
            assert (this.fOriginalSet instanceof CustomKeyBindingSet);
            File file = new File(this.fOriginalSet.getID());
            if (!file.exists() || !file.canWrite()) {
                throw new IOException(MessageFormat.format(KeyBindingPanelUtils.lookup("customSet.writeError"), file.getPath()));
            }
        }
        return this.fOriginalSet.getID();
    }

    String deleteCustomSet() throws IOException {
        assert (!this.fCreatedFromDefaultSet);
        assert (this.fOriginalSet instanceof CustomKeyBindingSet);
        File file = new File(this.fOriginalSet.getID());
        if (file.exists() && !file.delete()) {
            throw new IOException(MessageFormat.format(KeyBindingPanelUtils.lookup("customSet.deleteError"), file.getPath()));
        }
        return this.fOriginalSet.getID();
    }

    File getFile() {
        File file = !this.fCreatedFromDefaultSet ? new File(this.fSetToModify.getID()) : MatlabKeyBindingPreferenceUtils.resolveToPrefDir((String)("Custom" + this.fSetToModify.getParent().getID() + "Set.xml"));
        assert (file.isAbsolute()) : "The path returned for the File dialog when save is pressed should be absolute: " + file.getPath();
        return file;
    }

    public String toString() {
        return this.getUserVisibleName(60);
    }

    public String getUserVisibleName(int n) {
        String string;
        if (this.fCreatedFromDefaultSet) {
            string = this.fSetToModify.getParent().getName();
            if (this.fIsModifiedDefaultOrUserMadeChanges) {
                string = KeyBindingPanelUtils.markAsModified(string);
            }
        } else {
            string = FileUtils.truncatePathname((String)this.fSetToModify.getName(), (int)n, (int)4);
        }
        return string;
    }

    boolean isModifiedDefaultSetEntry() {
        return this.fIsModifiedDefaultOrUserMadeChanges;
    }

    boolean wasCreatedFromDefaultSet() {
        return this.fCreatedFromDefaultSet;
    }

    boolean setHasBeenModifiedByUser() {
        return this.obsoleteDefaultSetExists() || !this.fSetToModify.isInfoEqual(this.fOriginalSet);
    }

    CustomKeyBindingSet getModifiableSet() {
        return this.fSetToModify;
    }

    List<KeyStrokeList> getActionGlobalKeyBindings(ActionData actionData) {
        return KeyBindingPanelUtils.removeHiddenEntries(this.fSetToModify.getActionGlobalKeyBindings(actionData));
    }

    List<KeyStrokeList> getNonGlobalKeyBindings(Context context, ActionDataID actionDataID) {
        return KeyBindingPanelUtils.removeHiddenEntries(this.fSetToModify.getNonGlobalKeyBindings(context, actionDataID));
    }

    boolean followsGlobalContext(Context context, ActionDataID actionDataID) {
        return this.fSetToModify.followsGlobalContext(context, actionDataID);
    }

    boolean getFollowsComponentContext(Context context, ActionDataID actionDataID) {
        return this.fSetToModify.getFollowsComponentContext(context, actionDataID);
    }

    void changeFollowsGlobal(Context context, ActionDataID actionDataID, boolean bl) {
        this.markAsModifiedIfNecessary();
        this.fSetToModify.changeFollowsGlobal(context, actionDataID, bl);
    }

    void removeGlobalBinding(KeyStrokeList keyStrokeList, ActionData actionData) {
        this.markAsModifiedIfNecessary();
        this.fSetToModify.removeGlobalBinding(keyStrokeList, actionData);
    }

    void removeCustomKeyBinding(KeyStrokeList keyStrokeList, Context context, ActionDataID actionDataID) {
        this.markAsModifiedIfNecessary();
        this.fSetToModify.removeCustomKeyBinding(keyStrokeList, context, actionDataID);
    }

    void addGlobalBinding(ActionData actionData, KeyStrokeList keyStrokeList) {
        this.markAsModifiedIfNecessary();
        this.fSetToModify.addGlobalBindingToExistingEntries(actionData, keyStrokeList.toKeyStrokeArray());
    }

    void prioritizeGlobalBindings(ActionData actionData, List<KeyStrokeList> list) {
        if (this.fSetToModify.prioritizeGlobalBindings(actionData, KeyBindingSetEntry.transformToVisibleEntries(list))) {
            this.markAsModifiedIfNecessary();
        }
    }

    void prioritizeCustomBindings(Context context, ActionData actionData, List<KeyStrokeList> list) {
        if (this.fSetToModify.prioritizeCustomBindings(context, actionData, KeyBindingSetEntry.transformToVisibleEntries(list))) {
            this.markAsModifiedIfNecessary();
        }
    }

    private static List<KeyStrokeList> transformToVisibleEntries(List<KeyStrokeList> list) {
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>();
        for (KeyStrokeList keyStrokeList : list) {
            KeyStrokeUtils.addAllBindingVariations((KeyStrokeList)keyStrokeList, arrayList);
        }
        return KeyBindingPanelUtils.removeHiddenEntries(arrayList);
    }

    void addCustomKeyBinding(Context context, ActionDataID actionDataID, KeyStrokeList keyStrokeList) {
        this.markAsModifiedIfNecessary();
        this.fSetToModify.addCustomKeyBinding(context, actionDataID, keyStrokeList.toKeyStrokeArray());
    }

    void removeKeyBindingFromContext(ActionData actionData, Context context, KeyStrokeList keyStrokeList) {
        this.markAsModifiedIfNecessary();
        List list = this.fSetToModify.getNonGlobalKeyBindings(context, (ActionDataID)actionData);
        if (list.contains(keyStrokeList)) {
            this.removeCustomKeyBinding(keyStrokeList, context, (ActionDataID)actionData);
        }
        this.removeGlobalBinding(keyStrokeList, actionData);
    }

    private void markAsModifiedIfNecessary() {
        if (this.fCreatedFromDefaultSet) {
            this.fIsModifiedDefaultOrUserMadeChanges = true;
        }
    }

    void suspendEventFiring() {
        this.fSetToModify.suspendEventFiring();
    }

    void resumeEventFiring() {
        this.fSetToModify.resumeEventFiring();
    }
}

