/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.swing.JideButton;
import com.mathworks.beans.editors.EditorManager;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDArrayEditor;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.AutopilotUpdateListener;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.InspectorUpdateListener;
import com.mathworks.mlwidgets.inspector.JidePropertyTableModel;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.TreeTableModelUpdateListener;
import com.mathworks.mlwidgets.util.GrayBoxTestingListenerGroup;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class PropertyView
extends MJPanel {
    private Object[] fObjects;
    private ObjectRegistry fRegistry;
    private final RegistryHandler fRegistryHandler;
    private MJScrollPane fScrollPane;
    private PropertyTarget fTarget;
    private JideButton fGroupButton = null;
    private JideButton fListButton = null;
    private JideButton fCollapseButton = null;
    private JideButton fExpandButton = null;
    private JidePropertyViewTable fJideTable;
    private JidePropertyTableModel fJideTableModel;
    private PropertyPane fJidePane;
    private final EventListenerList fListenerList = new EventListenerList();
    private static boolean sUDDEditorsRegistered = false;
    private static boolean sIsFeatureGroupingEnabled = false;
    public static final int NO_ITEM = -1;
    boolean fShowReadOnly = false;
    static boolean DEBUG = false;
    private static boolean sIsAutoUpdate = true;
    private static EventListenerList sAutopilotListenerList = new EventListenerList();
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.inspector.resources.RES_PropView");
    private static String COLLAPSE = resourceBundle.getString("tooltip.collapse");
    private static String EXPAND = resourceBundle.getString("tooltip.expand");
    private static String GROUP = resourceBundle.getString("tooltip.group");
    private static String LIST = resourceBundle.getString("tooltip.list");

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }

    public PropertyView() {
        this(ObjectRegistry.getRegistry());
    }

    public PropertyView(ObjectRegistry objectRegistry) {
        this(objectRegistry, ToolBarStyle.NOTOOLBAR);
    }

    public PropertyView(ObjectRegistry objectRegistry, ToolBarStyle toolBarStyle) {
        this.fRegistryHandler = new RegistryHandler();
        this.setLayout(new BorderLayout());
        this.initBeanEditors();
        MJUtilities.initJIDE();
        this.fJideTableModel = new JidePropertyTableModel(objectRegistry);
        this.fJideTable = new JidePropertyViewTable(this.fJideTableModel);
        this.fJideTable.setRowHeight(InspectorUIResources.getCellHeight());
        if (toolBarStyle == ToolBarStyle.NOTOOLBAR) {
            this.fJideTableModel.setOrder(1);
            this.fJidePane = new PropertyPane((PropertyTable)this.fJideTable);
            this.fJidePane.setShowToolBar(false);
            this.fJidePane.setShowDescription(false);
            this.add((Component)this.fJidePane);
        } else if (toolBarStyle == ToolBarStyle.GROUPTOOLBAR) {
            this.fJidePane = new PropertyPane((PropertyTable)this.fJideTable, 1);
            this.fJidePane.setShowToolBar(true);
            this.fJidePane.setShowDescription(false);
            this.add((Component)this.fJidePane);
            JComponent jComponent = this.fJidePane.getToolBar();
            jComponent.add(new JToolBar.Separator());
            this.fJidePane.getClass();
            this.fCollapseButton = new JideButton(this.fJidePane.getAction("COLLAPSE"));
            this.fCollapseButton.setToolTipText(COLLAPSE);
            this.fCollapseButton.setEnabled(false);
            this.fCollapseButton.setName("Collapse");
            jComponent.add((Component)this.fCollapseButton);
            this.fJidePane.getClass();
            Action action = this.fJidePane.getAction("EXPAND");
            this.fExpandButton = new JideButton(action);
            this.fExpandButton.setToolTipText(EXPAND);
            this.fExpandButton.setEnabled(false);
            this.fExpandButton.setName("Expand");
            jComponent.add((Component)this.fExpandButton);
            this.fJideTable.addInspectorUpdateListener(new TreeTableModelUpdateListener(){

                @Override
                public void treeTableUpdated() {
                    PropertyView.this.updateViewForTarget();
                    PropertyView.this.updateView();
                }
            });
            this.initToolbar();
            this.updateViewForTarget();
        }
        this.setRegistry(objectRegistry);
    }

    public void doRefresh() {
        this.fJideTableModel.doRefresh();
    }

    public String getRenderedTextForTesting(String string) {
        return this.fJideTableModel.getRenderedTextForTesting(string);
    }

    public static void setAutoUpdate(boolean bl) {
        sIsAutoUpdate = bl;
    }

    public static boolean isAutoUpdate() {
        return sIsAutoUpdate;
    }

    public static void setPropertyGrouping(boolean bl) {
        sIsFeatureGroupingEnabled = bl;
    }

    public static boolean isPropertyGrouping() {
        return sIsFeatureGroupingEnabled;
    }

    public static boolean isJide() {
        return true;
    }

    private void initBeanEditors() {
        EditorManager.init();
        if (!sUDDEditorsRegistered) {
            Class<?> clazz = Array.newInstance(UDDObject.class, 0).getClass();
            PropertyEditorManager.registerEditor(clazz, UDDArrayEditor.class);
            sUDDEditorsRegistered = true;
        }
    }

    private void initToolbar() {
        Component[] componentArray = this.fJidePane.getToolBar().getComponents();
        for (int i = 0; componentArray != null && i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JideButton)) continue;
            if (i == 0) {
                this.fGroupButton = (JideButton)componentArray[i];
                this.fGroupButton.addActionListener((ActionListener)new ButtonListener());
                this.fGroupButton.setToolTipText(GROUP);
                this.fGroupButton.setName("Group");
                continue;
            }
            if (i != 1) continue;
            this.fListButton = (JideButton)componentArray[i];
            this.fListButton.addActionListener((ActionListener)new ButtonListener());
            this.fListButton.setToolTipText(LIST);
            this.fListButton.setName("List");
            this.fListButton.setEnabled(false);
        }
    }

    private void enableGroupButtons(boolean bl) {
        this.fExpandButton.setEnabled(bl);
        this.fCollapseButton.setEnabled(bl);
    }

    private boolean isCurrentModelUsingPropertyGrouping() {
        boolean bl = 0 == this.fJideTableModel.getOrder();
        return bl;
    }

    private void updateView() {
        if (this.fJideTableModel != null) {
            if (this.isCurrentModelUsingPropertyGrouping()) {
                this.enableGroupButtons(true);
            } else {
                this.enableGroupButtons(false);
            }
        }
    }

    private void updateViewForTarget() {
        this.fireInspectorUpdateEvent();
        JidePropertyTableModel jidePropertyTableModel = this.fJideTable.getJideTableModel();
        if (jidePropertyTableModel != null) {
            if (this.getCurrentObject() != null) {
                this.fListButton.setEnabled(true);
            }
            if (jidePropertyTableModel.targetHasPropertyGroups() && this.fGroupButton != null) {
                this.fGroupButton.setEnabled(true);
            } else {
                jidePropertyTableModel.setOrder(1);
                if (this.fGroupButton != null) {
                    this.fGroupButton.setEnabled(false);
                }
            }
        }
    }

    public PropertyTarget getTarget() {
        return this.fTarget;
    }

    public void dispose() {
    }

    public void updateValues() {
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PropertyView.this.fRegistry != null) {
                    Object[] objectArray = PropertyView.this.fRegistry.getSelectedObjects();
                    PropertyView.this.setObject_MatlabThread(objectArray);
                }
            }
        });
    }

    public void triggerRefresh() {
    }

    public void fireInspectorUpdateEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventListener[] eventListenerArray = PropertyView.this.fListenerList.getListeners(InspectorUpdateListener.class);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((InspectorUpdateListener)eventListenerArray[i]).inspectorUpdated(PropertyView.this.getCurrentObject());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAutopilotUpdateListener(AutopilotUpdateListener autopilotUpdateListener) {
        EventListenerList eventListenerList = sAutopilotListenerList;
        synchronized (eventListenerList) {
            sAutopilotListenerList.add(AutopilotUpdateListener.class, autopilotUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAutopilotUpdateListener(AutopilotUpdateListener autopilotUpdateListener) {
        EventListenerList eventListenerList = sAutopilotListenerList;
        synchronized (eventListenerList) {
            sAutopilotListenerList.remove(AutopilotUpdateListener.class, autopilotUpdateListener);
        }
    }

    public static void fireAutopilotClosedEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventListenerList eventListenerList = sAutopilotListenerList;
                synchronized (eventListenerList) {
                    EventListener[] eventListenerArray = sAutopilotListenerList.getListeners(AutopilotUpdateListener.class);
                    for (int i = 0; i < eventListenerArray.length; ++i) {
                        ((AutopilotUpdateListener)eventListenerArray[i]).inspectorClosed_EventThread();
                    }
                }
            }
        });
    }

    public static void fireAutopilotUpdateEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventListenerList eventListenerList = sAutopilotListenerList;
                synchronized (eventListenerList) {
                    EventListener[] eventListenerArray = sAutopilotListenerList.getListeners(AutopilotUpdateListener.class);
                    for (int i = 0; i < eventListenerArray.length; ++i) {
                        ((AutopilotUpdateListener)eventListenerArray[i]).inspectorUpdated_EventThread();
                    }
                }
            }
        });
    }

    public void addInspectorUpdateListener(InspectorUpdateListener inspectorUpdateListener) {
        this.fListenerList.add(InspectorUpdateListener.class, inspectorUpdateListener);
    }

    public ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    public void cleanup_EventThread() {
        this.removeRegistryListener();
        if (this.fJideTableModel != null && this.fJideTableModel.targetHasPropertyGroups() && this.fJideTable != null) {
            this.fJideTable.cleanup_EventThread();
        }
        if (this.fJideTableModel != null) {
            this.fJideTableModel.removeListeners();
        }
    }

    private void removeRegistryListener() {
        if (this.fRegistry != null && this.fRegistryHandler != null) {
            this.fRegistry.removeItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
    }

    public void setRegistry(ObjectRegistry objectRegistry) {
        if (objectRegistry != null && objectRegistry != this.fRegistry) {
            if (this.fRegistry != null) {
                this.removeRegistryListener();
            }
            this.fRegistry = objectRegistry;
            this.fRegistry.addItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
    }

    private void setCurrentObject(Object[] objectArray) {
        this.fObjects = objectArray;
    }

    private Object[] getCurrentObject() {
        return this.fObjects;
    }

    public Object[] getObjects() {
        return this.getCurrentObject();
    }

    private static boolean isClassEqual(Object[] objectArray, Object[] objectArray2) {
        boolean bl = true;
        if (objectArray != null && objectArray2 != null && objectArray.length > 0 && objectArray.length == objectArray2.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].getClass().equals(objectArray2[i].getClass())) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static boolean isArrayEqual(Object[] objectArray, Object[] objectArray2) {
        boolean bl = false;
        if (objectArray != null && objectArray2 != null && objectArray.length == objectArray2.length) {
            bl = true;
            for (int i = 0; i < objectArray.length && bl; ++i) {
                if (objectArray[i] != null) {
                    if (objectArray[i].equals(objectArray2[i])) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Deprecated
    public void setObject(Object object) {
        this.setObject_AnyThread(new Object[]{object});
    }

    public static int debugGetSeconds() {
        return Calendar.getInstance().get(13);
    }

    private void setObject_AnyThread(final Object[] objectArray) {
        if (DEBUG) {
            System.out.println("PropertyView: setObject_AnyThread: " + PropertyView.debugGetSeconds());
            if (NativeMatlab.nativeIsMatlabThread()) {
                System.out.println("Matlab Thread");
            } else if (SwingUtilities.isEventDispatchThread()) {
                System.out.println("Event Thread");
            }
        }
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.setObject_MatlabThread(objectArray);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    PropertyView.this.setObject_MatlabThread(objectArray);
                }
            });
        }
    }

    private void refreshTable_MatlabThread() {
        if (this.fJideTable != null) {
            this.fJideTable.refreshValues_MatlabThread();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyView.this.fJideTable.repaint();
                }
            });
            this.fireInspectorUpdateEvent();
        }
        PropertyView.fireAutopilotUpdateEvent();
        GrayBoxTestingListenerGroup.fireGrayBoxTestingEvent(PropertyTarget.class, "PropertyView:refreshTable_MatlabThread");
    }

    private void setObject_MatlabThread(Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (DEBUG) {
            System.out.println("PropertyView: setObject_MatlabThread: " + PropertyView.debugGetSeconds());
        }
        if (objectArray != null) {
            if (objectArray.length > 0 && PropertyView.isArrayEqual(this.getCurrentObject(), objectArray)) {
                this.refreshTable_MatlabThread();
            } else if (objectArray.length > 0 && PropertyView.isClassEqual(this.getCurrentObject(), objectArray)) {
                this.setCurrentObject(objectArray);
                this.fJideTable.setObjects_MatlabThread(objectArray, true);
            } else {
                this.setCurrentObject(objectArray);
                this.fJideTable.setObjects_MatlabThread(objectArray, false);
            }
        }
    }

    private void scrollToTop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PropertyView.this.fJidePane == null) {
                    return;
                }
                JScrollPane jScrollPane = PropertyView.this.fJidePane.getScrollPane();
                if (jScrollPane != null && jScrollPane.getVerticalScrollBar() != null) {
                    jScrollPane.getVerticalScrollBar().setValue(0);
                }
            }
        });
    }

    public void selectProperty(String string) {
        this.fJideTable.selectProperty_AnyThread(string);
    }

    public void setShowReadOnly(boolean bl) {
        this.fShowReadOnly = bl;
    }

    private class RegistryHandler
    implements ItemListener,
    ObjectRegistryListener {
        private RegistryHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent == null) {
                PropertyView.this.setObject_AnyThread(new Object[0]);
                return;
            }
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            Object object = itemEvent.getItem();
            assert (object instanceof Object[]) : "Precondition violated: item's class is not Object[]";
            Object[] objectArray = (Object[])object;
            PropertyView.this.setObject_AnyThread(objectArray);
            boolean bl = PropertyView.isArrayEqual(PropertyView.this.getCurrentObject(), objectArray);
            if (!bl) {
                PropertyView.this.scrollToTop();
            }
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            Object[] objectArray;
            if (PropertyView.this.fRegistry != null && (objectArray = PropertyView.this.fRegistry.getSelectedObjects()).length > 0) {
                PropertyView.this.setObject_AnyThread(objectArray);
            }
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
            Object[] objectArray;
            for (Object object : objectArray = objectRegistryEvent.getOldParents()) {
                if (!(object instanceof ObjectRegistry)) continue;
                PropertyView.this.setObject_AnyThread(new Object[0]);
                return;
            }
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertyView.this.fGroupButton == actionEvent.getSource()) {
                PropertyView.this.enableGroupButtons(true);
            } else {
                PropertyView.this.enableGroupButtons(false);
            }
        }
    }

    public static enum ToolBarStyle {
        NOTOOLBAR,
        GROUPTOOLBAR;

    }
}

