/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyEditor;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class PropertyCellEditField
extends PropertyCell {
    public PromptTextField fEditField;
    private NumberFormat format;
    public MJLabel fLabel;
    private MJPanel fRendererPanel;
    private MJPanel fEditorPanel;

    PropertyCellEditField(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(jComponent, propertyTarget, n, n2, namedEditor);
    }

    @Override
    void updateComponent_EventThread() {
        assert (SwingUtilities.isEventDispatchThread() || !Matlab.isMatlabAvailable());
        if (this.fEditField != null) {
            if (PropertyView.DEBUG) {
                String string = "PropertyCelleDITfIELD.updateComponent_EventThread:fEditField.setEditTextAndPrompt" + this.getAsTextAndFormat(CellType.editor);
                MLExecuteServices.consoleEval((String)("disp('" + string + "')"));
                System.out.println(string);
            }
            this.fEditField.setEditTextAndPrompt(this.getAsTextAndFormat(CellType.editor));
        }
        if (this.fLabel != null) {
            this.fLabel.setText(this.getAsTextAndFormat(CellType.renderer));
        }
    }

    @Override
    MJPanel getRendererComponent() {
        if (this.fRendererPanel == null) {
            this.fRendererPanel = this.createRendererPanel();
        }
        return this.fRendererPanel;
    }

    @Override
    MJPanel getEditorComponent() {
        if (MWPropertyEditorUtils.isTopLevelEditable((PropertyEditor)this.getEditor()) && this.isEditable()) {
            if (this.fEditorPanel == null) {
                this.fEditorPanel = this.createEditorPanel();
            }
            return this.fEditorPanel;
        }
        return this.getRendererComponent();
    }

    protected MJPanel createRendererPanel() {
        this.fLabel = this.createRendererComponent();
        return this.createMainPanel((JComponent)this.fLabel);
    }

    protected MJPanel createEditorPanel() {
        this.fEditField = this.createEditorComponent();
        return this.createMainPanel((JComponent)((Object)this.fEditField));
    }

    protected final MJLabel createRendererComponent() {
        PropertyEditor propertyEditor = this.getEditor();
        this.fLabel = propertyEditor instanceof MWPropertyEditorSupport && ((MWPropertyEditorSupport)propertyEditor).getInspectorRenderer() != null && ((MWPropertyEditorSupport)propertyEditor).getInspectorRenderer() instanceof MJLabel ? (MJLabel)((MWPropertyEditorSupport)propertyEditor).getInspectorRenderer() : new MJLabel();
        this.fLabel.setOpaque(false);
        if (!this.isEditable()) {
            this.fLabel.setForeground(InspectorUIResources.VALUE_DISABLED_COLOR);
        }
        this.fLabel.setText(this.getAsTextAndFormat(CellType.renderer));
        return this.fLabel;
    }

    protected final PromptTextField createEditorComponent() {
        this.fEditField = this.createTextField();
        this.fEditField.setBackground(InspectorUIResources.getEditTextBackground());
        this.fEditField.setHorizontalAlignment(2);
        return this.fEditField;
    }

    protected final MJButton getPencilButton() {
        Icon icon = InspectorUIResources.getEditIcon();
        return PropertyCell.createRightSideButton(icon);
    }

    protected final MJPanel createMainPanel(JComponent jComponent) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setOpaque(false);
        if (this.isEditable() && !this.hasChildren()) {
            mJPanel.add((Component)this.getPencilButton(), (Object)"East");
        }
        mJPanel.add((Component)jComponent, (Object)"Center");
        int n = InspectorUIResources.getIconHorizontalOffset();
        int n2 = InspectorUIResources.getCellHeight();
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBackground(InspectorUIResources.getEditTextBackground());
        mJPanel2.setOpaque(false);
        Dimension dimension = new Dimension(n, n2);
        mJPanel2.setPreferredSize(dimension);
        mJPanel.add((Component)mJPanel2, (Object)"West");
        return mJPanel;
    }

    private String getAsTextAndFormat(CellType cellType) {
        String string = "";
        if (this.getEditor().getValue() != null) {
            string = this.doFormat(this.getEditor().getAsText());
        }
        if (cellType == CellType.renderer) {
            return this.handleMixedValues(string, this.getEditor().getValue());
        }
        return string;
    }

    private PromptTextField createTextField() {
        PromptTextField promptTextField = new PromptTextField();
        promptTextField.setBorder(null);
        promptTextField.setOpaque(true);
        promptTextField.setEditTextAndPrompt(this.getAsTextAndFormat(CellType.editor));
        return promptTextField;
    }

    private String handleMixedValues(String string, Object object) {
        if (this.isMixed() && (object == null || string.equals("null"))) {
            return InspectorUIResources.getMixedValueDisplay();
        }
        return string;
    }

    public void updateTarget() {
        if (PropertyView.DEBUG) {
            MLExecuteServices.consoleEval((String)"disp('PropertyCellEditField.updateTarget')");
            System.out.println("PropertyCellEditField.updateTarget");
        }
        if (this.fEditField != null && !this.fEditField.isPrompting()) {
            String string = this.doFormat(this.fEditField.getText());
            String string2 = "";
            if (this.getEditor().getValue() != null) {
                string2 = this.doFormat(this.getEditor().getAsText());
            }
            if (PropertyView.DEBUG) {
                String string3 = "PropertyCellEditField.updateTarget::newstring" + string;
                MLExecuteServices.consoleEval((String)("disp('" + string3 + "')"));
                System.out.println(string3);
                string3 = "PropertyCellEditField.updateTarget::oldstring" + string2;
                MLExecuteServices.consoleEval((String)("disp('" + string3 + "')"));
                System.out.println(string3);
            }
            if (string == null) {
                this.fEditField.setEditTextAndPrompt(string2);
            } else if (string2 != null && !string.equals(string2)) {
                try {
                    this.getEditor().setAsText(string);
                    this.fLabel.setText(string);
                }
                catch (Exception exception) {
                    if (PropertyView.DEBUG) {
                        String string4 = "PropertyCellEditField.updateTarget::Exception" + exception.toString();
                        MLExecuteServices.consoleEval((String)("disp('" + string4 + "')"));
                        System.out.println(string4);
                    }
                    this.fEditField.setEditTextAndPrompt(string2);
                }
            }
        }
    }

    private String doFormat(String string) {
        String string2 = null;
        if (this.isColor()) {
            NumberFormat numberFormat = this.getNumberFormat();
            try {
                Number number = numberFormat.parse(string);
                double d = number.doubleValue();
                if (d >= 0.0 && d <= 1.0) {
                    string2 = numberFormat.format(d);
                }
            }
            catch (ParseException parseException) {}
        } else {
            string2 = string;
        }
        return string2;
    }

    private boolean isColor() {
        String string = this.getName();
        return string.equals("red") || string.equals("blue") || string.equals("green");
    }

    private NumberFormat getNumberFormat() {
        if (this.format == null) {
            this.format = NumberFormat.getInstance(Locale.US);
            this.format.setParseIntegerOnly(false);
            this.format.setMinimumFractionDigits(1);
            this.format.setMaximumFractionDigits(3);
            this.format.setGroupingUsed(false);
        }
        return this.format;
    }

    class PromptTextField
    extends MJTextField
    implements KeyListener {
        private String iPromptText;
        private boolean iIsPrompting = false;

        PromptTextField() {
            this.addKeyListener(this);
        }

        void setPromptText(String string) {
            this.iPromptText = string;
            this.reset();
        }

        void setIsPrompting(boolean bl) {
            this.iIsPrompting = bl;
            this.reset();
        }

        boolean isPrompting() {
            return this.iIsPrompting;
        }

        private void reset() {
            if (this.iPromptText != null && this.iIsPrompting) {
                this.setForeground(Color.gray);
                this.setText(this.iPromptText);
            } else {
                this.setForeground(Color.black);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.iPromptText != null && this.iIsPrompting) {
                this.setText("");
                this.iIsPrompting = false;
                this.reset();
            }
        }

        void setEditTextAndPrompt(String string) {
            this.setText(string);
            if (string != null && PropertyCellEditField.this.isMixed() && (string.equals("null") || string.equals(InspectorUIResources.getMixedValueDisplay()))) {
                this.setPromptText(InspectorUIResources.getMixedValueDisplay());
                this.setIsPrompting(true);
            } else {
                this.setPromptText("");
                this.setIsPrompting(false);
            }
        }

        public void setText(String string) {
            super.setText(string);
        }
    }

    private static enum CellType {
        renderer,
        editor;

    }
}

