/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportCodeFactory;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ImportToolstripTab;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.SpreadsheetCodeFactory;
import com.mathworks.mlwidgets.importtool.SpreadsheetHeaderMouseAdapter;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportUIState;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.TextCodeFactory;
import com.mathworks.mlwidgets.importtool.WorksheetCellRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetTableModel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class WorksheetTable
extends ImportTable {
    private ImportTable.ZoomInAction fZoomInAction;
    private ImportTable.ZoomOutAction fZoomOutAction;
    private ImportTable.ClearAllSelectionAction fClearAllSelectionAction;
    private boolean fCleanedUp = false;
    private boolean fSetInitialSelection = false;

    public WorksheetTable(WorksheetTableModel worksheetTableModel) {
        super(worksheetTableModel);
        this.setName("ImportTool.WorksheetTable");
        SpreadsheetHeaderMouseAdapter spreadsheetHeaderMouseAdapter = new SpreadsheetHeaderMouseAdapter(this.getTableHeader(), (SpreadsheetTableHeaderRenderer)this.fHeaderRenderer);
        this.getTableHeader().addMouseListener(spreadsheetHeaderMouseAdapter);
        this.getTableHeader().addMouseMotionListener(spreadsheetHeaderMouseAdapter);
    }

    public void setHeaderRenderer(int n) {
        if (this.fHeaderRenderer == null) {
            this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        }
        this.tableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
    }

    @Override
    public IHeaderRenderer createColumnHeaderRenderer(JTable jTable) {
        this.fHeaderRenderer = new SpreadsheetTableHeaderRenderer((WorksheetTable)((Object)jTable));
        ((SpreadsheetTableHeaderRenderer)this.fHeaderRenderer).setVariableNamesVisible(true);
        ((SpreadsheetTableHeaderRenderer)this.fHeaderRenderer).setGroupNamesVisible(true);
        if (PlatformInfo.isMacintosh() && Matlab.isMatlabAvailable()) {
            jTable.setGridColor(this.fHeaderRenderer.getPreferredGridColor());
        }
        ((CellEditor)this.fHeaderRenderer).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                Object object = ((CellEditor)WorksheetTable.this.fHeaderRenderer).getCellEditorValue();
                if (!(object instanceof SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader)) {
                    return;
                }
                SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader)object;
                int n = spreadsheetImportDataHeader.getColumn();
                if (n < 0 || WorksheetTable.this.getColumnModel().getColumn(n).getHeaderValue().equals(spreadsheetImportDataHeader)) {
                    return;
                }
                String string = spreadsheetImportDataHeader.getName();
                WorksheetTable.this.processVarNameEdit(string, n, spreadsheetImportDataHeader);
                SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType = ((WorksheetTableModel)WorksheetTable.this.getWorksheetTableModel()).getColumnTargetType(n);
                WorksheetTable.this.getColumnModel().getColumn(n).setHeaderValue(new SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader(n, string, spreadsheetColumnTargetType));
            }
        });
        return this.fHeaderRenderer;
    }

    @Override
    public void updateColumnHeader() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof WorksheetTableModel) {
            Object object;
            int n;
            int n2 = 0;
            String[] stringArray = this.getNonConflictingColumnVariableNamesArray();
            for (n = 0; n < this.getColumnCount(); ++n) {
                if (stringArray == null) {
                    return;
                }
                String string = n < stringArray.length ? stringArray[n] : "VarName" + Integer.toString(n + 1);
                object = ((WorksheetTableModel)this.getWorksheetTableModel()).getColumnTargetType(n);
                if (object == null) {
                    object = SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY;
                }
                this.getColumnModel().getColumn(n).setHeaderValue(new SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader(n, string, (SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType)((Object)object)));
                int n3 = 0;
                if (this.fHeaderRenderer != null) {
                    n3 = ((SpreadsheetTableHeaderRenderer)this.fHeaderRenderer).getPreferredHeaderWidth(n, this.getColumnModel().getColumn(n).getHeaderValue());
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            if (this.getColumnCount() == 1) {
                n = this.getRowCount() < 10 ? this.getRowCount() : 10;
                for (int i = 0; i < n; ++i) {
                    object = this.getCellRenderer(i, 0);
                    Component component = object.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(i, 0), false, false, i, 0);
                    if (component == null || component.getPreferredSize().width <= n2) continue;
                    n2 = component.getPreferredSize().width;
                }
            }
        }
    }

    @Override
    public void worksheetCachedDataChanged(EventObject eventObject) {
        this.fireWorksheetCachedDataListeners(eventObject);
        RepaintManager repaintManager = RepaintManager.currentManager((JComponent)((Object)this));
        Rectangle rectangle = this.getVisibleRect();
        repaintManager.addDirtyRegion((JComponent)((Object)this), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.requestFocusInWindow();
        this.repaint();
    }

    @Override
    ImportCellRenderer getRenderer() {
        return (ImportCellRenderer)this.getDefaultRenderer(Object.class);
    }

    @Override
    void setupAdditionalFonts() {
    }

    @Override
    void updateTableBeforeRepaint() {
    }

    @Override
    public boolean isRuleClassAppliedToSelection(Class clazz) {
        IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)this.getSelectionModel();
        IntervalSelectionModel intervalSelectionModel2 = (IntervalSelectionModel)this.getColumnModel().getSelectionModel();
        boolean bl = !this.getWorksheetTableModel().isSelectionInCachedArray(intervalSelectionModel, intervalSelectionModel2);
        List<int[]> list = intervalSelectionModel.getSelectedIntervals();
        List<int[]> list2 = intervalSelectionModel2.getSelectedIntervals();
        for (int[] nArray : list) {
            for (int[] nArray2 : list2) {
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    for (int j = nArray2[0]; j <= nArray2[1]; ++j) {
                        boolean bl2;
                        boolean bl3 = bl2 = (this.getTargetType().isColumnVectors() || this.getTargetType().isDataSet() || this.getTargetType().isTable()) && this.getColumnTargetType(j) == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY;
                        if (bl2 || !bl && this.getWorksheetTableModel().getRuleClassAt(i, j) != clazz) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void installEditorsAndRenderersForFormat() {
        this.fCellRenderer = new WorksheetCellRenderer();
        this.setDefaultRenderer(Object.class, this.fCellRenderer);
    }

    @Override
    protected void initActions() {
        if (Matlab.isMatlabAvailable()) {
            this.fSelectAllAction = new AbstractSpreadsheetTable.SelectAllAction((AbstractSpreadsheetTable)this);
            this.fCopyAction = new ImportTable.CopyAction();
        }
        this.fClearAllSelectionAction = new ImportTable.ClearAllSelectionAction();
        this.fZoomInAction = new ImportTable.ZoomInAction();
        this.fZoomOutAction = new ImportTable.ZoomOutAction();
    }

    @Override
    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.add((Action)((Object)this.fClearAllSelectionAction));
        this.fSelectionPopupMenu.add((Component)new JPopupMenu.Separator());
        this.fSelectionPopupMenu.add((Action)((Object)this.fCopyAction));
        this.fSelectionPopupMenu.add((Component)new JPopupMenu.Separator());
        this.fSelectionPopupMenu.add((Action)((Object)this.fZoomInAction));
        this.fSelectionPopupMenu.add((Action)((Object)this.fZoomOutAction));
        this.addImportContextMenuItem();
        this.fTmel = new TableMouseEventListener();
        this.addMouseListener(this.fTmel);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnTargetTypeName(int n) {
        return ((SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader)this.getColumnModel().getColumn(n).getHeaderValue()).getColumnTarget().toString();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.getModel().getColumnCount() != this.getColumnModel().getColumnCount()) {
            this.createDefaultColumnsFromModel();
        }
        String string = this.getSelectedRange();
        super.tableChanged(tableModelEvent);
        if (this.fSetInitialSelection) {
            this.setInitialSelection();
            this.fSetInitialSelection = false;
        } else if (string != null && string.length() > 0) {
            this.setSelectedRanges(string);
        }
        this.updateColumnHeader();
        this.revalidate();
    }

    @Override
    public String getToolTipString(int n, int n2) {
        if (this.isRowExcluded(n)) {
            return this.getWorksheetTableModel().getRowExclusionRule(n).getSummaryComment();
        }
        if (this.isColumnExcluded(n2)) {
            return this.getWorksheetTableModel().getColumnExclusionRule(n2).getSummaryComment();
        }
        Object object = this.getWorksheetTableModel().getReplacedValueAt(n, n2);
        Object object2 = this.getWorksheetTableModel().getParsedValueAt(n, n2);
        if (object != null && object2 == null) {
            String string;
            if (object instanceof Double) {
                string = Double.toString((Double)object);
                string = WorksheetTable.truncateString(string);
            } else {
                string = (String)object;
            }
            return ImportToolUtils.getResourceString("RuleType.replacedby") + string;
        }
        if (object2 != null || this.getWorksheetTableModel() instanceof WorksheetTableModel && !this.getWorksheetTableModel().isUntreatedAt(n, n2)) {
            SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType = this.getColumnTargetType(n2);
            if (spreadsheetColumnTargetType != null) {
                Object object3 = this.getWorksheetTableModel().getConvertedValueAt(n, n2);
                if (object3 == null) {
                    object3 = object2;
                }
                if (object3 == null) {
                    object3 = this.getWorksheetTableModel().getValueAt(n, n2);
                }
                if (this.getWorksheetTableModel().getValueAt(n, n2) == null) {
                    return null;
                }
                Object object4 = this.getWorksheetTableModel().getValueAt(n, n2);
                String string = WorksheetTable.truncateString(object4.toString());
                String string2 = WorksheetTable.truncateString(object3.toString());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.convertedto"));
                stringBuilder.append("[");
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.type"));
                stringBuilder.append(spreadsheetColumnTargetType.toString());
                stringBuilder.append(", ");
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.value"));
                stringBuilder.append(string2);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        } else if (this.getWorksheetTableModel() instanceof WorksheetTableModel && this.getWorksheetTableModel().isUntreatedAt(n, n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ImportToolUtils.getResourceString("datatypes.unimportable"));
            return stringBuilder.toString();
        }
        return null;
    }

    public void createDefaultColumnsFromModel() {
        if (this.getColumnVariableNamesArray() == null) {
            super.createDefaultColumnsFromModel();
            return;
        }
        super.createDefaultColumnsFromModel();
        this.updateColumnHeader();
    }

    void addInitialSelectionListener() {
        this.fSetInitialSelection = true;
    }

    void setInitialSelection() {
        int[] nArray;
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        if (this.fImportSelectionModel != null && abstractFileTableModel instanceof WorksheetTableModel && (nArray = abstractFileTableModel.getInitialSelection()) != null && nArray.length == 4) {
            this.fImportSelectionModel.setSelection(nArray[0], nArray[2], nArray[1], nArray[3]);
        }
    }

    void rebuild() {
        Rectangle rectangle = this.getVisibleRect();
        this.getWorksheetTableModel().rebuild(this.rowAtPoint(new Point(rectangle.x, rectangle.y)), this.columnAtPoint(new Point(rectangle.x, rectangle.y)));
        this.updateColumnHeader();
        this.getTableHeader().validate();
        this.getTableHeader().repaint();
        this.revalidate();
    }

    @Override
    boolean isRowExcluded(int n) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        AbstractFileTableModel.ExcludedState excludedState = abstractFileTableModel.isRowExcluded(n, this.getSelectionModel(), this.getColumnModel().getSelectionModel());
        return excludedState == AbstractFileTableModel.ExcludedState.EXCLUDED;
    }

    @Override
    boolean isColumnExcluded(int n) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        AbstractFileTableModel.ExcludedState excludedState = abstractFileTableModel.isColumnExcluded(n, this.getSelectionModel(), this.getColumnModel().getSelectionModel());
        return excludedState == AbstractFileTableModel.ExcludedState.EXCLUDED;
    }

    void setWorksheetRules(List<WorksheetRule> list) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        abstractFileTableModel.setWorksheetRules(list);
        abstractFileTableModel.reset();
    }

    @Override
    public void cleanup() {
        if (this.fCleanedUp) {
            return;
        }
        this.fCleanedUp = true;
        this.removeMouseListener(this.fTmel);
        this.fTmel = null;
        this.getTableHeader().removeMouseListener(this.fThmel);
        this.getTableHeader().removeMouseMotionListener(this.fThmel);
        this.fThmel = null;
        this.removeFocusListener((FocusListener)this.fAFD);
        this.fAFD = null;
        this.getActionMap().clear();
        this.fSelectionPopupMenu.dispose();
        this.fSelectionPopupMenu = null;
        this.fSelectAllAction = null;
        this.fHeaderRenderer.cleanup();
        this.fHeaderRenderer = null;
        this.getImportSelectionModel().cleanup();
        if (this.getModel() instanceof WorksheetTableModel) {
            ((WorksheetTableModel)this.getModel()).cleanup();
        }
        super.cleanup();
    }

    String getSelectedRange() {
        if (this.fImportSelectionModel != null) {
            return this.fImportSelectionModel.getSelectedRange();
        }
        return null;
    }

    int[] getSelectionSizeAfterExclusion() {
        return this.fImportSelectionModel.getSelectionSizeAfterExclusion();
    }

    private List<Integer>[] getSpreadsheetColumnTargetLists() {
        int n;
        SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray = ((WorksheetTableModel)this.getWorksheetTableModel()).getSelectedColumnVectorTargetTypes(this.getSelectedColumns());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Object[] objectArray = new Integer[this.getSelectedColumnCount()];
        Object[] objectArray2 = new Integer[this.getSelectedColumnCount()];
        Arrays.fill(objectArray, (Object)-1);
        Arrays.fill(objectArray2, (Object)-1);
        List<Object> list = Arrays.asList(objectArray);
        List<Object> list2 = Arrays.asList(objectArray2);
        for (n = 0; n < spreadsheetColumnTargetTypeArray.length; ++n) {
            if (spreadsheetColumnTargetTypeArray[n] == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY) {
                arrayList.add(n);
                continue;
            }
            arrayList2.add(n);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list.set((Integer)arrayList.get(n), n);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            list2.set((Integer)arrayList2.get(n), n);
        }
        return new List[]{list, list2};
    }

    @Override
    synchronized String getAllocationFcn() {
        return this.getTargetType().getAllocationFcn();
    }

    @Override
    public void generateMatlabScript() {
        this.utGenerateCode(TextCodeFactory.CodeType.SCRIPT, null);
    }

    @Override
    public void generateMatlabFunction(String string) {
        this.utGenerateCode(TextCodeFactory.CodeType.FUNCTION, string);
    }

    boolean isUntreatedDataInSelection() {
        IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)this.getSelectionModel();
        IntervalSelectionModel intervalSelectionModel2 = (IntervalSelectionModel)this.getColumnModel().getSelectionModel();
        if (this.isCellArray()) {
            return intervalSelectionModel.getSelectionCount() <= 0 || intervalSelectionModel2.getSelectionCount() <= 0;
        }
        return this.getWorksheetTableModel().containsUntreatedCells(intervalSelectionModel, intervalSelectionModel2);
    }

    private void utGenerateCode(final TextCodeFactory.CodeType codeType, final String string) {
        String[] stringArray = this.getSelectedColumnVariableNames();
        boolean bl = this.validateUniqueNames(stringArray);
        if (!bl) {
            return;
        }
        final GeneratedCode generatedCode = new GeneratedCode(GeneratedCode.DATE_FORMAT.EXCEL_DATE);
        MatlabWorker<SpreadsheetImportUIState> matlabWorker = new MatlabWorker<SpreadsheetImportUIState>(){

            public SpreadsheetImportUIState runOnMatlabThread() {
                SpreadsheetImportUIState spreadsheetImportUIState = new SpreadsheetImportUIState();
                if (WorksheetTable.this.getTargetType() == ImportClient.TargetType.COLUMNVECTORS || WorksheetTable.this.getTargetType() == ImportClient.TargetType.DATASET || WorksheetTable.this.getTargetType() == ImportClient.TargetType.TABLE) {
                    spreadsheetImportUIState.setSelectedColumnNames(WorksheetTable.this.getSelectedColumnVariableNames());
                    spreadsheetImportUIState.setValidatedSelectedColumnNames(ImportCodeFactory.validateVariableNames(WorksheetTable.this.getSelectedColumnVariableNames()));
                }
                if (WorksheetTable.this.getTargetType() == ImportClient.TargetType.MATRIX || WorksheetTable.this.getTargetType() == ImportClient.TargetType.DATASET || WorksheetTable.this.getTargetType() == ImportClient.TargetType.CELLARRAY || WorksheetTable.this.getTargetType() == ImportClient.TargetType.TABLE) {
                    spreadsheetImportUIState.setGlobalVariableName(WorksheetTable.this.getMatrixVariableName());
                    spreadsheetImportUIState.setValidatedGlobalVariableName(ImportCodeFactory.validateVariableName(WorksheetTable.this.getMatrixVariableName()));
                }
                return spreadsheetImportUIState;
            }

            public void runOnAWTEventDispatchThread(SpreadsheetImportUIState spreadsheetImportUIState) {
                List<int[]> list = ((IntervalSelectionModel)WorksheetTable.this.getSelectionModel()).getSelectedIntervals();
                spreadsheetImportUIState.setSelectedRowIntervals(list);
                List<int[]> list2 = ((IntervalSelectionModel)WorksheetTable.this.getColumnModel().getSelectionModel()).getSelectedIntervals();
                spreadsheetImportUIState.setSelectedColumnIntervals(list2);
                spreadsheetImportUIState.setSelectedColumnCount(WorksheetTable.this.getSelectedColumnCount());
                spreadsheetImportUIState.setTarget(WorksheetTable.this.getTargetType());
                ((WorksheetTableModel)WorksheetTable.this.getWorksheetTableModel()).populateSpreadsheetImportUIState(spreadsheetImportUIState, WorksheetTable.this.getSelectedRange(), WorksheetTable.this.getSelectedColumns());
                spreadsheetImportUIState.setRangeArray(WorksheetTable.this.fImportSelectionModel.getSelectedRangeArray());
                ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
                int n = 0;
                if (WorksheetTable.this.getWorksheetTableModel().getWorksheetRules() != null) {
                    for (WorksheetRule worksheetRule : WorksheetTable.this.getWorksheetTableModel().getWorksheetRules()) {
                        if (!WorksheetTable.this.isRuleClassAppliedToSelection(worksheetRule.getClass())) continue;
                        arrayList.add(worksheetRule);
                        if (!worksheetRule.isColumnExcludeType()) continue;
                        ++n;
                    }
                }
                spreadsheetImportUIState.setActiveRules(arrayList);
                spreadsheetImportUIState.setActiveColumnExclusionRuleCount(n);
                if (codeType == TextCodeFactory.CodeType.SCRIPT) {
                    SpreadsheetCodeFactory.generateScript(generatedCode, spreadsheetImportUIState);
                } else {
                    SpreadsheetCodeFactory.generateFunction(generatedCode, spreadsheetImportUIState, string);
                }
                ImportToolstripTab.editGeneratedCode(generatedCode.getCode());
            }
        };
        matlabWorker.start();
    }

    @Override
    public void setTargetType(ImportClient.TargetType targetType) {
        super.setTargetType(targetType);
        if (this.getModel() instanceof AbstractFileTableModel) {
            ((AbstractFileTableModel)this.getModel()).setTargetType(targetType);
        }
        List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> list = ((WorksheetTableModel)this.getModel()).getDefaultColumnTargetTypes();
        ((SpreadsheetTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).setShowTargetTypes(targetType, list);
    }

    public void showTargetTypeDropDown(int n) {
        ((SpreadsheetTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).showListItemPopup(n);
    }

    public void hideTargetTypeDropDown() {
        ((SpreadsheetTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).hideListItemPopup();
    }

    public SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType getColumnTargetType(int n) {
        return ((WorksheetTableModel)this.getWorksheetTableModel()).getColumnTargetType(n);
    }

    public void setColumnTargetType(int n, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
        ((WorksheetTableModel)this.getWorksheetTableModel()).setColumnTargetType(n, spreadsheetColumnTargetType);
        SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetTableHeaderRenderer.SpreadsheetImportDataHeader)this.getColumnModel().getColumn(n).getHeaderValue();
        spreadsheetImportDataHeader.setColumnTarget(spreadsheetColumnTargetType);
        this.getColumnModel().getColumn(n).setHeaderValue(spreadsheetImportDataHeader);
    }

    void addColumnAdjustmentListener(TableColumnModelListener tableColumnModelListener) {
        this.getColumnModel().removeColumnModelListener(tableColumnModelListener);
        this.getColumnModel().addColumnModelListener(tableColumnModelListener);
    }

    void removeColumnAdjustmentListener(TableColumnModelListener tableColumnModelListener) {
        this.getColumnModel().removeColumnModelListener(tableColumnModelListener);
    }

    protected class TableMouseEventListener
    extends MouseAdapter {
        protected TableMouseEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            WorksheetTable.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            WorksheetTable.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
        }
    }
}

