/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.desktop.client.Client;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ImportToolstripTab;
import com.mathworks.mlwidgets.importtool.MoreOptionsDropDownButton;
import com.mathworks.mlwidgets.importtool.popuplist.DelimiterPopupButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSRadioButton;
import com.mathworks.toolstrip.sections.ToolstripSections;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;

public class TextToolstripTab
extends ImportToolstripTab {
    final Icon checkUnselected = ImportToolUtils.getResourceIcon("checkbox_unchecked.png");
    final Icon checkSelected = ImportToolUtils.getResourceIcon("checkbox_checked.png");
    private DelimiterPopupButton fDelimiterCombo;
    private MoreOptionsDropDownButton fMoreOptionsCombo;
    private TSRadioButton fFixedwidthRadio;
    private TSRadioButton fDelimitedRadio;
    private ArrayList<TextFileTypeListener> fTextFileTypeListeners = new ArrayList();

    TextToolstripTab(String string, boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        TSPanel tSPanel = new TSPanel((LayoutManager)new GridLayout(2, 1, 0, 0));
        this.fDelimitedRadio = new TSRadioButton(ImportToolUtils.getResourceString("toolstrip.delimited"), true);
        this.fDelimitedRadio.setName("DelimitedRadio");
        this.fFixedwidthRadio = new TSRadioButton(ImportToolUtils.getResourceString("toolstrip.fixedWidth"), false);
        this.fFixedwidthRadio.setName("FixedWidthRadio");
        buttonGroup.add((AbstractButton)this.fDelimitedRadio);
        buttonGroup.add((AbstractButton)this.fFixedwidthRadio);
        tSPanel.add((Component)this.fDelimitedRadio);
        tSPanel.add((Component)this.fFixedwidthRadio);
        TSPanel tSPanel2 = new TSPanel((LayoutManager)new BorderLayout());
        tSPanel2.add((Component)tSPanel, (Object)"West");
        this.fDelimitedRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TextToolstripTab.this.fDelimiterCombo.isEnabled()) {
                    return;
                }
                TextToolstripTab.this.fireTextFileTypeChanged(TextFileType.DELIMITED);
                TextToolstripTab.this.fDelimiterCombo.setEnabled(true);
                TextToolstripTab.this.fMoreOptionsCombo.getCoalesceDelimitersItem().setEnabled(true);
            }
        });
        this.fFixedwidthRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TextToolstripTab.this.fDelimiterCombo.isEnabled()) {
                    return;
                }
                TextToolstripTab.this.fireTextFileTypeChanged(TextFileType.FIXEDWIDTH);
                TextToolstripTab.this.fDelimiterCombo.setEnabled(false);
                TextToolstripTab.this.fMoreOptionsCombo.getCoalesceDelimitersItem().setEnabled(false);
            }
        });
        this.fDelimiterCombo = new DelimiterPopupButton(ImportToolUtils.getResourceString("delimiter.delimiter"));
        this.fDelimiterCombo.setName("DelimiterPopupButton");
        this.fDelimiterCombo.setMinimumSize(new Dimension(110, this.fDelimiterCombo.getPreferredSize().height));
        this.fDelimiterCombo.setPreferredSize(new Dimension(110, this.fDelimiterCombo.getPreferredSize().height));
        this.fMoreOptionsCombo = new MoreOptionsDropDownButton();
        this.fMoreOptionsCombo.setName("MoreOptionsDropDownButton");
        this.fMoreOptionsCombo.setMinimumSize(new Dimension(110, this.fDelimiterCombo.getPreferredSize().height));
        this.fMoreOptionsCombo.setPreferredSize(new Dimension(110, this.fDelimiterCombo.getPreferredSize().height));
        FormLayout formLayout = new FormLayout("left:pref,10px,left:pref:grow", "5px,pref,5px,pref,5px,pref");
        MJPanel mJPanel = new MJPanel((LayoutManager)formLayout);
        mJPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)tSPanel2, (Object)cellConstraints.xywh(1, 2, 1, 5));
        TSLabel tSLabel = new TSLabel(ImportToolUtils.getResourceString("toolstrip.columnDelimiters"));
        mJPanel.add((Component)tSLabel, (Object)cellConstraints.xy(3, 2));
        mJPanel.add((Component)((Object)this.fDelimiterCombo), (Object)cellConstraints.xy(3, 4, CellConstraints.LEFT, CellConstraints.DEFAULT));
        mJPanel.add((Component)((Object)this.fMoreOptionsCombo), (Object)cellConstraints.xy(3, 6));
        this.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"Delimiters", (String)ImportToolUtils.getResourceString("toolstrip.delimiters")).add((JComponent)mJPanel).build());
        this.setShowCodeGeneration(bl);
        this.init(string);
    }

    void setFixedWidth(boolean bl) {
        if (bl) {
            this.fFixedwidthRadio.setSelected(true);
        } else {
            this.fDelimitedRadio.setSelected(true);
        }
    }

    void setTextFileTypeEnabled(TextFileType textFileType, boolean bl) {
        if (textFileType == TextFileType.DELIMITED) {
            this.fDelimitedRadio.setEnabled(bl);
        } else if (textFileType == TextFileType.FIXEDWIDTH) {
            this.fFixedwidthRadio.setEnabled(bl);
        }
    }

    @Override
    JList getTargetList() {
        return this.fTargetList;
    }

    DelimiterPopupButton getDelimiterComboBox() {
        return this.fDelimiterCombo;
    }

    MoreOptionsDropDownButton getMoreOptionsComboBox() {
        return this.fMoreOptionsCombo;
    }

    public void addTextFileTypeListener(TextFileTypeListener textFileTypeListener) {
        this.fTextFileTypeListeners.add(textFileTypeListener);
    }

    public void removeTextFileTypeListener(TextFileTypeListener textFileTypeListener) {
        this.fTextFileTypeListeners.remove(textFileTypeListener);
    }

    private void fireTextFileTypeChanged(TextFileType textFileType) {
        for (int i = 0; i < this.fTextFileTypeListeners.size(); ++i) {
            this.fTextFileTypeListeners.get(i).textFileTypeChanged(textFileType);
        }
    }

    static interface TextFileTypeListener {
        public void textFileTypeChanged(TextFileType var1);
    }

    static enum TextFileType {
        DELIMITED,
        FIXEDWIDTH;

    }

    static interface DelimiterListener {
        public void delimiterChanged(String var1);
    }
}

